/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.capistrano.ui.wizard;

import com.aptana.core.logging.IdeLog;
import com.aptana.deploy.capistrano.CapistranoPlugin;
import com.aptana.deploy.capistrano.ui.wizard.CapistranoDeployWizard;
import com.aptana.deploy.capistrano.ui.wizard.Messages;
import com.aptana.terminal.widget.TerminalComposite;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class CapifyProjectPage
extends WizardPage {
    public static final String NAME = "CapifyProject";
    private TerminalComposite terminalComposite;
    protected Job checkCapifiedJob;

    protected CapifyProjectPage() {
        super(NAME, Messages.CapifyProjectPage_Title, null);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.setControl((Control)composite);
        this.initializeDialogUnits((Control)parent);
        Label label = new Label(composite, 64);
        label.setText(Messages.CapifyProjectPage_Description);
        label.setLayoutData((Object)new GridData(500, -1));
        Button generateButton = new Button(composite, 8);
        generateButton.setText(Messages.CapifyProjectPage_GenerateButtonLabel);
        generateButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        generateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!CapifyProjectPage.this.terminalComposite.isEmpty()) {
                    CapifyProjectPage.this.terminalComposite.clear();
                }
                CapifyProjectPage.this.terminalComposite.sendInput("capify .\n");
                if (CapifyProjectPage.this.checkCapifiedJob == null) {
                    CapifyProjectPage.this.checkCapifiedJob = new Job("Checking if config/deploy.rb exists"){

                        protected IStatus run(IProgressMonitor monitor) {
                            if (monitor != null && monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            if (CapifyProjectPage.this.isPageComplete()) {
                                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        CapifyProjectPage.this.getContainer().updateButtons();
                                    }
                                });
                            } else {
                                this.schedule(1000L);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    CapifyProjectPage.this.checkCapifiedJob.setSystem(true);
                }
                CapifyProjectPage.this.checkCapifiedJob.cancel();
                CapifyProjectPage.this.checkCapifiedJob.schedule(1000L);
            }
        });
        this.terminalComposite = new TerminalComposite(composite, 0);
        this.terminalComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.terminalComposite.setWorkingDirectory(this.getProject().getLocation());
        this.terminalComposite.connect();
        Link link = new Link(composite, 0);
        link.setText(Messages.CapifyProjectPage_LinkText);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                try {
                    IWebBrowser browser = support.createBrowser(32, "capify", null, null);
                    browser.openURL(new URL(e.text));
                }
                catch (Exception e1) {
                    IdeLog.logError((Plugin)CapistranoPlugin.getDefault(), (Throwable)e1);
                }
            }
        });
        Dialog.applyDialogFont((Control)composite);
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public boolean isPageComplete() {
        IProject project = this.getProject();
        IFile deployFile = project.getFile(new Path("config").append("deploy.rb"));
        return deployFile != null && deployFile.exists();
    }

    protected IProject getProject() {
        return ((CapistranoDeployWizard)this.getWizard()).getProject();
    }

    public void dispose() {
        try {
            if (this.checkCapifiedJob != null) {
                this.checkCapifiedJob.cancel();
                this.checkCapifiedJob = null;
            }
        }
        finally {
            super.dispose();
        }
    }
}

