/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.internal;

import com.aptana.core.util.ExpiringMap;
import com.aptana.deploy.IDeployProvider;
import com.aptana.deploy.internal.DeployProviderRegistry;
import com.aptana.deploy.internal.DeployValues;
import com.aptana.deploy.preferences.DeployPreferenceUtil;
import com.aptana.deploy.util.DeployProviderUtil;
import java.util.Map;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;

public class ProjectPropertyTester
extends PropertyTester {
    private static Map<String, DeployValues> containerCache = new ExpiringMap(300000L);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IResource resource = this.getResource(receiver);
        if (resource == null) return false;
        IContainer container = receiver instanceof IContainer ? (IContainer)resource : resource.getParent();
        if (!container.isAccessible()) {
            return false;
        }
        IPath location = container.getLocation();
        if (location == null) {
            return false;
        }
        if ("isDeployable".equals(property)) {
            DeployValues deployValues = containerCache.get(location.toOSString());
            if (deployValues != null) {
                Boolean deployableValue = deployValues.getDeployableValue();
                if (deployableValue == null) return false;
                return deployableValue;
            }
            deployValues = ProjectPropertyTester.resetCache(container);
            return deployValues.getDeployableValue();
        }
        if (!"isDeployType".equals(property)) return false;
        String arg = (String)expectedValue;
        DeployValues deployValues = containerCache.get(location.toOSString());
        if (deployValues != null) {
            Boolean deployTypeValue = deployValues.getDeployTypeValue(arg);
            if (deployTypeValue != null) {
                return deployTypeValue;
            }
        } else {
            deployValues = ProjectPropertyTester.resetCache(container);
        }
        boolean isDeployType = this.isDeployType(container, arg);
        deployValues.setDeployTypeValue(arg, isDeployType);
        return isDeployType;
    }

    private boolean isDeployType(IContainer container, String arg) {
        String id = DeployPreferenceUtil.getDeployProviderId(container);
        if (id != null) {
            return arg.equals(id);
        }
        IDeployProvider provider = DeployProviderRegistry.getInstance().getProviderById(arg);
        return provider != null && provider.handles(container);
    }

    public static DeployValues resetCache(IContainer container) {
        containerCache.clear();
        DeployValues deployValues = new DeployValues();
        containerCache.put(container.getLocation().toOSString(), deployValues);
        boolean deployableValue = ProjectPropertyTester.isDeployable(container);
        deployValues.setDeployableValue(deployableValue);
        return deployValues;
    }

    private static boolean isDeployable(IContainer container) {
        String id = DeployPreferenceUtil.getDeployProviderId(container);
        if (id != null) {
            return !"".equals(id);
        }
        IDeployProvider provider = DeployProviderRegistry.getInstance().getProvider(container);
        if (provider != null) {
            DeployPreferenceUtil.setDeployType(container, DeployProviderUtil.getIdForProvider(provider));
            return true;
        }
        DeployPreferenceUtil.setDeployType(container, "");
        return false;
    }

    private IResource getResource(Object receiver) {
        if (receiver instanceof IResource) {
            return (IResource)receiver;
        }
        if (receiver instanceof IAdaptable) {
            return (IResource)((IAdaptable)receiver).getAdapter(IResource.class);
        }
        return null;
    }
}

