/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.coffee;

import com.aptana.editor.coffee.CoffeeScopeType;
import com.aptana.editor.coffee.parsing.lexer.CoffeeScanner;
import com.aptana.editor.common.text.rules.CharacterMapRule;
import com.aptana.editor.common.text.rules.QueuedRuleBasedScanner;
import com.aptana.editor.common.text.rules.WhitespaceDetector;
import com.aptana.editor.js.text.rules.JSIdentifierDetector;
import com.aptana.editor.js.text.rules.JSNumberRule;
import com.aptana.editor.js.text.rules.JSOperatorDetector;
import com.aptana.js.core.JSLanguageConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoffeeCodeScanner
extends QueuedRuleBasedScanner {
    private IToken lastToken;
    private Integer fOrigOffset;
    private Integer fLength;
    private boolean inFunctionDefinition;
    private boolean inClassDecl;
    private boolean inFunctionArgs;
    private static Map<Object, IToken> fgTokenCache = new HashMap<Object, IToken>();

    public CoffeeCodeScanner() {
        this.initRules();
    }

    protected void addWordRules(WordRule wordRule, IToken keywordOperators, Collection<String> words) {
        this.addWordRules(wordRule, keywordOperators, words.toArray(new String[words.size()]));
    }

    protected void addWordRules(WordRule wordRule, IToken keywordOperators, String ... words) {
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            wordRule.addWord(word, keywordOperators);
            ++n2;
        }
    }

    protected void initRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new JSIdentifierDetector(), Token.UNDEFINED);
        this.addWordRules(wordRule, this.createToken((Object)CoffeeScopeType.CONTROL_KEYWORD), CoffeeScanner.JS_KEYWORDS);
        this.addWordRules(wordRule, this.createToken((Object)CoffeeScopeType.CONTROL_KEYWORD), CoffeeScanner.COFFEE_KEYWORDS);
        this.addWordRules(wordRule, this.createToken((Object)CoffeeScopeType.TRUE), "true", "yes", "on");
        this.addWordRules(wordRule, this.createToken((Object)CoffeeScopeType.FALSE), "false", "no", "off");
        this.addWordRules(wordRule, this.createToken((Object)CoffeeScopeType.NULL), "null");
        this.addWordRules(wordRule, this.createToken((Object)CoffeeScopeType.LANGUAGE_VARIABLE), "super", "this", "extends");
        this.addWordRules(wordRule, this.createToken((Object)CoffeeScopeType.LANGUAGE_CONSTANT), "Infinity", "NaN", "undefined");
        this.addWordRules(wordRule, this.createToken((Object)CoffeeScopeType.NEW), "new");
        this.addWordRules(wordRule, this.createToken((Object)CoffeeScopeType.EXTENDS), "extends");
        this.addWordRules(wordRule, this.createToken((Object)CoffeeScopeType.CLASS), "class");
        rules.add(wordRule);
        wordRule = new WordRule((IWordDetector)new InstanceVariableDetector(), this.createToken((Object)CoffeeScopeType.INSTANCE_VARIABLE));
        rules.add(wordRule);
        wordRule = new WordRule((IWordDetector)new MultiplePeriodsDetector(), Token.UNDEFINED);
        this.addWordRules(wordRule, this.createToken((Object)CoffeeScopeType.INCLUSIVE_RANGE), "..");
        this.addWordRules(wordRule, this.createToken((Object)CoffeeScopeType.EXCLUSIVE_RANGE), "...");
        rules.add(wordRule);
        JSOperatorDetector operatorDetector = new JSOperatorDetector();
        operatorDetector.addWord("->");
        operatorDetector.addWord("=>");
        wordRule = new WordRule((IWordDetector)operatorDetector, Token.UNDEFINED);
        this.addWordRules(wordRule, this.createToken((Object)CoffeeScopeType.OPERATOR), JSLanguageConstants.OPERATORS);
        this.addWordRules(wordRule, this.createToken((Object)CoffeeScopeType.FUNC), "->");
        this.addWordRules(wordRule, this.createToken((Object)CoffeeScopeType.BOUND_FUNC), "=>");
        rules.add(wordRule);
        CharacterMapRule cmRule = new CharacterMapRule();
        cmRule.add(':', this.createToken((Object)CoffeeScopeType.COLON));
        cmRule.add(';', this.createToken((Object)CoffeeScopeType.SEMICOLON));
        cmRule.add('(', this.createToken((Object)CoffeeScopeType.LEFT_PAREN));
        cmRule.add(')', this.createToken((Object)CoffeeScopeType.RIGHT_PAREN));
        cmRule.add('[', this.createToken((Object)CoffeeScopeType.LEFT_BRACKET));
        cmRule.add(']', this.createToken((Object)CoffeeScopeType.RIGHT_BRACKET));
        cmRule.add('{', this.createToken((Object)CoffeeScopeType.LEFT_CURLY));
        cmRule.add('}', this.createToken((Object)CoffeeScopeType.RIGHT_CURLY));
        cmRule.add(',', this.createToken((Object)CoffeeScopeType.COMMA));
        cmRule.add('.', this.createToken((Object)CoffeeScopeType.PERIOD));
        cmRule.add('=', this.createToken((Object)CoffeeScopeType.EQUAL));
        rules.add(cmRule);
        CharacterMapRule rule = new CharacterMapRule();
        char[] cArray = JSLanguageConstants.SINGLE_CHARACTER_OPERATORS;
        int n = JSLanguageConstants.SINGLE_CHARACTER_OPERATORS.length;
        int n2 = 0;
        while (n2 < n) {
            char operator = cArray[n2];
            rule.add(operator, this.createToken((Object)CoffeeScopeType.OPERATOR));
            ++n2;
        }
        rules.add(rule);
        rules.add(new JSNumberRule(this.createToken((Object)CoffeeScopeType.NUMERIC)));
        rules.add(new WordRule((IWordDetector)new JSIdentifierDetector(), this.createToken((Object)CoffeeScopeType.IDENTIFIER)));
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }

    public IToken nextToken() {
        int length;
        this.fOrigOffset = null;
        this.fLength = null;
        IToken currentToken = super.nextToken();
        if (currentToken.isEOF()) {
            return currentToken;
        }
        if (this.inClassDecl && currentToken.isWhitespace() && this.hasNewline(this.getTokenOffset(), this.getTokenLength())) {
            this.inClassDecl = false;
        }
        if (CoffeeScopeType.CLASS == currentToken.getData()) {
            this.inClassDecl = true;
        }
        if (this.lastToken != null && currentToken.isOther()) {
            if (CoffeeScopeType.NEW == this.lastToken.getData()) {
                currentToken = this.createToken((Object)CoffeeScopeType.ENTITY_TYPE_INSTANCE);
            } else if (CoffeeScopeType.EXTENDS == this.lastToken.getData()) {
                currentToken = this.createToken((Object)CoffeeScopeType.SUPERCLASS);
            } else if (CoffeeScopeType.CLASS == this.lastToken.getData()) {
                currentToken = this.createToken((Object)CoffeeScopeType.CLASS_NAME);
            }
        }
        if (this.inFunctionDefinition) {
            if (CoffeeScopeType.LEFT_PAREN == currentToken.getData() || CoffeeScopeType.RIGHT_PAREN == currentToken.getData() || CoffeeScopeType.IDENTIFIER == currentToken.getData()) {
                if (CoffeeScopeType.LEFT_PAREN == currentToken.getData()) {
                    this.inFunctionArgs = true;
                }
                currentToken = this.createToken("variable.parameter.function.coffee");
            } else if (CoffeeScopeType.COLON == currentToken.getData()) {
                currentToken = this.createToken("keyword.operator.coffee");
            } else if (CoffeeScopeType.FUNC == currentToken.getData() || CoffeeScopeType.BOUND_FUNC == currentToken.getData()) {
                this.inFunctionArgs = true;
            }
        } else if (CoffeeScopeType.IDENTIFIER == currentToken.getData()) {
            length = this.getTokenLength();
            int offset = this.getTokenOffset();
            ArrayList<QueuedRuleBasedScanner.Entry> entries = new ArrayList<QueuedRuleBasedScanner.Entry>();
            IToken ahead = super.nextToken();
            entries.add(new QueuedRuleBasedScanner.Entry(null, ahead, this.getTokenOffset(), this.getTokenLength()));
            while (ahead != null && !ahead.isEOF() && !ahead.isOther()) {
                ahead = super.nextToken();
                entries.add(new QueuedRuleBasedScanner.Entry(null, ahead, this.getTokenOffset(), this.getTokenLength()));
            }
            if (CoffeeScopeType.EQUAL == ahead.getData() || CoffeeScopeType.COLON == ahead.getData()) {
                while (!ahead.isEOF()) {
                    QueuedRuleBasedScanner.Entry lastEntry;
                    ahead = super.nextToken();
                    entries.add(new QueuedRuleBasedScanner.Entry(null, ahead, this.getTokenOffset(), this.getTokenLength()));
                    if (CoffeeScopeType.FUNC == ahead.getData() || CoffeeScopeType.BOUND_FUNC == ahead.getData()) {
                        this.inFunctionDefinition = true;
                        currentToken = this.createToken((Object)CoffeeScopeType.FUNCTION_NAME);
                        break;
                    }
                    if (ahead.isWhitespace() && this.hasNewline((lastEntry = (QueuedRuleBasedScanner.Entry)entries.get(entries.size() - 1)).getTokenOffset(), lastEntry.getTokenLength())) break;
                }
                if (!this.inFunctionDefinition) {
                    currentToken = this.createToken("variable.assignment.coffee");
                }
            }
            LinkedList<QueuedRuleBasedScanner.Entry> newQueue = new LinkedList<QueuedRuleBasedScanner.Entry>(entries);
            newQueue.addAll(entries);
            newQueue.addAll(this.queue);
            this.queue.clear();
            this.queue.addAll(newQueue);
            this.fOrigOffset = offset;
            this.fLength = length;
        } else if (CoffeeScopeType.LEFT_PAREN == currentToken.getData()) {
            length = this.getTokenLength();
            int offset = this.getTokenOffset();
            ArrayList<QueuedRuleBasedScanner.Entry> entries = new ArrayList<QueuedRuleBasedScanner.Entry>();
            IToken ahead = super.nextToken();
            entries.add(new QueuedRuleBasedScanner.Entry(null, ahead, this.getTokenOffset(), this.getTokenLength()));
            while (!ahead.isEOF()) {
                QueuedRuleBasedScanner.Entry lastEntry;
                ahead = super.nextToken();
                entries.add(new QueuedRuleBasedScanner.Entry(null, ahead, this.getTokenOffset(), this.getTokenLength()));
                if (CoffeeScopeType.FUNC == ahead.getData() || CoffeeScopeType.BOUND_FUNC == ahead.getData()) {
                    this.inFunctionArgs = true;
                    this.inFunctionDefinition = true;
                    currentToken = this.createToken("variable.parameter.function.coffee");
                    break;
                }
                if (ahead.isWhitespace() && this.hasNewline((lastEntry = (QueuedRuleBasedScanner.Entry)entries.get(entries.size() - 1)).getTokenOffset(), lastEntry.getTokenLength())) break;
            }
            LinkedList<QueuedRuleBasedScanner.Entry> newQueue = new LinkedList<QueuedRuleBasedScanner.Entry>(entries);
            newQueue.addAll(entries);
            newQueue.addAll(this.queue);
            this.queue.clear();
            this.queue.addAll(newQueue);
            this.fOrigOffset = offset;
            this.fLength = length;
        }
        StringBuilder builder = new StringBuilder();
        if (this.inClassDecl) {
            builder.append("meta.class.coffee").append(' ');
        }
        if (this.inFunctionArgs) {
            builder.append("meta.inline.function.coffee").append(' ');
        }
        if (currentToken.getData() != null) {
            builder.append(currentToken.getData().toString());
        }
        if (CoffeeScopeType.SUPERCLASS == currentToken.getData() && this.inClassDecl) {
            this.inClassDecl = false;
        } else if (this.inFunctionDefinition && (CoffeeScopeType.BOUND_FUNC == currentToken.getData() || CoffeeScopeType.FUNC == currentToken.getData())) {
            this.inFunctionDefinition = false;
            this.inFunctionArgs = false;
        }
        if (currentToken.isOther()) {
            this.lastToken = currentToken;
        }
        if (builder.length() > 0 || currentToken.isOther()) {
            return this.createToken(builder.toString().trim());
        }
        return currentToken;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasNewline(int tokenOffset, int tokenLength) {
        String[] lineDelims = this.fDocument.getLegalLineDelimiters();
        try {
            String src = this.fDocument.get(tokenOffset, tokenLength);
            String[] stringArray = lineDelims;
            int n = lineDelims.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String lineDelim = stringArray[n2];
                if (src.contains(lineDelim)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.lastToken = null;
        this.inFunctionDefinition = false;
        this.inClassDecl = false;
        this.inFunctionArgs = false;
        this.fOrigOffset = null;
        this.fLength = null;
        super.setRange(document, offset, length);
    }

    protected synchronized IToken createToken(Object obj) {
        if (!fgTokenCache.containsKey(obj)) {
            fgTokenCache.put(obj, (IToken)new Token(obj));
        }
        return fgTokenCache.get(obj);
    }

    public int getTokenLength() {
        if (this.fLength != null) {
            return this.fLength;
        }
        return super.getTokenLength();
    }

    public int getTokenOffset() {
        if (this.fOrigOffset != null) {
            return this.fOrigOffset;
        }
        return super.getTokenOffset();
    }

    private static class InstanceVariableDetector
    implements IWordDetector {
        private InstanceVariableDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '@';
        }

        public boolean isWordPart(char c) {
            return Character.isLetterOrDigit(c) || c == '_' || c == '$';
        }
    }

    private static class MultiplePeriodsDetector
    implements IWordDetector {
        private MultiplePeriodsDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '.';
        }

        public boolean isWordPart(char c) {
            return this.isWordStart(c);
        }
    }
}

