/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rcp;

import com.aptana.commandline.launcher.CommandlineArgumentsHandler;
import com.aptana.commandline.launcher.server.LauncherServer;
import com.aptana.commandline.launcher.server.port.PortManager;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.PlatformUtil;
import com.aptana.rcp.DelayedEventsProcessor;
import com.aptana.rcp.IDEIdleHelper;
import com.aptana.rcp.IDEWorkbenchWindowAdvisor;
import com.aptana.rcp.IdePlugin;
import com.aptana.rcp.InstallCommandLineExecutableJob;
import com.aptana.rcp.Messages;
import com.ibm.icu.text.Collator;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdatePlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Policy;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ISelectionConversionService;
import org.eclipse.ui.internal.PluginActionBuilder;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDESelectionConversionService;
import org.eclipse.ui.internal.ide.IDEWorkbenchActivityHelper;
import org.eclipse.ui.internal.ide.IDEWorkbenchErrorHandler;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.undo.WorkspaceUndoMonitor;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.statushandlers.AbstractStatusHandler;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDEWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static final String WORKBENCH_PREFERENCE_CATEGORY_ID = "org.eclipse.ui.preferencePages.Workbench";
    private static final String FORCED_AUTOMATIC_UPDATE = "FORCED_AUTOMATIC_UPDATE";
    private static final String INSTALLED_FEATURES = "installedFeatures";
    private static final String[] IGNORED_STATUS_MESSAGES = new String[]{"Keybinding conflicts occurred"};
    private static IDEWorkbenchAdvisor workbenchAdvisor = null;
    private WorkbenchWindowAdvisor workbenchWindowAdvisor;
    private String workspaceLocation = null;
    private Map<String, AboutInfo> newlyAddedBundleGroups;
    private AboutInfo[] welcomePerspectiveInfos = null;
    private IDEWorkbenchActivityHelper activityHelper = null;
    private IDEIdleHelper idleHelper;
    private Listener settingsChangeListener;
    private WorkspaceUndoMonitor workspaceUndoMonitor;
    private AbstractStatusHandler ideWorkbenchErrorHandler;
    private DelayedEventsProcessor delayedEventsProcessor;
    private final String[] args;

    public IDEWorkbenchAdvisor(DelayedEventsProcessor processor, String[] args) {
        this.delayedEventsProcessor = processor;
        this.args = args;
        if (workbenchAdvisor != null) {
            throw new IllegalStateException();
        }
        workbenchAdvisor = this;
        Listener closeListener = new Listener(){

            public void handleEvent(Event event) {
                boolean doExit;
                event.doit = doExit = IDEWorkbenchWindowAdvisor.promptOnExit(null);
                if (!doExit) {
                    event.type = 0;
                }
            }
        };
        Display.getDefault().addListener(21, closeListener);
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        PluginActionBuilder.setAllowIdeLogging((boolean)true);
        configurer.setSaveAndRestore(true);
        IDE.registerAdapters();
        String[] cmdLineArgs = Platform.getCommandLineArgs();
        int i = 0;
        while (i < cmdLineArgs.length) {
            if ("-showlocation".equalsIgnoreCase(cmdLineArgs[i])) {
                String name = null;
                if (cmdLineArgs.length > i + 1) {
                    name = cmdLineArgs[i + 1];
                }
                if (name != null && name.indexOf("-") == -1) {
                    this.workspaceLocation = name;
                    break;
                }
                this.workspaceLocation = Platform.getLocation().toOSString();
                break;
            }
            ++i;
        }
        this.declareWorkbenchImages();
        this.activityHelper = IDEWorkbenchActivityHelper.getInstance();
        this.idleHelper = new IDEIdleHelper(configurer);
        this.workspaceUndoMonitor = WorkspaceUndoMonitor.getInstance();
        TrayDialog.setDialogHelpAvailable((boolean)true);
        Policy.setComparator((Comparator)Collator.getInstance());
    }

    public void preStartup() {
        Job.getJobManager().suspend();
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        ImageDescriptor newImage = IDEInternalWorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_BUILD_EXEC");
        service.registerIconForFamily(newImage, ResourcesPlugin.FAMILY_MANUAL_BUILD);
        service.registerIconForFamily(newImage, ResourcesPlugin.FAMILY_AUTO_BUILD);
        BundleContext context = IdePlugin.getDefault().getBundle().getBundleContext();
        if (context == null) {
            return;
        }
        ServiceReference ref = context.getServiceReference(EnvironmentInfo.class);
        if (ref == null) {
            return;
        }
        EnvironmentInfo info = (EnvironmentInfo)context.getService(ref);
        if (info != null) {
            String productVersion = EclipseUtil.getProductVersion();
            if (productVersion == null) {
                productVersion = "";
            }
            info.setProperty("eclipse.buildId", productVersion);
        }
    }

    public void postStartup() {
        PlatformUtil.expandEnvironmentStrings((String)"%DesktopDirectory%");
        try {
            this.refreshFromLocal();
            this.activateProxyService();
            ((Workbench)PlatformUI.getWorkbench()).registerService(ISelectionConversionService.class, (Object)new IDESelectionConversionService());
            this.initializeSettingsChangeListener();
            Display.getCurrent().addListener(39, this.settingsChangeListener);
        }
        finally {
            Job.getJobManager().resume();
        }
        this.initPreferences();
        IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode(IdePlugin.PLUGIN_ID);
        boolean alreadyForcedAutomaticUpdate = prefs.getBoolean(FORCED_AUTOMATIC_UPDATE, false);
        if (!alreadyForcedAutomaticUpdate) {
            IPreferenceStore automaticUpdatePluginPreferenceStore = AutomaticUpdatePlugin.getDefault().getPreferenceStore();
            automaticUpdatePluginPreferenceStore.setValue("enabled", true);
            automaticUpdatePluginPreferenceStore.setValue("schedule", "on-startup");
            prefs.putBoolean(FORCED_AUTOMATIC_UPDATE, true);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                IdeLog.logError((Plugin)IdePlugin.getDefault(), (Throwable)e);
            }
        }
        if (this.args != null && this.args.length > 0) {
            CommandlineArgumentsHandler.processCommandLineArgs((String[])this.args);
        }
        LauncherServer.startServer();
        new InstallCommandLineExecutableJob().schedule();
    }

    private void activateProxyService() {
        ServiceReference ref;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.ide");
        Object proxyService = null;
        if (bundle != null && (ref = bundle.getBundleContext().getServiceReference(IProxyService.class.getName())) != null) {
            proxyService = bundle.getBundleContext().getService(ref);
        }
        if (proxyService == null) {
            IDEWorkbenchPlugin.log((String)"Proxy service could not be found.");
        }
    }

    private void initializeSettingsChangeListener() {
        this.settingsChangeListener = new Listener(){
            boolean currentHighContrast = Display.getCurrent().getHighContrast();

            public void handleEvent(Event event) {
                if (Display.getCurrent().getHighContrast() == this.currentHighContrast) {
                    return;
                }
                boolean bl = this.currentHighContrast = !this.currentHighContrast;
                if (new MessageDialog(null, IDEWorkbenchMessages.SystemSettingsChange_title, null, IDEWorkbenchMessages.SystemSettingsChange_message, 3, new String[]{IDEWorkbenchMessages.SystemSettingsChange_yes, IDEWorkbenchMessages.SystemSettingsChange_no}, 1).open() == 0) {
                    PlatformUI.getWorkbench().restart();
                }
            }
        };
    }

    public void postShutdown() {
        PortManager.doShutdownCleanup();
        if (this.activityHelper != null) {
            this.activityHelper.shutdown();
            this.activityHelper = null;
        }
        if (this.idleHelper != null) {
            this.idleHelper.shutdown();
            this.idleHelper = null;
        }
        if (this.workspaceUndoMonitor != null) {
            this.workspaceUndoMonitor.shutdown();
            this.workspaceUndoMonitor = null;
        }
        if (IDEWorkbenchPlugin.getPluginWorkspace() != null) {
            this.disconnectFromWorkspace();
        }
    }

    public boolean preShutdown() {
        Display.getCurrent().removeListener(39, this.settingsChangeListener);
        return super.preShutdown();
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        this.workbenchWindowAdvisor = new IDEWorkbenchWindowAdvisor(this, configurer);
        return this.workbenchWindowAdvisor;
    }

    WorkbenchWindowAdvisor getWorkbenchWindowAdvisor() {
        return this.workbenchWindowAdvisor;
    }

    public boolean hasIntro() {
        return this.getWorkbenchConfigurer().getWorkbench().getIntroManager().hasIntro();
    }

    private void refreshFromLocal() {
        String[] commandLineArgs = Platform.getCommandLineArgs();
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        boolean refresh = store.getBoolean("REFRESH_WORKSPACE_ON_STARTUP");
        if (!refresh) {
            return;
        }
        int i = 0;
        while (i < commandLineArgs.length) {
            if (commandLineArgs[i].equalsIgnoreCase("-refresh")) {
                return;
            }
            ++i;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        WorkspaceJob job = new WorkspaceJob(IDEWorkbenchMessages.Workspace_refreshing, (IContainer)root){
            private final /* synthetic */ IContainer val$root;
            {
                this.val$root = iContainer;
                super($anonymous0);
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                this.val$root.refreshLocal(2, monitor);
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)root);
        job.schedule();
    }

    private void disconnectFromWorkspace() {
        final MultiStatus status = new MultiStatus("org.eclipse.ui.ide", 1, IDEWorkbenchMessages.ProblemSavingWorkbench, null);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    status.merge(ResourcesPlugin.getWorkspace().save(true, monitor));
                }
                catch (CoreException e) {
                    status.merge(e.getStatus());
                }
            }
        };
        try {
            new ProgressMonitorJobsDialog(null).run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            status.merge((IStatus)new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.InternalError, e.getTargetException()));
        }
        catch (InterruptedException e) {
            status.merge((IStatus)new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.InternalError, (Throwable)e));
        }
        ErrorDialog.openError(null, (String)IDEWorkbenchMessages.ProblemsSavingWorkspace, null, (IStatus)status, (int)6);
        if (!status.isOK()) {
            IDEWorkbenchPlugin.log((String)IDEWorkbenchMessages.ProblemsSavingWorkspace, (IStatus)status);
        }
    }

    public IAdaptable getDefaultPageInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public String getInitialWindowPerspectiveId() {
        int index = PlatformUI.getWorkbench().getWorkbenchWindowCount() - 1;
        String perspectiveId = null;
        AboutInfo[] welcomeInfos = this.getWelcomePerspectiveInfos();
        if (index >= 0 && welcomeInfos != null && index < welcomeInfos.length) {
            perspectiveId = welcomeInfos[index].getWelcomePerspectiveId();
        }
        if (perspectiveId == null) {
            perspectiveId = "org.eclipse.ui.resourcePerspective";
        }
        return perspectiveId;
    }

    private Map<String, AboutInfo> computeBundleGroupMap() {
        TreeMap<String, AboutInfo> ids = new TreeMap<String, AboutInfo>();
        IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
        int i = 0;
        while (i < providers.length) {
            IBundleGroup[] groups;
            IBundleGroup[] iBundleGroupArray = groups = providers[i].getBundleGroups();
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                IBundleGroup group = iBundleGroupArray[n2];
                AboutInfo info = new AboutInfo(group);
                String version = info.getVersionId();
                version = version == null ? "0.0.0" : new Version(version).toString();
                String versionedFeature = String.valueOf(group.getIdentifier()) + ":" + version;
                ids.put(versionedFeature, info);
                ++n2;
            }
            ++i;
        }
        return ids;
    }

    public Map<String, AboutInfo> getNewlyAddedBundleGroups() {
        if (this.newlyAddedBundleGroups == null) {
            this.newlyAddedBundleGroups = this.createNewBundleGroupsMap();
        }
        return this.newlyAddedBundleGroups;
    }

    private Map<String, AboutInfo> createNewBundleGroupsMap() {
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        String[] previousFeaturesArray = settings.getArray(INSTALLED_FEATURES);
        Map<String, AboutInfo> bundleGroups = this.computeBundleGroupMap();
        String[] currentFeaturesArray = new String[bundleGroups.size()];
        bundleGroups.keySet().toArray(currentFeaturesArray);
        settings.put(INSTALLED_FEATURES, currentFeaturesArray);
        if (previousFeaturesArray != null) {
            int i = 0;
            while (i < previousFeaturesArray.length) {
                bundleGroups.remove(previousFeaturesArray[i]);
                ++i;
            }
        }
        return bundleGroups;
    }

    private void declareWorkbenchImages() {
        String ICONS_PATH = "$nl$/icons/full/";
        String PATH_ELOCALTOOL = "$nl$/icons/full/elcl16/";
        String PATH_DLOCALTOOL = "$nl$/icons/full/dlcl16/";
        String PATH_ETOOL = "$nl$/icons/full/etool16/";
        String PATH_DTOOL = "$nl$/icons/full/dtool16/";
        String PATH_OBJECT = "$nl$/icons/full/obj16/";
        String PATH_WIZBAN = "$nl$/icons/full/wizban/";
        Bundle ideBundle = Platform.getBundle((String)"org.eclipse.ui.ide");
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC", "$nl$/icons/full/etool16/build_exec.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC_HOVER", "$nl$/icons/full/etool16/build_exec.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC_DISABLED", "$nl$/icons/full/dtool16/build_exec.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC", "$nl$/icons/full/etool16/search_src.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC_HOVER", "$nl$/icons/full/etool16/search_src.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC_DISABLED", "$nl$/icons/full/dtool16/search_src.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_NEXT_NAV", "$nl$/icons/full/etool16/next_nav.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PREVIOUS_NAV", "$nl$/icons/full/etool16/prev_nav.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWPRJ_WIZ", "$nl$/icons/full/wizban/newprj_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWFOLDER_WIZ", "$nl$/icons/full/wizban/newfolder_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWFILE_WIZ", "$nl$/icons/full/wizban/newfile_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_IMPORTDIR_WIZ", "$nl$/icons/full/wizban/importdir_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_IMPORTZIP_WIZ", "$nl$/icons/full/wizban/importzip_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTDIR_WIZ", "$nl$/icons/full/wizban/exportdir_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTZIP_WIZ", "$nl$/icons/full/wizban/exportzip_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTZIP_WIZ", "$nl$/icons/full/wizban/workset_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_DLGBAN_SAVEAS_DLG", "$nl$/icons/full/wizban/saveas_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_DLGBAN_QUICKFIX_DLG", "$nl$/icons/full/wizban/quick_fix.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJ_PROJECT", "$nl$/icons/full/obj16/prj_obj.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJ_PROJECT_CLOSED", "$nl$/icons/full/obj16/cprj_obj.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OPEN_MARKER", "$nl$/icons/full/elcl16/gotoobj_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_ELCL_QUICK_FIX_ENABLED", "$nl$/icons/full/elcl16/smartmode_co.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_DLCL_QUICK_FIX_DISABLED", "$nl$/icons/full/dlcl16/smartmode_co.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_TASK_TSK", "$nl$/icons/full/obj16/taskmrk_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_BKMRK_TSK", "$nl$/icons/full/obj16/bkmrk_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_COMPLETE_TSK", "$nl$/icons/full/obj16/complete_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_INCOMPLETE_TSK", "$nl$/icons/full/obj16/incomplete_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WELCOME_ITEM", "$nl$/icons/full/obj16/welcome_item.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WELCOME_BANNER", "$nl$/icons/full/obj16/welcome_banner.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_ERROR_PATH", "$nl$/icons/full/obj16/error_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WARNING_PATH", "$nl$/icons/full/obj16/warn_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_INFO_PATH", "$nl$/icons/full/obj16/info_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_LCL_FLAT_LAYOUT", "$nl$/icons/full/elcl16/flatLayout.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_LCL_HIERARCHICAL_LAYOUT", "$nl$/icons/full/elcl16/hierarchicalLayout.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PROBLEM_CATEGORY", "$nl$/icons/full/etool16/problem_category.gif", true);
    }

    private void declareWorkbenchImage(Bundle ideBundle, String symbolicName, String path, boolean shared) {
        URL url = FileLocator.find((Bundle)ideBundle, (IPath)new Path(path), null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        this.getWorkbenchConfigurer().declareImage(symbolicName, desc, shared);
    }

    public String getMainPreferencePageId() {
        return WORKBENCH_PREFERENCE_CATEGORY_ID;
    }

    public String getWorkspaceLocation() {
        return this.workspaceLocation;
    }

    public AboutInfo[] getWelcomePerspectiveInfos() {
        if (this.welcomePerspectiveInfos == null && !this.hasIntro()) {
            Map<String, AboutInfo> m = this.getNewlyAddedBundleGroups();
            ArrayList<AboutInfo> list = new ArrayList<AboutInfo>(m.size());
            for (AboutInfo info : m.values()) {
                if (info == null || info.getWelcomePerspectiveId() == null || info.getWelcomePageURL() == null) continue;
                list.add(info);
            }
            this.welcomePerspectiveInfos = new AboutInfo[list.size()];
            list.toArray(this.welcomePerspectiveInfos);
        }
        return this.welcomePerspectiveInfos;
    }

    public AbstractStatusHandler getWorkbenchErrorHandler() {
        if (this.ideWorkbenchErrorHandler == null) {
            this.ideWorkbenchErrorHandler = new IDEWorkbenchErrorHandler(this.getWorkbenchConfigurer()){

                public void handle(StatusAdapter statusAdapter, int style) {
                    if (!this.isIgnored(statusAdapter)) {
                        super.handle(statusAdapter, style);
                    }
                }

                private boolean isIgnored(StatusAdapter statusAdapter) {
                    IStatus status = statusAdapter.getStatus();
                    if (status.getSeverity() == 4) {
                        return false;
                    }
                    String message = status.getMessage();
                    if (message != null) {
                        String[] stringArray = IGNORED_STATUS_MESSAGES;
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String ignored = stringArray[n2];
                            if (message.indexOf(ignored) > -1) {
                                return true;
                            }
                            ++n2;
                        }
                    }
                    return false;
                }
            };
        }
        return this.ideWorkbenchErrorHandler;
    }

    public void eventLoopIdle(Display display) {
        if (this.delayedEventsProcessor != null) {
            this.delayedEventsProcessor.catchUp(display);
        }
        super.eventLoopIdle(display);
    }

    public List<String> getOpenEditors(IWorkbenchWindow[] windows) {
        ArrayList<String> openFiles = new ArrayList<String>();
        int i = 0;
        while (i < windows.length) {
            openFiles.addAll(this.getOpenEditors(windows[i].getPages()));
            ++i;
        }
        return openFiles;
    }

    public List<String> getOpenEditors(IWorkbenchPage[] pages) {
        ArrayList<String> openFiles = new ArrayList<String>();
        int i = 0;
        while (i < pages.length) {
            openFiles.addAll(this.getEditorReferences(pages[i]));
            ++i;
        }
        return openFiles;
    }

    public List<String> getEditorReferences(IWorkbenchPage page) {
        IEditorReference[] refs = page.getEditorReferences();
        if (refs == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> openFiles = new ArrayList<String>();
        int i = 0;
        while (i < refs.length) {
            try {
                String path;
                URI uri;
                IEditorInput input = refs[i].getEditorInput();
                if (input instanceof IURIEditorInput && "file".equals((uri = ((IURIEditorInput)input).getURI()).getScheme()) && !(path = new File(uri).getAbsolutePath()).startsWith(System.getProperty("java.io.tmpdir"))) {
                    openFiles.add(path);
                }
            }
            catch (PartInitException e) {
                IdePlugin.getDefault().getLog().log((IStatus)new Status(4, IdePlugin.getDefault().getBundle().getSymbolicName(), 0, Messages.ApplicationWorkbenchAdvisor_ErrorGettingCurrentEditorReferences, (Throwable)e));
            }
            ++i;
        }
        return openFiles;
    }

    private void initPreferences() {
        IEclipsePreferences prefs;
        if (!Platform.getPreferencesService().getBoolean(IdePlugin.PLUGIN_ID, "WORKSPACE_ENCODING_SET", false, null)) {
            try {
                ResourcesPlugin.getWorkspace().getRoot().setDefaultCharset("UTF-8", null);
            }
            catch (CoreException e) {
                IdePlugin.getDefault().getLog().log((IStatus)new Status(4, IdePlugin.PLUGIN_ID, 0, Messages.PreferenceInitializer_Cannot_Set_Default_Encoding, (Throwable)e));
            }
            prefs = InstanceScope.INSTANCE.getNode(IdePlugin.PLUGIN_ID);
            prefs.putBoolean("WORKSPACE_ENCODING_SET", true);
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
        prefs = InstanceScope.INSTANCE.getNode("org.eclipse.ui.editors");
        if (!Platform.getPreferencesService().getBoolean(IdePlugin.PLUGIN_ID, "EDITOR_LINE_NUMBER_SET", false, null)) {
            prefs.putBoolean("lineNumberRuler", true);
            prefs = InstanceScope.INSTANCE.getNode(IdePlugin.PLUGIN_ID);
            prefs.putBoolean("EDITOR_LINE_NUMBER_SET", true);
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
    }
}

