/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.text.AbstractFoldingComputer;
import com.aptana.editor.css.internal.text.CSSFoldingComputer;
import com.aptana.editor.html.parsing.ast.HTMLNode;
import com.aptana.editor.html.parsing.ast.HTMLTextNode;
import com.aptana.editor.js.internal.text.JSFoldingComputer;
import com.aptana.parsing.ast.IParseNode;
import org.eclipse.jface.text.IDocument;

public class HTMLFoldingComputer
extends AbstractFoldingComputer {
    public HTMLFoldingComputer(AbstractThemeableEditor editor, IDocument document) {
        super(editor, document);
    }

    public boolean isFoldable(IParseNode child) {
        String language = child.getLanguage();
        if ("com.aptana.contenttype.js".equals(language)) {
            return this.getJSFoldingComputer().isFoldable(child);
        }
        if ("com.aptana.contenttype.css".equals(language)) {
            return this.getCSSFoldingComputer().isFoldable(child);
        }
        return child instanceof HTMLNode && !(child instanceof HTMLTextNode);
    }

    public boolean isCollapsed(IParseNode child) {
        String language = child.getLanguage();
        if ("com.aptana.contenttype.js".equals(language)) {
            return this.getJSFoldingComputer().isCollapsed(child);
        }
        if ("com.aptana.contenttype.css".equals(language)) {
            return this.getCSSFoldingComputer().isCollapsed(child);
        }
        return false;
    }

    private AbstractFoldingComputer getJSFoldingComputer() {
        return new JSFoldingComputer(this.getEditor(), this.getDocument());
    }

    private AbstractFoldingComputer getCSSFoldingComputer() {
        return new CSSFoldingComputer(this.getEditor(), this.getDocument());
    }
}

