/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist;

import com.aptana.core.IMap;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.common.contentassist.ICommonCompletionProposal;
import com.aptana.editor.common.contentassist.ILexemeProvider;
import com.aptana.editor.common.contentassist.UserAgentManager;
import com.aptana.editor.css.contentassist.CSSContentAssistProcessor;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.HTMLTagScanner;
import com.aptana.editor.html.HTMLTagUtil;
import com.aptana.editor.html.contentassist.AttributeOrEventProposal;
import com.aptana.editor.html.contentassist.HTMLAttributeProposal;
import com.aptana.editor.html.contentassist.HTMLAttributeValueProposal;
import com.aptana.editor.html.contentassist.HTMLContextInformationValidator;
import com.aptana.editor.html.contentassist.HTMLEventProposal;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.contentassist.HTMLTagProposal;
import com.aptana.editor.html.contentassist.Messages;
import com.aptana.editor.html.contentassist.model.AttributeElement;
import com.aptana.editor.html.contentassist.model.ElementElement;
import com.aptana.editor.html.contentassist.model.EntityElement;
import com.aptana.editor.html.contentassist.model.EventElement;
import com.aptana.editor.html.contentassist.model.ValueElement;
import com.aptana.editor.html.parsing.HTMLParseState;
import com.aptana.editor.html.parsing.HTMLUtils;
import com.aptana.editor.html.parsing.lexer.HTMLLexemeProvider;
import com.aptana.editor.html.parsing.lexer.HTMLTokenType;
import com.aptana.editor.js.contentassist.JSContentAssistProcessor;
import com.aptana.editor.xml.TagUtil;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Lexeme;
import com.aptana.parsing.lexer.Range;
import com.aptana.preview.ProjectPreviewUtil;
import com.aptana.ui.util.UIUtils;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.IServerManager;
import com.aptana.webserver.core.WebServerCorePlugin;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLContentAssistProcessor
extends CommonContentAssistProcessor {
    private static final String CLASS = "class";
    private static final String ID = "id";
    private static final String DOCTYPE_PRECEDING_TEXT = "!";
    static final Image ELEMENT_ICON = HTMLPlugin.getImage("/icons/element.png");
    static final Image ATTRIBUTE_ICON = HTMLPlugin.getImage("/icons/attribute.png");
    static final Image EVENT_ICON = HTMLPlugin.getImage("/icons/event.gif");
    private static final Map<String, LocationType> locationMap = CollectionsUtil.newTypedMap(String.class, LocationType.class, (Object[])new Object[]{"__html__dftl_partition_content_type", LocationType.IN_TEXT, "__html_comment", LocationType.IN_COMMENT, "__html_doctype", LocationType.IN_DOCTYPE, "__html_script", LocationType.IN_OPEN_TAG, "__html_style", LocationType.IN_OPEN_TAG, "__html_tag", LocationType.IN_OPEN_TAG, "__html_tag_close", LocationType.IN_CLOSE_TAG, "__js__dftl_partition_content_type", LocationType.IN_TEXT, "__css___dftl_partition_content_type", LocationType.IN_TEXT, "__dftl_partition_content_type", LocationType.IN_TEXT});
    private static final Map<String, String> DOCTYPES = CollectionsUtil.newMap((Object[])new String[]{"HTML 5", "HTML", "HTML 4.01 Strict", "HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"\n\"http://www.w3.org/TR/html4/strict.dtd\"", "HTML 4.01 Transitional", "HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n\"http://www.w3.org/TR/html4/loose.dtd\"", "HTML 4.01 Transitional (Quirks)", "HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"", "HTML 4.01 Frameset", "HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\"\n\"http://www.w3.org/TR/html4/frameset.dtd\"", "XHTML 1.1", "html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\"", "XHTML 1.0 Strict", "html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"", "XHTML 1.0 Transitional", "html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"", "XHTML 1.0 Frameset", "html PUBLIC \"-//W3C//DTD XHTML 1.0 Frameset//EN\"\n\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\"", "HTML 3.2", "HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\"", "HTML 2.0", "HTML PUBLIC \"-//IETF//DTD HTML//EN\""});
    private HTMLIndexQueryHelper _queryHelper = new HTMLIndexQueryHelper();
    private IContextInformationValidator _validator;
    private Lexeme<HTMLTokenType> _currentLexeme;
    private IRange _replaceRange;
    private IDocument _document;
    private JSContentAssistProcessor fJSProcessor;
    private CSSContentAssistProcessor fCSSProcessor;

    public HTMLContentAssistProcessor(AbstractThemeableEditor editor) {
        super(editor);
    }

    protected List<ICompletionProposal> addAttributeAndEventProposals(ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        String elementName = this.getElementName(lexemeProvider, offset);
        ElementElement element = this._queryHelper.getElement(elementName);
        if (element != null) {
            AttributeOrEventProposal p;
            int[] positions;
            String replaceString;
            String name;
            String postfix = "=\"\"";
            switch ((HTMLTokenType)((Object)this._currentLexeme.getType())) {
                case EQUAL: {
                    int index = lexemeProvider.getLexemeFloorIndex(offset);
                    if (index <= 0) break;
                    this._currentLexeme = lexemeProvider.getLexeme(index - 1);
                    this._replaceRange = this._currentLexeme;
                    postfix = "";
                    break;
                }
                case INLINE_TAG: 
                case TAG_END: 
                case TAG_SELF_CLOSE: {
                    this._replaceRange = null;
                    break;
                }
                default: {
                    int index = lexemeProvider.getLexemeFloorIndex(offset);
                    Lexeme nextlexeme = lexemeProvider.getLexeme(index + 1);
                    if (nextlexeme == null || nextlexeme.getType() != HTMLTokenType.EQUAL) break;
                    postfix = "";
                }
            }
            int replaceLength = 0;
            if (this._replaceRange != null) {
                offset = this._replaceRange.getStartingOffset();
                replaceLength = this._replaceRange.getLength();
            }
            List<String> userAgentList = element.getUserAgentNames();
            String[] userAgents = userAgentList.toArray(new String[userAgentList.size()]);
            Image[] userAgentIcons = UserAgentManager.getInstance().getUserAgentImages(this.getProject(), userAgents);
            if (IdeLog.isTraceEnabled((Plugin)HTMLPlugin.getDefault(), (String)"com.aptana.editor.html/debug/content_assist")) {
                IdeLog.logTrace((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format("Current element: {0}, Current lexeme: {1}, Replace offset: {2}. Replace length: {3}", elementName, this._currentLexeme, offset, replaceLength), (String)"com.aptana.editor.html/debug/content_assist");
            }
            for (AttributeElement attribute : this._queryHelper.getAttributes(element)) {
                name = attribute.getName();
                replaceString = String.valueOf(name) + postfix;
                positions = postfix.length() == 0 ? new int[]{replaceString.length()} : new int[]{replaceString.length() - 1, replaceString.length()};
                p = new HTMLAttributeProposal(attribute, String.valueOf(name) + postfix, userAgentIcons, offset, replaceLength, positions);
                proposals.add((ICompletionProposal)p);
            }
            for (EventElement event : this._queryHelper.getEvents(element)) {
                name = event.getName();
                replaceString = String.valueOf(name) + postfix;
                positions = postfix.length() == 0 ? new int[]{replaceString.length()} : new int[]{replaceString.length() - 1, replaceString.length()};
                p = new HTMLEventProposal(event, String.valueOf(name) + postfix, userAgentIcons, offset, replaceLength, positions);
                proposals.add((ICompletionProposal)p);
            }
        } else {
            IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format("Current element: {0}, Current lexeme: {1}", elementName, this._currentLexeme), (String)"com.aptana.editor.html/debug/content_assist");
        }
        return proposals;
    }

    private List<ICompletionProposal> addAttributeValueProposals(int offset, String elementName, String attributeName) {
        AttributeElement attribute = this._queryHelper.getAttribute(elementName, attributeName);
        if (attribute != null) {
            final Image[] userAgents = UserAgentManager.getInstance().getUserAgentImages(this.getProject(), this.getActiveUserAgentIds());
            final IRange range = this._replaceRange != null ? this._replaceRange : new Range(offset, offset - 1);
            return CollectionsUtil.map(attribute.getValues(), (IMap)new IMap<ValueElement, ICompletionProposal>(){

                public ICompletionProposal map(ValueElement value) {
                    return new HTMLAttributeValueProposal(value, range, userAgents);
                }
            });
        }
        return Collections.emptyList();
    }

    private List<ICompletionProposal> addAttributeValueProposals(ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        String attributeName = this.getAttributeName(lexemeProvider, offset);
        if (attributeName != null && attributeName.length() > 0) {
            switch ((HTMLTokenType)((Object)this._currentLexeme.getType())) {
                case DOUBLE_QUOTED_STRING: 
                case SINGLE_QUOTED_STRING: {
                    if (this._currentLexeme.getLength() < 2) break;
                    Range range = null;
                    if (ID.equals(attributeName) || CLASS.equals(attributeName)) {
                        range = HTMLUtils.getAttributeValueRange(this._currentLexeme, offset);
                    }
                    if (range == null) {
                        int startingOffset = this._currentLexeme.getStartingOffset() + 1;
                        int endingOffset = this._currentLexeme.getEndingOffset() - 1;
                        range = new Range(startingOffset, endingOffset);
                    }
                    this._replaceRange = range;
                    break;
                }
                case EQUAL: {
                    this._replaceRange = new Range(offset, offset - 1);
                    break;
                }
                case TAG_END: 
                case TAG_SELF_CLOSE: {
                    this._replaceRange = new Range(offset, offset - 1);
                    break;
                }
                default: {
                    if (this._currentLexeme.getText().equals(attributeName)) break;
                    this._replaceRange = offset <= this._currentLexeme.getStartingOffset() ? null : this._currentLexeme;
                }
            }
            if (attributeName.equals(ID)) {
                return this.addIDProposals(offset);
            }
            if (CLASS.equals(attributeName)) {
                return this.addClassProposals(offset);
            }
            if ("src".equals(attributeName) || "href".equals(attributeName)) {
                return this.addURIPathProposals(offset);
            }
            String elementName = this.getElementName(lexemeProvider, offset);
            return this.addAttributeValueProposals(offset, elementName, attributeName);
        }
        return Collections.emptyList();
    }

    protected List<ICompletionProposal> addClassProposals(int offset) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        Map<String, String> classes = this._queryHelper.getClasses(this.getIndex());
        if (classes != null) {
            UserAgentManager manager = UserAgentManager.getInstance();
            String[] userAgents = manager.getActiveUserAgentIDs(this.getProject());
            for (Map.Entry<String, String> entry : classes.entrySet()) {
                this.addProposal(proposals, entry.getKey(), ATTRIBUTE_ICON, null, userAgents, entry.getValue(), offset);
            }
        }
        return proposals;
    }

    protected List<ICompletionProposal> addURIPathProposals(int offset) {
        this._replaceRange = null;
        try {
            String valuePrefix = this._currentLexeme.getText();
            int length = offset - this._currentLexeme.getStartingOffset();
            valuePrefix = valuePrefix.substring(0, length);
            if (valuePrefix.length() > 0 && (valuePrefix.charAt(0) == '\"' || valuePrefix.charAt(0) == '\'')) {
                valuePrefix = valuePrefix.substring(1);
                offset = this._currentLexeme.getStartingOffset() + 1;
            }
            URI editorStoreURI = this.getURI();
            IFileStore editorStore = null;
            if (editorStoreURI != null) {
                editorStore = EFS.getStore((URI)editorStoreURI);
            }
            IFileStore baseStore = null;
            if (valuePrefix.length() > 0 && valuePrefix.charAt(0) == '/') {
                URI projectUri = this.getProjectURI();
                if (projectUri != null) {
                    baseStore = EFS.getStore((URI)projectUri);
                    IServer serverConfiguration = ProjectPreviewUtil.getServerConfiguration((IProject)this.getProject());
                    if (serverConfiguration == null) {
                        for (IServer server : this.getServerManager().getServers()) {
                            if (server.resolve(editorStore) == null) continue;
                            serverConfiguration = server;
                            break;
                        }
                    }
                    if (serverConfiguration != null) {
                        URI documentRoot = serverConfiguration.getDocumentRoot();
                        if (documentRoot != null) {
                            baseStore = EFS.getStore((URI)documentRoot);
                        }
                    } else {
                        IFileStore publicDir = baseStore.getChild("public");
                        if (publicDir.fetchInfo().exists()) {
                            baseStore = publicDir;
                        }
                    }
                }
            } else if (valuePrefix.contains(":/")) {
                if (valuePrefix.endsWith(":/")) {
                    return Collections.emptyList();
                }
                if ("file://".equals(valuePrefix)) {
                    baseStore = EFS.getLocalFileSystem().getStore((IPath)Path.ROOT);
                    offset += valuePrefix.length();
                    valuePrefix = "";
                } else {
                    try {
                        URI parsed = null;
                        int lastSlash = valuePrefix.lastIndexOf(47);
                        if (lastSlash != -1 && lastSlash < valuePrefix.length() - 1) {
                            parsed = URI.create(valuePrefix.substring(0, lastSlash));
                            offset += lastSlash + 1;
                            valuePrefix = valuePrefix.substring(lastSlash + 1);
                        } else {
                            parsed = URI.create(valuePrefix);
                            offset += valuePrefix.length();
                            valuePrefix = "";
                        }
                        baseStore = EFS.getStore((URI)parsed);
                    }
                    catch (Exception e) {
                        return Collections.emptyList();
                    }
                }
            } else if (editorStore != null) {
                baseStore = editorStore.getParent();
            }
            if (baseStore == null || !this.efsFileSystemCanGrabChildren(baseStore.toURI().getScheme())) {
                return Collections.emptyList();
            }
            boolean hitRemote = Platform.getPreferencesService().getBoolean("com.aptana.editor.html", "HTML_REMOTE_HREF_PROPOSALS", true, null);
            if (!hitRemote && this.isRemoteURI(baseStore)) {
                return Collections.emptyList();
            }
            int lastSlash = valuePrefix.lastIndexOf(47);
            if (lastSlash != -1) {
                IFileStore possibleChild = baseStore.getChild(valuePrefix.substring(0, lastSlash));
                if (!possibleChild.fetchInfo().exists()) {
                    return Collections.emptyList();
                }
                baseStore = possibleChild;
                offset += lastSlash + 1;
                valuePrefix = valuePrefix.substring(lastSlash + 1);
            }
            this._replaceRange = new Range(offset, this._currentLexeme.getEndingOffset() - 1);
            return this.suggestChildrenOfFileStore(offset, valuePrefix, editorStoreURI, baseStore);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    protected IServerManager getServerManager() {
        return WebServerCorePlugin.getDefault().getServerManager();
    }

    protected List<ICompletionProposal> suggestChildrenOfFileStore(int offset, String valuePrefix, URI editorStoreURI, IFileStore parent) throws CoreException {
        IFileStore[] children = parent.childStores(0, (IProgressMonitor)new NullProgressMonitor());
        if (children == null || children.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        Image[] userAgentIcons = this.getAllUserAgentIcons();
        IFileStore[] iFileStoreArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore f = iFileStoreArray[n2];
            String name = f.getName();
            if (name.charAt(0) != '.' && !f.toURI().equals(editorStoreURI) && (valuePrefix == null || valuePrefix.length() <= 0 || name.startsWith(valuePrefix))) {
                IFileInfo info = f.fetchInfo();
                boolean isDir = false;
                if (info.isDirectory()) {
                    isDir = true;
                }
                int replaceOffset = offset;
                int replaceLength = 0;
                if (this._replaceRange != null) {
                    replaceOffset = this._replaceRange.getStartingOffset();
                    replaceLength = this._replaceRange.getLength();
                }
                URIPathProposal proposal = new URIPathProposal(name, replaceOffset, replaceLength, isDir, userAgentIcons);
                proposals.add((ICompletionProposal)proposal);
            }
            ++n2;
        }
        return proposals;
    }

    private boolean isRemoteURI(IFileStore baseStore) {
        try {
            return baseStore.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor()) == null;
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            return true;
        }
    }

    protected boolean efsFileSystemCanGrabChildren(String scheme) {
        if (scheme == null) {
            return false;
        }
        return !"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme);
    }

    protected List<ICompletionProposal> addElementProposals(ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        List<ElementElement> elements = this._queryHelper.getElements();
        if (elements != null) {
            Lexeme nextLexeme;
            Lexeme previousLexeme;
            int index;
            boolean close = true;
            int replaceLength = 0;
            int replaceOffset = offset;
            if (this._currentLexeme.getType() == HTMLTokenType.META) {
                replaceOffset = this._currentLexeme.getStartingOffset();
                replaceLength = this._currentLexeme.getLength();
                index = lexemeProvider.getLexemeIndex(this._currentLexeme.getStartingOffset());
                previousLexeme = lexemeProvider.getLexeme(index - 1);
                if (previousLexeme.getText().equals(DOCTYPE_PRECEDING_TEXT)) {
                    replaceOffset = previousLexeme.getStartingOffset();
                    replaceLength = this._currentLexeme.getEndingOffset() - replaceOffset + 1;
                }
            } else if (this._currentLexeme.getType() == HTMLTokenType.TEXT && this._currentLexeme.getText().equals(DOCTYPE_PRECEDING_TEXT)) {
                replaceOffset = this._currentLexeme.getStartingOffset();
                replaceLength = this._currentLexeme.getLength();
                index = lexemeProvider.getLexemeIndex(this._currentLexeme.getStartingOffset());
                nextLexeme = lexemeProvider.getLexeme(index + 1);
                if (nextLexeme != null && nextLexeme.getType() == HTMLTokenType.TAG_END) {
                    replaceLength = nextLexeme.getEndingOffset() - replaceOffset;
                }
            } else if (this._currentLexeme.getType() == HTMLTokenType.TAG_END) {
                replaceLength = 1;
                index = lexemeProvider.getLexemeIndex(this._currentLexeme.getStartingOffset());
                previousLexeme = lexemeProvider.getLexeme(index - 1);
                if (previousLexeme.getText().equals(DOCTYPE_PRECEDING_TEXT)) {
                    replaceOffset = previousLexeme.getStartingOffset();
                    replaceLength += previousLexeme.getLength();
                }
            } else if (this._currentLexeme.getType() != HTMLTokenType.TAG_START) {
                index = lexemeProvider.getLexemeCeilingIndex(this._currentLexeme.getEndingOffset() + 1);
                if (index == -1 || index >= lexemeProvider.size()) {
                    index = lexemeProvider.size() - 1;
                }
                if ((nextLexeme = lexemeProvider.getLexeme(index)) != null) {
                    replaceOffset = this._currentLexeme.getStartingOffset();
                    replaceLength = this._currentLexeme.getLength();
                    if (!nextLexeme.equals(this._currentLexeme)) {
                        if (nextLexeme.getType() == HTMLTokenType.TAG_END) {
                            replaceLength += nextLexeme.getEndingOffset() - this._currentLexeme.getEndingOffset();
                        } else if (nextLexeme.getType() != HTMLTokenType.TAG_START) {
                            close = false;
                        }
                    }
                }
            }
            boolean addCloseTag = HTMLPlugin.getDefault().getPreferenceStore().getBoolean("HTML_AUTO_CLOSE_TAG_PAIRS");
            HTMLParseState state = null;
            String documentText = this._document.get();
            for (ElementElement element : elements) {
                StringBuilder replacement = new StringBuilder(element.getName());
                ArrayList<Integer> positions = new ArrayList<Integer>();
                int cursorPosition = replacement.length();
                if (close) {
                    if (state == null) {
                        state = new HTMLParseState(documentText);
                    }
                    if (element.getName().charAt(0) == '!') {
                        ++cursorPosition;
                        int index2 = lexemeProvider.getLexemeIndex(this._currentLexeme.getStartingOffset());
                        Lexeme nextLexeme2 = lexemeProvider.getLexeme(index2 + 1);
                        if (nextLexeme2 == null || nextLexeme2.getType() == HTMLTokenType.TAG_START) {
                            replacement.append(" >");
                        }
                    } else if (HTMLParseState.isEmptyTagType(element.getName())) {
                        replacement.append(" />");
                        positions.add(cursorPosition + 3);
                    } else {
                        Document doc = new Document(documentText);
                        try {
                            doc.replace(replaceOffset, replaceLength, String.valueOf(element.getName()) + ">");
                        }
                        catch (BadLocationException e) {
                            IdeLog.logWarning((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format(Messages.HTMLContentAssistProcessor_ErrorReplacingText, replaceOffset, String.valueOf(element.getName()) + ">"), (Throwable)e, (String)"com.aptana.editor.html/debug/content_assist");
                        }
                        if (addCloseTag && !TagUtil.tagClosed((IDocument)doc, (String)element.getName())) {
                            replacement.append("></").append(element.getName()).append('>');
                            positions.add(cursorPosition + 1);
                            positions.add(cursorPosition + 4 + element.getName().length());
                        } else {
                            replacement.append('>');
                            positions.add(cursorPosition + 1);
                        }
                    }
                }
                positions.add(0, cursorPosition);
                HTMLTagProposal proposal = new HTMLTagProposal(replacement.toString(), replaceOffset, replaceLength, element, this.getProject(), positions.toArray(new Integer[positions.size()]));
                proposals.add((ICompletionProposal)proposal);
            }
        }
        return proposals;
    }

    private void addEntityProposals(List<ICompletionProposal> proposals, ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        this.setEntityRange(offset);
        if (this._replaceRange == null) {
            return;
        }
        String text = null;
        int startingOffset = this._replaceRange.getStartingOffset();
        int length = this._replaceRange.getLength();
        try {
            text = this._document.get(startingOffset, length);
        }
        catch (BadLocationException e) {
            IdeLog.logWarning((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format(Messages.HTMLContentAssistProcessor_ErrorFetchingText, startingOffset, length), (Throwable)e, (String)"com.aptana.editor.html/debug/content_assist");
        }
        if (text == null || text.charAt(0) != '&') {
            return;
        }
        List<EntityElement> entities = this._queryHelper.getEntities();
        if (entities != null) {
            String[] userAgentIds = this.getActiveUserAgentIds();
            for (EntityElement entity : entities) {
                this.addProposal(proposals, entity.getName(), ELEMENT_ICON, entity.getDescription(), userAgentIds, offset);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addDoctypeProposals(List<ICompletionProposal> proposals, ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        this._replaceRange = null;
        ptr = this._currentLexeme;
        userAgentIds = this.getActiveUserAgentIds();
        if (ptr == null || ptr.getType() != HTMLTokenType.META || !ptr.contains(offset)) ** GOTO lbl10
        proposals.addAll(this.addElementProposals(lexemeProvider, offset));
        return;
lbl-1000:
        // 1 sources

        {
            index = lexemeProvider.getLexemeIndex(ptr.getStartingOffset());
            ptr = lexemeProvider.getLexeme(index + 1);
lbl10:
            // 2 sources

            ** while (ptr != null && ptr.getType() != HTMLTokenType.TAG_END)
        }
lbl11:
        // 1 sources

        if (ptr != null) {
            this._replaceRange = new Range(this._currentLexeme.getStartingOffset(), ptr.getStartingOffset() - 1);
        }
        for (Map.Entry<String, String> entry : HTMLContentAssistProcessor.DOCTYPES.entrySet()) {
            src = entry.getValue();
            name = entry.getKey();
            proposal = this.createProposal(name, src, HTMLContentAssistProcessor.ELEMENT_ICON, MessageFormat.format("&lt;!DOCTYPE {0}&gt;", new Object[]{src}), userAgentIds, "HTML Core", offset, src.length());
            if (src.equalsIgnoreCase("HTML")) {
                proposal.setRelevance(50);
            }
            proposals.add((ICompletionProposal)proposal);
        }
    }

    protected List<ICompletionProposal> addIDProposals(int offset) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        Map<String, String> ids = this._queryHelper.getIDs(this.getIndex());
        if (ids != null) {
            String[] userAgents = this.getActiveUserAgentIds();
            for (Map.Entry<String, String> entry : ids.entrySet()) {
                this.addProposal(proposals, entry.getKey(), ATTRIBUTE_ICON, null, userAgents, entry.getValue(), offset);
            }
        }
        return proposals;
    }

    private void addOpenTagProposals(LocationType fineLocation, List<ICompletionProposal> proposals, ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        switch (fineLocation) {
            case IN_ELEMENT_NAME: {
                proposals.addAll(this.addElementProposals(lexemeProvider, offset));
                break;
            }
            case IN_ATTRIBUTE_NAME: {
                proposals.addAll(this.addAttributeAndEventProposals(lexemeProvider, offset));
                break;
            }
            case IN_ATTRIBUTE_VALUE: {
                proposals.addAll(this.addAttributeValueProposals(lexemeProvider, offset));
                break;
            }
        }
    }

    private boolean addUnclosedTagProposals(LocationType fineLocation, List<ICompletionProposal> proposals, ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        boolean addedProposal = false;
        List<String> unclosedElements = HTMLTagUtil.getUnclosedTagNames(this._document, offset);
        if (unclosedElements != null && !unclosedElements.isEmpty()) {
            int relevance = 89;
            for (String unclosedElement : unclosedElements) {
                ElementElement element = this._queryHelper.getElement(unclosedElement);
                if (element == null) continue;
                proposals.add((ICompletionProposal)this.createCloseTagProposal(element, lexemeProvider, offset, relevance));
                addedProposal = true;
                --relevance;
            }
        }
        return addedProposal;
    }

    private boolean addDefaultCloseTagProposals(LocationType fineLocation, List<ICompletionProposal> proposals, ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        HTMLParseState state = null;
        boolean addedProposal = false;
        List<ElementElement> elements = this._queryHelper.getElements();
        if (elements != null) {
            for (ElementElement element : elements) {
                if (state == null) {
                    state = new HTMLParseState(this._document.get());
                }
                if (HTMLParseState.isEmptyTagType(element.getName())) continue;
                proposals.add((ICompletionProposal)this.createCloseTagProposal(element, lexemeProvider, offset, 90));
                addedProposal = true;
            }
        }
        return addedProposal;
    }

    private CommonCompletionProposal createCloseTagProposal(ElementElement element, ILexemeProvider<HTMLTokenType> lexemeProvider, int offset, int relevance) {
        List<String> userAgentList = element.getUserAgentNames();
        String[] userAgents = userAgentList.toArray(new String[userAgentList.size()]);
        Image[] userAgentIcons = UserAgentManager.getInstance().getUserAgentImages(this.getProject(), userAgents);
        String replaceString = "/" + element.getName();
        Lexeme firstLexeme = lexemeProvider.getFirstLexeme();
        Lexeme tagLexeme = lexemeProvider.getLexeme(1);
        Lexeme closeLexeme = lexemeProvider.getLexeme(2);
        int replaceLength = 0;
        if (tagLexeme != null && tagLexeme.contains(offset)) {
            replaceLength += tagLexeme.getLength();
        }
        int replaceOffset = offset;
        if (offset > firstLexeme.getStartingOffset()) {
            replaceOffset = firstLexeme.getStartingOffset() + 1;
            if ("</".equals(firstLexeme.getText())) {
                ++replaceLength;
            }
            if (tagLexeme != null && HTMLTagUtil.isTag((Lexeme<HTMLTokenType>)tagLexeme)) {
                replaceLength += tagLexeme.getLength();
            }
            if (closeLexeme == null || !HTMLTokenType.TAG_END.equals(closeLexeme.getType())) {
                replaceString = String.valueOf(replaceString) + ">";
            }
        } else {
            int newOffset = offset - 1;
            int length = 1;
            try {
                replaceString = String.valueOf(replaceString) + ">";
                String previous = this._document.get(newOffset, length);
                if ("/".equals(previous)) {
                    --replaceOffset;
                    ++replaceLength;
                }
            }
            catch (BadLocationException e) {
                IdeLog.logWarning((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format(Messages.HTMLContentAssistProcessor_ErrorFetchingText, newOffset, length), (Throwable)e, (String)"com.aptana.editor.html/debug/content_assist");
            }
        }
        int cursorPosition = replaceString.length();
        CommonCompletionProposal proposal = new CommonCompletionProposal(replaceString, replaceOffset, replaceLength, cursorPosition, ELEMENT_ICON, "/" + element.getName(), null, element.getDescription());
        proposal.setFileLocation("HTML Core");
        proposal.setUserAgentImages(userAgentIcons);
        proposal.setRelevance(relevance);
        return proposal;
    }

    private void addProposal(List<ICompletionProposal> proposals, String name, Image image, String description, String[] userAgentIds, int offset) {
        this.addProposal(proposals, name, image, description, userAgentIds, "HTML Core", offset);
    }

    private void addProposal(List<ICompletionProposal> proposals, String name, Image image, String description, String[] userAgentIds, String fileLocation, int offset) {
        if (this.isActiveByUserAgent(userAgentIds)) {
            CommonCompletionProposal proposal = this.createProposal(name, image, description, userAgentIds, fileLocation, offset);
            proposals.add((ICompletionProposal)proposal);
        }
    }

    private CommonCompletionProposal createProposal(String name, Image image, String description, String[] userAgentIds, String fileLocation, int offset) {
        return this.createProposal(name, name, image, description, userAgentIds, fileLocation, offset, name.length());
    }

    protected CommonCompletionProposal createProposal(String displayName, String name, Image image, String description, String[] userAgentIds, String fileLocation, int offset, int length) {
        IContextInformation contextInfo = null;
        int replaceLength = 0;
        if (this._replaceRange != null) {
            offset = this._replaceRange.getStartingOffset();
            replaceLength = this._replaceRange.getLength();
        }
        Image[] userAgents = UserAgentManager.getInstance().getUserAgentImages(this.getProject(), userAgentIds);
        CommonCompletionProposal proposal = new CommonCompletionProposal(name, offset, replaceLength, length, image, displayName, contextInfo, description);
        proposal.setFileLocation(fileLocation);
        proposal.setUserAgentImages(userAgents);
        return proposal;
    }

    protected ICompletionProposal[] doComputeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        this._document = viewer.getDocument();
        HTMLLexemeProvider lexemeProvider = this.createLexemeProvider(this._document, offset > 0 ? offset - 1 : offset);
        Lexeme tempLexeme = lexemeProvider.getLexemeFromOffset(offset);
        if (tempLexeme != null) {
            this._currentLexeme = tempLexeme;
            this._replaceRange = this._currentLexeme;
        } else {
            this._replaceRange = null;
            this._currentLexeme = lexemeProvider.getFloorLexeme(offset);
        }
        LocationType location = this.getCoarseLocationType(this._document, (ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
        LocationType fineLocation = null;
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        switch (location) {
            case IN_OPEN_TAG: {
                fineLocation = this.getOpenTagLocationType((ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
                if (fineLocation == LocationType.IN_ELEMENT_NAME) {
                    this.addUnclosedTagProposals(fineLocation, result, (ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
                } else if (fineLocation == LocationType.IN_ATTRIBUTE_VALUE) {
                    String elementName = this.getElementName((ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
                    String attributeName = this.getAttributeName((ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
                    IRange activeRange = this.getAttributeValueRange((ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
                    if (HTMLUtils.isCSSAttribute(attributeName)) {
                        if (this.fCSSProcessor == null) {
                            this.fCSSProcessor = new CSSContentAssistProcessor(this.editor, activeRange);
                        } else {
                            this.fCSSProcessor.setActiveRange(activeRange);
                        }
                        return this.fCSSProcessor.computeCompletionProposals(viewer, offset, activationChar, autoActivated);
                    }
                    if (HTMLUtils.isJSAttribute(elementName, attributeName)) {
                        if (this.fJSProcessor == null) {
                            this.fJSProcessor = new JSContentAssistProcessor(this.editor, activeRange);
                        } else {
                            this.fJSProcessor.setActiveRange(activeRange);
                        }
                        return this.fJSProcessor.computeCompletionProposals(viewer, offset, activationChar, autoActivated);
                    }
                }
                this.addOpenTagProposals(fineLocation, result, (ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
                break;
            }
            case IN_CLOSE_TAG: {
                fineLocation = this.getOpenTagLocationType((ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
                boolean added = this.addUnclosedTagProposals(fineLocation, result, (ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
                if (added) break;
                this.addDefaultCloseTagProposals(fineLocation, result, (ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
                break;
            }
            case IN_TEXT: {
                this.addEntityProposals(result, (ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
                break;
            }
            case IN_DOCTYPE: {
                this.addDoctypeProposals(result, (ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
                break;
            }
        }
        ICompletionProposal[] proposals = result.toArray(new ICompletionProposal[result.size()]);
        if (IdeLog.isTraceEnabled((Plugin)HTMLPlugin.getDefault(), (String)"com.aptana.editor.html/debug/content_assist")) {
            IdeLog.logTrace((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format("Generated {0} proposals", proposals.length), (String)"com.aptana.editor.html/debug/content_assist");
        }
        if (this._replaceRange != null) {
            int startingOffset = this._replaceRange.getStartingOffset();
            int length = this._replaceRange.getLength();
            try {
                String text = this._document.get(this._replaceRange.getStartingOffset(), this._replaceRange.getLength());
                if (location == LocationType.IN_CLOSE_TAG) {
                    text = "/" + text;
                }
                this.setSelectedProposal(text, proposals);
            }
            catch (BadLocationException e) {
                IdeLog.logWarning((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format(Messages.HTMLContentAssistProcessor_ErrorFetchingText, startingOffset, length), (Throwable)e, (String)"com.aptana.editor.html/debug/content_assist");
            }
        }
        return proposals;
    }

    protected void setSelectedProposal(String prefix, ICompletionProposal[] proposals) {
        if (prefix == null || prefix.equals("") || proposals == null) {
            return;
        }
        ICompletionProposal[] iCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            String displayString = proposal.getDisplayString();
            int comparison = displayString.compareToIgnoreCase(prefix);
            if (comparison >= 0 && displayString.toLowerCase().startsWith(prefix.toLowerCase())) {
                if (displayString.startsWith(prefix)) {
                    ((ICommonCompletionProposal)proposal).setRelevance(90);
                } else {
                    ((ICommonCompletionProposal)proposal).setRelevance(50);
                }
            }
            ++n2;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fCSSProcessor != null) {
            this.fCSSProcessor.dispose();
        }
        if (this.fJSProcessor != null) {
            this.fJSProcessor.dispose();
        }
    }

    HTMLLexemeProvider createLexemeProvider(IDocument document, int offset) {
        int documentLength = document.getLength();
        int lexemeProviderOffset = offset >= documentLength ? documentLength - 1 : offset;
        return new HTMLLexemeProvider(document, lexemeProviderOffset, (ITokenScanner)new HTMLTagScanner(false));
    }

    private String getAttributeName(ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        String name = null;
        int index = lexemeProvider.getLexemeFloorIndex(offset);
        while (index >= 0) {
            Lexeme lexeme = lexemeProvider.getLexeme(index);
            if (lexeme.getType() == HTMLTokenType.EQUAL) {
                if (index < 1 || (lexeme = lexemeProvider.getLexeme(index - 1)) == null) break;
                name = lexeme.getText();
                break;
            }
            --index;
        }
        return name;
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this._validator == null) {
            this._validator = new HTMLContextInformationValidator();
        }
        return this._validator;
    }

    private String getElementName(ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        int index;
        String result = null;
        int i = index = lexemeProvider.getLexemeFloorIndex(offset);
        while (i >= 0) {
            Lexeme lexeme = lexemeProvider.getLexeme(i);
            if (lexeme.getType() == HTMLTokenType.TAG_START) {
                Lexeme nextLexeme = lexemeProvider.getLexeme(i + 1);
                if (nextLexeme == null) break;
                result = nextLexeme.getText();
                break;
            }
            --i;
        }
        return result;
    }

    private IRange getAttributeValueRange(ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        Lexeme attribute = lexemeProvider.getLexemeFromOffset(offset);
        Range result = Range.EMPTY;
        if (attribute != null) {
            switch ((HTMLTokenType)((Object)attribute.getType())) {
                case DOUBLE_QUOTED_STRING: 
                case SINGLE_QUOTED_STRING: {
                    result = new Range(attribute.getStartingOffset() + 1, attribute.getEndingOffset() - 1);
                }
            }
        }
        return result;
    }

    LocationType getCoarseLocationType(IDocument document, ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        LocationType result;
        block11: {
            result = LocationType.ERROR;
            try {
                ITypedRegion partition = document.getPartition(offset > 0 ? offset - 1 : offset);
                String type = partition.getType();
                if (!locationMap.containsKey(type)) break block11;
                result = locationMap.get(type);
                Lexeme firstLexeme = lexemeProvider.getFirstLexeme();
                if (firstLexeme != null) {
                    Lexeme lastLexeme = lexemeProvider.getLastLexeme();
                    HTMLTokenType lastLexemeType = (HTMLTokenType)((Object)lastLexeme.getType());
                    switch (result) {
                        case IN_OPEN_TAG: 
                        case IN_CLOSE_TAG: {
                            if (offset <= firstLexeme.getStartingOffset()) {
                                result = LocationType.IN_TEXT;
                                break;
                            }
                            if (lastLexeme.getEndingOffset() < offset && (lastLexemeType == HTMLTokenType.TAG_END || lastLexemeType == HTMLTokenType.TAG_SELF_CLOSE)) {
                                result = LocationType.IN_TEXT;
                                break;
                            }
                            break block11;
                        }
                        case IN_TEXT: {
                            if (firstLexeme.getType() == HTMLTokenType.TAG_START && lastLexemeType == HTMLTokenType.META && lastLexeme.getText().equalsIgnoreCase("DOCTYPE")) {
                                result = LocationType.IN_DOCTYPE;
                                break;
                            }
                            break block11;
                        }
                    }
                    break block11;
                }
                result = LocationType.IN_TEXT;
            }
            catch (BadLocationException e) {
                IdeLog.logWarning((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format(Messages.HTMLContentAssistProcessor_ErrorFetchingPartition, offset), (Throwable)e, (String)"com.aptana.editor.html/debug/content_assist");
            }
        }
        if (IdeLog.isTraceEnabled((Plugin)HTMLPlugin.getDefault(), (String)"com.aptana.editor.html/debug/content_assist")) {
            IdeLog.logTrace((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format("Coarse location: {0}", new Object[]{result}), (String)"com.aptana.editor.html/debug/content_assist");
        }
        return result;
    }

    LocationType getOpenTagLocationType(ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        LocationType result = LocationType.ERROR;
        int index = lexemeProvider.getLexemeIndex(offset);
        if (index < 0) {
            int candidateIndex = lexemeProvider.getLexemeFloorIndex(offset);
            Lexeme lexeme = lexemeProvider.getLexeme(candidateIndex);
            if (lexeme != null && lexeme.getEndingOffset() == offset - 1) {
                index = candidateIndex;
            } else {
                result = LocationType.IN_ATTRIBUTE_NAME;
            }
        }
        while (index >= 0) {
            Lexeme lexeme = lexemeProvider.getLexeme(index);
            block0 : switch ((HTMLTokenType)((Object)lexeme.getType())) {
                case ATTR_ID: 
                case ATTR_CLASS: 
                case ATTR_STYLE: 
                case ATTR_SCRIPT: {
                    result = LocationType.IN_ATTRIBUTE_NAME;
                    break;
                }
                case EQUAL: {
                    result = offset <= lexeme.getStartingOffset() ? LocationType.IN_ATTRIBUTE_NAME : LocationType.IN_ATTRIBUTE_VALUE;
                    break;
                }
                case TAG_START: {
                    result = LocationType.IN_ELEMENT_NAME;
                    break;
                }
                case TAG_END: 
                case TAG_SELF_CLOSE: {
                    Lexeme previous;
                    if (index < 1 || (previous = lexemeProvider.getLexeme(index - 1)).getEndingOffset() >= offset - 1) break;
                    result = LocationType.IN_ATTRIBUTE_NAME;
                    break;
                }
                case ATTRIBUTE: 
                case META: 
                case STRUCTURE_TAG: 
                case BLOCK_TAG: 
                case INLINE_TAG: {
                    Lexeme previous;
                    if (index >= 1) {
                        previous = lexemeProvider.getLexeme(index - 1);
                        switch ((HTMLTokenType)((Object)previous.getType())) {
                            case DOUBLE_QUOTED_STRING: 
                            case SINGLE_QUOTED_STRING: 
                            case META: 
                            case STRUCTURE_TAG: 
                            case BLOCK_TAG: 
                            case INLINE_TAG: {
                                this._currentLexeme = lexeme;
                                this._replaceRange = this._currentLexeme;
                                result = LocationType.IN_ATTRIBUTE_NAME;
                                break block0;
                            }
                            case TAG_START: {
                                this._currentLexeme = lexeme;
                                this._replaceRange = this._currentLexeme;
                                result = LocationType.IN_ELEMENT_NAME;
                                break block0;
                            }
                        }
                        break;
                    }
                    result = LocationType.IN_ELEMENT_NAME;
                    break;
                }
                case DOUBLE_QUOTED_STRING: 
                case SINGLE_QUOTED_STRING: {
                    if (lexeme.getEndingOffset() < offset && lexeme.getLength() > 1) {
                        int lastChar;
                        String text = lexeme.getText();
                        int n = lastChar = StringUtil.isEmpty((String)text) ? 0 : (int)text.charAt(text.length() - 1);
                        if (lastChar == 34 || lastChar == 39) {
                            result = LocationType.IN_ATTRIBUTE_NAME;
                            this._replaceRange = null;
                            break;
                        }
                        result = LocationType.IN_ATTRIBUTE_VALUE;
                        break;
                    }
                    result = LocationType.IN_ATTRIBUTE_VALUE;
                    break;
                }
            }
            if (result != LocationType.ERROR) break;
            --index;
        }
        if (IdeLog.isTraceEnabled((Plugin)HTMLPlugin.getDefault(), (String)"com.aptana.editor.html/debug/content_assist")) {
            IdeLog.logTrace((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format("Find location: {0}", new Object[]{result}), (String)"com.aptana.editor.html/debug/content_assist");
        }
        return result;
    }

    private void setEntityRange(int offset) {
        try {
            int start = -1;
            int end = -1;
            int i = offset - 1;
            while (i >= 0) {
                char c = this._document.getChar(i);
                if ('&' == c) {
                    start = i;
                    break;
                }
                if (Character.isWhitespace(c) || c == '>') {
                    this._replaceRange = null;
                    return;
                }
                --i;
            }
            int length = this._document.getLength();
            int i2 = offset;
            while (i2 < length) {
                char c = this._document.getChar(i2);
                if (';' == c) {
                    end = i2;
                    break;
                }
                if (Character.isWhitespace(c) || c == '<') {
                    end = offset - 1;
                    break;
                }
                ++i2;
            }
            this._replaceRange = new Range(start, end);
        }
        catch (BadLocationException e) {
            this._replaceRange = null;
        }
    }

    public boolean isValidAutoActivationLocation(char c, int keyCode, IDocument document, int offset) {
        HTMLLexemeProvider lexemeProvider = this.createLexemeProvider(document, offset);
        LocationType location = this.getCoarseLocationType(document, (ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
        switch (location) {
            case IN_OPEN_TAG: {
                if (c == ' ' || c == '\t') {
                    return true;
                }
                LocationType fineLocation = this.getOpenTagLocationType((ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
                return fineLocation == LocationType.IN_ATTRIBUTE_NAME || fineLocation == LocationType.IN_ATTRIBUTE_VALUE;
            }
        }
        return false;
    }

    public boolean isValidIdentifier(char c, int keyCode) {
        return 65 <= keyCode && keyCode <= 90 || 97 <= keyCode && keyCode <= 122;
    }

    protected String getPreferenceNodeQualifier() {
        return "com.aptana.editor.html";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LocationType {
        ERROR,
        IN_OPEN_TAG,
        IN_CLOSE_TAG,
        IN_DOCTYPE,
        IN_COMMENT,
        IN_TEXT,
        IN_ELEMENT_NAME,
        IN_ATTRIBUTE_NAME,
        IN_ATTRIBUTE_VALUE;

    }

    private static final class URIPathProposal
    extends CommonCompletionProposal {
        private final boolean isDirectory;

        private URIPathProposal(String replacementString, int replacementOffset, int replacementLength, boolean isDirectory, Image[] userAgentIcons) {
            super(replacementString, replacementOffset, replacementLength, replacementString.length(), null, replacementString, null, null);
            this.isDirectory = isDirectory;
            if (isDirectory) {
                this.setTriggerCharacters(new char[]{'/'});
            }
            this.setUserAgentImages(userAgentIcons);
        }

        public synchronized Image getImage() {
            if (this._image == null) {
                Image image = null;
                if (this.isDirectory) {
                    image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                } else {
                    ImageDescriptor imageDesc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.getDisplayString());
                    if (imageDesc != null) {
                        final Image theImage = image = imageDesc.createImage();
                        UIUtils.getDisplay().disposeExec(new Runnable(){

                            public void run() {
                                if (theImage != null && !theImage.isDisposed()) {
                                    theImage.dispose();
                                }
                            }
                        });
                    }
                    if (image == null) {
                        image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
                    }
                }
                this._image = image;
            }
            return this._image;
        }

        public void apply(final ITextViewer viewer, char trigger, int stateMask, int offset) {
            super.apply(viewer, trigger, stateMask, offset);
            if (viewer instanceof ITextOperationTarget && this.isDirectory) {
                UIUtils.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (((ITextOperationTarget)viewer).canDoOperation(13)) {
                            ((ITextOperationTarget)viewer).doOperation(13);
                        }
                    }
                });
            }
        }
    }
}

