/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.outline;

import beaver.Parser;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.outline.CommonOutlineContentProvider;
import com.aptana.editor.common.outline.CommonOutlineItem;
import com.aptana.editor.common.outline.CompositeOutlineContentProvider;
import com.aptana.editor.common.outline.PathResolverProvider;
import com.aptana.editor.common.resolver.IPathResolver;
import com.aptana.editor.css.outline.CSSOutlineContentProvider;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.outline.HTMLOutlineItem;
import com.aptana.editor.html.outline.Messages;
import com.aptana.editor.html.outline.OutlinePlaceholderItem;
import com.aptana.editor.html.parsing.HTMLParser;
import com.aptana.editor.html.parsing.ast.HTMLCommentNode;
import com.aptana.editor.html.parsing.ast.HTMLElementNode;
import com.aptana.editor.html.parsing.ast.HTMLNode;
import com.aptana.editor.html.parsing.ast.HTMLSpecialNode;
import com.aptana.editor.html.parsing.ast.HTMLTextNode;
import com.aptana.editor.html.preferences.HTMLPreferenceUtil;
import com.aptana.editor.js.outline.JSOutlineContentProvider;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.ast.ParseRootNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;

public class HTMLOutlineContentProvider
extends CompositeOutlineContentProvider {
    private Map<String, Object[]> cache = new HashMap<String, Object[]>();
    private TreeViewer treeViewer;
    private boolean showTextNode;
    private IPathResolver resolver;
    private AbstractThemeableEditor fEditor;
    private IEclipsePreferences.IPreferenceChangeListener preferenceListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if ("HTML_OUTLINE_SHOW_TEXT_NODES".equals(event.getKey())) {
                HTMLOutlineContentProvider.this.showTextNode = HTMLPreferenceUtil.getShowTextNodesInOutline();
            }
        }
    };

    public HTMLOutlineContentProvider(AbstractThemeableEditor editor) {
        this.addSubLanguage("com.aptana.contenttype.css", (CommonOutlineContentProvider)new CSSOutlineContentProvider());
        this.addSubLanguage("com.aptana.contenttype.js", (CommonOutlineContentProvider)new JSOutlineContentProvider());
        this.showTextNode = HTMLPreferenceUtil.getShowTextNodesInOutline();
        InstanceScope.INSTANCE.getNode("com.aptana.editor.html").addPreferenceChangeListener(this.preferenceListener);
        this.fEditor = editor;
    }

    public void dispose() {
        try {
            InstanceScope.INSTANCE.getNode("com.aptana.editor.html").removePreferenceChangeListener(this.preferenceListener);
        }
        finally {
            super.dispose();
        }
    }

    public Object[] getChildren(Object parentElement) {
        String attribute;
        HTMLElementNode item;
        if (parentElement instanceof HTMLOutlineItem) {
            return this.getChildren(((HTMLOutlineItem)((Object)parentElement)).getReferenceNode());
        }
        if (parentElement instanceof HTMLElementNode) {
            item = (HTMLElementNode)parentElement;
            if (this.isStylesheetLinkTag(item)) {
                attribute = this.getExternalCSSReference(item);
                if (attribute != null && attribute.length() > 0) {
                    return this.getExternalChildren((IParseNode)item, attribute, "com.aptana.contenttype.css");
                }
            } else {
                IParseNode[] styleNodes = item.getCSSStyleNodes();
                IParseNode[] jsAttrNodes = item.getJSAttributeNodes();
                if (styleNodes.length > 0 || jsAttrNodes.length > 0) {
                    ArrayList<IParseNode> children = new ArrayList<IParseNode>();
                    children.addAll(Arrays.asList(styleNodes));
                    children.addAll(Arrays.asList(jsAttrNodes));
                    children.addAll(Arrays.asList(item.getChildren()));
                    return this.filter(children.toArray(new IParseNode[children.size()]));
                }
            }
        }
        if (parentElement instanceof HTMLSpecialNode) {
            item = (HTMLSpecialNode)parentElement;
            attribute = this.getExternalJSReference((HTMLSpecialNode)item);
            if (attribute != null && attribute.length() > 0) {
                return this.getExternalChildren((IParseNode)item, attribute, "com.aptana.contenttype.js");
            }
            return this.getChildren(item.getChild(0));
        }
        return super.getChildren(parentElement);
    }

    private String getExternalJSReference(HTMLSpecialNode item) {
        if (!this.isJavascriptTag(item)) {
            return null;
        }
        return item.getAttributeValue("src");
    }

    private boolean isJavascriptTag(HTMLSpecialNode item) {
        if (item == null) {
            return false;
        }
        if (!item.getName().equalsIgnoreCase("script")) {
            return false;
        }
        String type = item.getAttributeValue("type");
        return type == null || HTMLParser.isJavaScript((HTMLElementNode)item);
    }

    private boolean isStylesheetLinkTag(HTMLElementNode item) {
        if (item == null) {
            return false;
        }
        if (!item.getName().equalsIgnoreCase("link")) {
            return false;
        }
        String rel = item.getAttributeValue("rel");
        return rel != null && rel.equals("stylesheet");
    }

    private String getExternalCSSReference(HTMLElementNode item) {
        if (!this.isStylesheetLinkTag(item)) {
            return null;
        }
        return item.getAttributeValue("href");
    }

    public boolean hasChildren(Object element) {
        String attribute;
        HTMLElementNode item;
        if (element instanceof HTMLOutlineItem) {
            return this.hasChildren(((HTMLOutlineItem)((Object)element)).getReferenceNode());
        }
        if (element instanceof HTMLElementNode && this.isStylesheetLinkTag(item = (HTMLElementNode)element)) {
            String attribute2 = this.getExternalCSSReference(item);
            return attribute2 != null && attribute2.length() > 0;
        }
        if (element instanceof HTMLSpecialNode && (attribute = this.getExternalJSReference((HTMLSpecialNode)(item = (HTMLSpecialNode)element))) != null && attribute.length() > 0) {
            return true;
        }
        return super.hasChildren(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getExternalChildren(final IParseNode parent, final String srcPathOrURL, final String language) {
        Object[] cached;
        Map<String, Object[]> map = this.cache;
        synchronized (map) {
            cached = this.cache.get(srcPathOrURL);
        }
        if (cached != null) {
            return cached;
        }
        if (this.resolver == null) {
            return EMPTY;
        }
        Job job = new Job(Messages.HTMLOutlineContentProvider_FetchingExternalFilesJobName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                Object[] elements;
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    String source = HTMLOutlineContentProvider.this.resolver.resolveSource(srcPathOrURL, (IProgressMonitor)sub.newChild(50));
                    if (source == null) {
                        throw new Exception(Messages.HTMLOutlineContentProvider_UnableToResolveFile_Error);
                    }
                    IParseRootNode node = ParserPoolFactory.parse((String)language, (String)source, (int)0, (IProgressMonitor)sub.newChild(90)).getRootNode();
                    Object[] objectArray = elements = HTMLOutlineContentProvider.this.getChildren(node);
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element instanceof CommonOutlineItem) {
                            ((CommonOutlineItem)element).setRange((IRange)new Range(parent.getStartingOffset(), parent.getEndingOffset()));
                        }
                        ++n2;
                    }
                    Map map = HTMLOutlineContentProvider.this.cache;
                    synchronized (map) {
                        HTMLOutlineContentProvider.this.cache.put(srcPathOrURL, elements);
                    }
                }
                catch (FileNotFoundException e) {
                    IdeLog.logTrace((Plugin)HTMLPlugin.getDefault(), (String)e.getMessage(), (Throwable)e, (String)"com.aptana.editor.html/debug/outline");
                    elements = new Object[]{new OutlinePlaceholderItem(4, MessageFormat.format(Messages.HTMLOutlineContentProvider_FileNotFound_Error, e.getMessage()))};
                }
                catch (Parser.Exception e) {
                    IdeLog.logTrace((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format("Unable to parse the content in {0}", srcPathOrURL), (Throwable)e, (String)"com.aptana.editor.html/debug/outline");
                    elements = new Object[]{new OutlinePlaceholderItem(4, Messages.HTMLOutlineContentProvider_ERR_ParseContent)};
                }
                catch (Exception e) {
                    IdeLog.logTrace((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format("{0} ''{1}''", e.getMessage(), srcPathOrURL), (Throwable)e, (String)"com.aptana.editor.html/debug/outline");
                    elements = new Object[]{new OutlinePlaceholderItem(4, e.getMessage())};
                }
                final Object[] finalElements = elements;
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        HTMLOutlineContentProvider.this.treeViewer.add((Object)HTMLOutlineContentProvider.this.getOutlineItem(parent), finalElements);
                    }
                });
                sub.done();
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.schedule();
        final OutlinePlaceholderItem placeholder = new OutlinePlaceholderItem(1, Messages.HTMLOutlineContentProvider_PlaceholderItemLabel);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (HTMLOutlineContentProvider.this.treeViewer != null && HTMLOutlineContentProvider.this.treeViewer.getTree() != null && !HTMLOutlineContentProvider.this.treeViewer.getTree().isDisposed()) {
                            HTMLOutlineContentProvider.this.treeViewer.remove((Object)placeholder);
                        }
                    }
                });
            }
        });
        return new Object[]{placeholder};
    }

    public Object getParent(Object element) {
        if (element instanceof CommonOutlineItem) {
            IParseNode node = ((CommonOutlineItem)element).getReferenceNode();
            IParseNode parent = node.getParent();
            if (parent instanceof ParseRootNode) {
                parent = parent.getParent();
            }
            return this.getOutlineItem(parent);
        }
        return super.getParent(element);
    }

    protected Object[] filter(IParseNode[] nodes) {
        ArrayList<CommonOutlineItem> items = new ArrayList<CommonOutlineItem>();
        IParseNode[] iParseNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode node = iParseNodeArray[n2];
            if (!(node instanceof HTMLCommentNode) && (!(node instanceof HTMLTextNode) || this.showTextNode && !StringUtil.isEmpty((String)((HTMLTextNode)node).getText()))) {
                if (node instanceof HTMLElementNode) {
                    HTMLElementNode element = (HTMLElementNode)node;
                    if (element.getName().length() > 0) {
                        items.add(this.getOutlineItem((IParseNode)element));
                    }
                } else {
                    items.add(this.getOutlineItem(node));
                }
            }
            ++n2;
        }
        return items.toArray(new CommonOutlineItem[items.size()]);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.treeViewer = (TreeViewer)viewer;
        if (this.fEditor != null) {
            this.resolver = PathResolverProvider.getResolver((IEditorInput)this.fEditor.getEditorInput());
        }
        super.inputChanged(viewer, oldInput, newInput);
    }

    public CommonOutlineItem getOutlineItem(IParseNode node) {
        if (node instanceof HTMLNode) {
            return new HTMLOutlineItem(node.getNameNode().getNameRange(), node);
        }
        return super.getOutlineItem(node);
    }
}

