/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.parsing;

import com.aptana.editor.common.text.rules.PartitionerSwitchingIgnoreRule;
import com.aptana.editor.common.text.rules.TagRule;
import com.aptana.editor.common.text.rules.WhitespaceDetector;
import com.aptana.editor.common.text.rules.WordDetector;
import com.aptana.editor.html.parsing.HTMLParserTagRule;
import com.aptana.editor.html.parsing.lexer.HTMLTokens;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class HTMLTokenScanner
extends RuleBasedScanner {
    private IRule generalTagRule;

    public HTMLTokenScanner() {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector(), this.createToken(HTMLTokenScanner.getTokenName((short)4))));
        rules.add(new PartitionerSwitchingIgnoreRule((IPredicateRule)new MultiLineRule("<!--", "-->", this.createToken(HTMLTokenScanner.getTokenName((short)8)), '\u0000', true)));
        IToken token = this.createToken(HTMLTokenScanner.getTokenName((short)9));
        rules.add(new MultiLineRule("<!DOCTYPE ", ">", token));
        rules.add(new MultiLineRule("<!doctype ", ">", token));
        rules.add(new MultiLineRule("<![CDATA[", "]]>", this.createToken(HTMLTokenScanner.getTokenName((short)12))));
        rules.add(new TagRule("script", this.createToken(HTMLTokenScanner.getTokenName((short)2)), true));
        rules.add(new TagRule("/script", this.createToken(HTMLTokenScanner.getTokenName((short)11)), true));
        rules.add(new TagRule("style", this.createToken(HTMLTokenScanner.getTokenName((short)1)), true));
        rules.add(new TagRule("/style", this.createToken(HTMLTokenScanner.getTokenName((short)10)), true));
        rules.add(new TagRule("?xml", this.createToken(HTMLTokenScanner.getTokenName((short)6))));
        rules.add(new TagRule("/", this.createToken(HTMLTokenScanner.getTokenName((short)5))));
        this.generalTagRule = new HTMLParserTagRule(this.createToken(HTMLTokenScanner.getTokenName((short)3)));
        rules.add(this.generalTagRule);
        token = this.createToken(HTMLTokenScanner.getTokenName((short)4));
        rules.add(new WordRule((IWordDetector)new WordDetector(), token));
        this.setRules(rules.toArray(new IRule[rules.size()]));
        this.setDefaultReturnToken(token);
    }

    public void setInsideSpecialTag(boolean special) {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        rules.addAll(Arrays.asList(this.fRules));
        if (special) {
            rules.remove(this.generalTagRule);
        } else {
            rules.add(this.generalTagRule);
        }
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }

    protected IToken createToken(String string) {
        return new Token((Object)string);
    }

    private static String getTokenName(short token) {
        return HTMLTokens.getTokenName(token);
    }
}

