/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.text.hyperlink;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.text.hyperlink.EditorSearchHyperlink;
import com.aptana.editor.common.text.hyperlink.IndexQueryingHyperlinkDetector;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.index.core.Index;
import com.aptana.index.core.QueryResult;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;

public class CSSClassHyperlinkDetector
extends IndexQueryingHyperlinkDetector {
    private static final Pattern CSS_CLASS_PATTERN = Pattern.compile("class=[\"'\ufffd]([_a-zA-Z0-9-]+)[\"'\ufffd]");

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        List results;
        String cssClass;
        Matcher m;
        IRegion lineRegion;
        ArrayList<EditorSearchHyperlink> hyperlinks;
        block10: {
            Index index;
            block9: {
                block8: {
                    hyperlinks = new ArrayList<EditorSearchHyperlink>();
                    IDocument doc = textViewer.getDocument();
                    lineRegion = doc.getLineInformationOfOffset(region.getOffset());
                    String line = doc.get(lineRegion.getOffset(), lineRegion.getLength());
                    m = CSS_CLASS_PATTERN.matcher(line);
                    if (m.find()) break block8;
                    return null;
                }
                index = this.getIndex();
                if (index != null) break block9;
                return null;
            }
            cssClass = m.group(1);
            results = index.query(new String[]{"css.class"}, cssClass, 8);
            if (results != null && !results.isEmpty()) break block10;
            return null;
        }
        try {
            int start = m.start(1) + lineRegion.getOffset();
            int length = m.end(1) - m.start(1);
            Region linkRegion = new Region(start, length);
            for (QueryResult result : results) {
                Set documents = result.getDocuments();
                if (documents == null || documents.isEmpty()) continue;
                for (String filepath : documents) {
                    hyperlinks.add(new EditorSearchHyperlink((IRegion)linkRegion, "." + cssClass, new URI(filepath)));
                    if (canShowMultipleHyperlinks) continue;
                    return new IHyperlink[]{(IHyperlink)hyperlinks.get(0)};
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
        if (hyperlinks.isEmpty()) {
            return null;
        }
        return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
    }
}

