/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.validator;

import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.core.IFilter;
import com.aptana.core.IMap;
import com.aptana.core.build.AbstractBuildParticipant;
import com.aptana.core.build.IProblem;
import com.aptana.core.build.Problem;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.contentassist.model.AttributeElement;
import com.aptana.editor.html.contentassist.model.ElementElement;
import com.aptana.editor.html.contentassist.model.EntityElement;
import com.aptana.editor.html.contentassist.model.EventElement;
import com.aptana.editor.html.contentassist.model.ValueElement;
import com.aptana.editor.html.parsing.HTMLDocumentTypes;
import com.aptana.editor.html.parsing.HTMLParseState;
import com.aptana.editor.html.parsing.ast.HTMLCommentNode;
import com.aptana.editor.html.parsing.ast.HTMLElementNode;
import com.aptana.editor.html.parsing.ast.HTMLNode;
import com.aptana.editor.html.parsing.ast.HTMLTextNode;
import com.aptana.editor.html.validator.Messages;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.util.ParseUtil;
import com.aptana.parsing.xpath.ParseNodeNavigator;
import com.aptana.parsing.xpath.ParseNodeXPath;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.jaxen.JaxenException;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLTidyValidator
extends AbstractBuildParticipant {
    private static final EnumSet<HTMLDocumentTypes.Type> XHTML_TYPES = EnumSet.of(HTMLDocumentTypes.Type.XHTML_1_0_FRAMESET, HTMLDocumentTypes.Type.XHTML_1_0_STRICT, HTMLDocumentTypes.Type.XHTML_1_0_TRANSITIONAL, HTMLDocumentTypes.Type.XHTML_1_1_STRICT);
    public static final String ID = "com.aptana.editor.html.validator.TidyValidator";
    private static final String BOOLEAN_TYPE = "Boolean";
    private static final Pattern DOCTYPE_PATTERN = Pattern.compile("<!(DOCTYPE)\\s+HTML(\\s+((SYSTEM)\\s+[\"']about:legacy-compat[\"']|(PUBLIC)\\s+[\"']\\-//(W3C)//(DTD)\\s+[^/]+//(EN)[\"'](\\s+[\"'].+[\"'])?))?>", 10);
    private static final Pattern ENTITY_PATTERN = Pattern.compile("&(\\S+)?");
    private static ParseNodeXPath FRAMESET_TAG;
    private static ParseNodeXPath BODY_TAG;
    private static ParseNodeXPath NOFRAMES_TAG;
    private static ParseNodeXPath HTML_CHILDREN;
    private HTMLIndexQueryHelper fQueryHelper;
    private Map<String, ElementElement> fElementsMap;
    private Map<String, AttributeElement> fAttributesMap;
    private Map<String, EntityElement> fEntityMap;
    private Map<String, EventElement> fEventMap;
    private Set<String> fIds;
    private boolean foundTitle;
    private String sourcePath;
    private Document doc;
    private HTMLDocumentTypes.Type docType;

    static {
        try {
            ParseNodeNavigator caseInsensitive = new ParseNodeNavigator(true);
            BODY_TAG = new ParseNodeXPath("/html/body", caseInsensitive);
            FRAMESET_TAG = new ParseNodeXPath("/html/frameset", caseInsensitive);
            NOFRAMES_TAG = new ParseNodeXPath("/html/frameset/noframes", caseInsensitive);
            HTML_CHILDREN = new ParseNodeXPath("/html/*", caseInsensitive);
        }
        catch (JaxenException e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
    }

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        context.removeProblems("com.aptana.editor.html.tidy_problem");
    }

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        this.fQueryHelper = new HTMLIndexQueryHelper();
        this.fIds = new HashSet<String>();
        try {
            this.sourcePath = context.getURI().toString();
            List<IProblem> problems = new ArrayList<IProblem>();
            try {
                String source = context.getContents();
                if (!StringUtil.isEmpty((String)source)) {
                    this.docType = HTMLDocumentTypes.getType(source);
                    this.doc = new Document(source);
                    problems.addAll(this.validateDoctype());
                    IParseRootNode ast = context.getAST();
                    if (ast != null) {
                        this.foundTitle = false;
                        problems.addAll(this.validateFrames(ast));
                        problems.addAll(this.validateAST(ast));
                        if (!this.foundTitle) {
                            try {
                                problems.add(this.createProblem(ProblemType.InsertMissingTitle, Messages.HTMLTidyValidator_InsertMissingTitle, 0, 0));
                            }
                            catch (BadLocationException e) {
                                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
                            }
                        }
                    }
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format("Failed to validate {0} using HTML Tidy validator", this.sourcePath), (Throwable)e);
            }
            final List filters = this.getFilters();
            problems = CollectionsUtil.filter(problems, (IFilter)new IFilter<IProblem>(){

                public boolean include(IProblem item) {
                    return item != null && !HTMLTidyValidator.this.isIgnored(item.getMessage(), filters);
                }
            });
            context.putProblems("com.aptana.editor.html.tidy_problem", problems);
        }
        finally {
            this.doc = null;
            this.sourcePath = null;
            this.fElementsMap = null;
            this.fAttributesMap = null;
            this.fEntityMap = null;
            this.fIds = null;
            this.fQueryHelper = null;
        }
    }

    private Collection<IProblem> checkLink(HTMLElementNode aNode) {
        String id = aNode.getAttributeValue("id");
        String name = aNode.getAttributeValue("name");
        if (id != null && name != null && !name.equals(id)) {
            try {
                int offset = aNode.getStartingOffset();
                int length = aNode.getLength();
                return CollectionsUtil.newList((Object[])new IProblem[]{this.createProblem(ProblemType.IdNameAttributeMismatch, Messages.HTMLTidyValidator_IdNameAttributeMismatch, offset, length)});
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    private Collection<IProblem> validateFrames(IParseRootNode ast) {
        ArrayList<IProblem> problems = new ArrayList<IProblem>();
        try {
            List framesetNodes = (List)FRAMESET_TAG.evaluate((Object)ast);
            if (!CollectionsUtil.isEmpty((Collection)framesetNodes)) {
                int i = 0;
                while (i < framesetNodes.size()) {
                    if (i != 0) {
                        HTMLElementNode framesetNode = (HTMLElementNode)framesetNodes.get(i);
                        IRange range = framesetNode.getNameNode().getNameRange();
                        int offset = range.getStartingOffset();
                        int length = range.getLength();
                        problems.add(this.createProblem(ProblemType.RepeatedFrameset, Messages.HTMLTidyValidator_RepeatedFrameset, offset, length));
                    }
                    ++i;
                }
                List noFramesNodes = (List)NOFRAMES_TAG.evaluate((Object)ast);
                HTMLElementNode noFrames = null;
                if (!CollectionsUtil.isEmpty((Collection)noFramesNodes)) {
                    noFrames = (HTMLElementNode)noFramesNodes.get(0);
                }
                if (noFrames == null) {
                    List bodyNode = (List)BODY_TAG.evaluate((Object)ast);
                    if (!CollectionsUtil.isEmpty((Collection)bodyNode)) {
                        IRange range = ((HTMLElementNode)bodyNode.iterator().next()).getNameNode().getNameRange();
                        int offset = range.getStartingOffset();
                        problems.add(this.createProblem(ProblemType.InsertImplicitNoFrames, Messages.HTMLTidyValidator_InsertImplicitNoFrames, offset, range.getLength()));
                    } else {
                        HTMLElementNode invalidContentNode = this.invalidContentNode(ast);
                        if (invalidContentNode != null) {
                            IRange range = invalidContentNode.getNameNode().getNameRange();
                            problems.add(this.createProblem(ProblemType.MissingNoFrames, Messages.HTMLTidyValidator_MissingNoFrames, range.getStartingOffset(), range.getLength()));
                        }
                    }
                } else {
                    HTMLElementNode invalidContentNode = this.invalidContentNode(ast);
                    if (invalidContentNode != null) {
                        IRange range = invalidContentNode.getNameNode().getNameRange();
                        problems.add(this.createProblem(ProblemType.ElementNotInsideNoFrames, MessageFormat.format(Messages.HTMLTidyValidator_ElementNotInsideNoFrames, invalidContentNode.getElementName()), range.getStartingOffset(), range.getLength()));
                    }
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
        return problems;
    }

    private HTMLElementNode invalidContentNode(IParseRootNode ast) {
        try {
            List htmlChildren = (List)HTML_CHILDREN.evaluate((Object)ast);
            if (!CollectionsUtil.isEmpty((Collection)htmlChildren)) {
                Set validTags = CollectionsUtil.newSet((Object[])new String[]{"body", "head", "frameset"});
                for (HTMLNode htmlChild : htmlChildren) {
                    HTMLElementNode element;
                    String tagName;
                    if (!(htmlChild instanceof HTMLElementNode) || validTags.contains(tagName = (element = (HTMLElementNode)htmlChild).getElementName().toLowerCase())) continue;
                    return element;
                }
            }
        }
        catch (JaxenException e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    private Collection<IProblem> validateAST(IParseRootNode root) {
        final ArrayList<IProblem> problems = new ArrayList<IProblem>();
        ParseUtil.treeApply((IParseNode)root, (IFilter)new IFilter<IParseNode>(){

            public boolean include(IParseNode node) {
                problems.addAll(HTMLTidyValidator.this.handleNode(node));
                return true;
            }
        });
        return problems;
    }

    private Collection<IProblem> handleNode(IParseNode node) {
        if (!(node instanceof HTMLNode)) {
            return Collections.emptyList();
        }
        switch (node.getNodeType()) {
            case 2: 
            case 3: {
                return this.validateElement((HTMLElementNode)node);
            }
            case 4: {
                return this.validateComment((HTMLCommentNode)node);
            }
            case 5: {
                return this.validateTextContent((HTMLTextNode)node);
            }
        }
        return Collections.emptyList();
    }

    private Collection<IProblem> validateElement(HTMLElementNode element) {
        ArrayList<IProblem> problems = new ArrayList<IProblem>(2);
        try {
            ElementElement ee;
            String tagName = element.getName().toLowerCase();
            if (!this.foundTitle && "title".equals(tagName)) {
                this.foundTitle = true;
            }
            if ((ee = this.getElement(tagName)) == null) {
                int offset = element.getStartingOffset();
                int length = element.getLength();
                problems.add(this.createProblem(ProblemType.ElementNotRecognized, MessageFormat.format(Messages.HTMLTidyValidator_ElementNotRecognized, tagName), offset, length));
            } else {
                int offset;
                problems.addAll(this.validateAttributes(element));
                String deprecated = ee.getDeprecated();
                if (!StringUtil.isEmpty((String)deprecated)) {
                    offset = element.getStartingOffset();
                    problems.add(this.createProblem(ProblemType.DeprecatedElement, MessageFormat.format(Messages.HTMLTidyValidator_DeprecatedElement, tagName, deprecated), offset, element.getLength()));
                }
                if (!HTMLParseState.isEmptyTagType(tagName) && ArrayUtil.isEmpty((Object[])element.getChildren()) && (!"script".equals(tagName) || StringUtil.isEmpty((String)element.getAttributeValue("src")))) {
                    offset = element.getStartingOffset();
                    problems.add(this.createProblem(ProblemType.TrimEmptyElement, MessageFormat.format(Messages.HTMLTidyValidator_TrimEmptyElement, tagName), offset, element.getLength()));
                }
                if (HTMLParseState.isEmptyTagType(tagName) && !ArrayUtil.isEmpty((Object[])element.getChildren())) {
                    offset = element.getStartingOffset();
                    problems.add(this.createProblem(ProblemType.ElementNotEmptyOrClosed, MessageFormat.format(Messages.HTMLTidyValidator_ElementNotEmptyOrClosed, tagName), offset, element.getLength()));
                }
            }
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
        return problems;
    }

    private Collection<IProblem> validateAttributes(HTMLElementNode element) throws BadLocationException {
        Object[] attributes = element.getAttributes();
        if (ArrayUtil.isEmpty((Object[])attributes)) {
            return Collections.emptyList();
        }
        ArrayList<IProblem> problems = new ArrayList<IProblem>(attributes.length);
        String tagName = element.getElementName();
        if ("a".equalsIgnoreCase(tagName)) {
            problems.addAll(this.checkLink(element));
        }
        Object[] objectArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            int offset;
            AttributeElement ae;
            Object attr = objectArray[n2];
            String attrName = attr.getName();
            String attrValue = attr.getValue();
            if ("id".equalsIgnoreCase(attrName)) {
                if (this.fIds.contains(attrValue)) {
                    int offset2 = element.getStartingOffset();
                    problems.add(this.createProblem(ProblemType.NonUniqueIdValue, MessageFormat.format(Messages.HTMLTidyValidator_NonUniqueIdValue, tagName, attrValue), offset2, element.getNameNode().getNameRange().getLength()));
                } else {
                    this.fIds.add(attrValue);
                }
            }
            if ((ae = this.getAttribute(tagName, attrName)) == null) {
                EventElement event = this.getEvent(attrName);
                if (event == null && !XHTML_TYPES.contains((Object)this.docType)) {
                    offset = element.getStartingOffset();
                    problems.add(this.createProblem(ProblemType.ProprietaryAttribute, MessageFormat.format(Messages.HTMLTidyValidator_ProprietaryAttribute, tagName, attrName, attrValue), offset, element.getNameNode().getNameRange().getLength()));
                }
            } else {
                List<ValueElement> values;
                String deprecated = ae.getDeprecated();
                if (!StringUtil.isEmpty((String)deprecated)) {
                    offset = element.getStartingOffset();
                    problems.add(this.createProblem(ProblemType.DeprecatedAttribute, MessageFormat.format(Messages.HTMLTidyValidator_DeprecatedAttribute, tagName, attrName, attrValue), offset, element.getNameNode().getNameRange().getLength()));
                }
                if (!CollectionsUtil.isEmpty(values = ae.getValues())) {
                    boolean validAttribute = false;
                    if (BOOLEAN_TYPE.equalsIgnoreCase(ae.getType())) {
                        validAttribute = StringUtil.isEmpty((String)attrValue) || attrName.equalsIgnoreCase(attrValue);
                    } else {
                        for (ValueElement value : values) {
                            String valueName = value.getName();
                            if (!valueName.equals(attrValue) && !"*".equals(valueName)) continue;
                            validAttribute = true;
                            break;
                        }
                    }
                    if (!validAttribute) {
                        int offset3 = element.getStartingOffset();
                        problems.add(this.createProblem(ProblemType.InvalidAttributeValue, MessageFormat.format(Messages.HTMLTidyValidator_InvalidAttributeValue, tagName, attrName, attrValue), offset3, element.getNameNode().getNameRange().getLength()));
                    }
                }
            }
            ++n2;
        }
        return problems;
    }

    private Collection<IProblem> validateComment(HTMLCommentNode comment) {
        return Collections.emptyList();
    }

    private Collection<IProblem> validateTextContent(HTMLTextNode textNode) {
        String text = textNode.getText();
        if (StringUtil.isEmpty((String)text) || text.indexOf(38) == -1) {
            return Collections.emptyList();
        }
        ArrayList<IProblem> problems = new ArrayList<IProblem>(2);
        Matcher m = ENTITY_PATTERN.matcher(text);
        while (m.find()) {
            try {
                String msg;
                ProblemType type;
                int offset = textNode.getStartingOffset() + m.start();
                String entity = m.group(1);
                if (entity == null) {
                    problems.add(this.createProblem(ProblemType.UnescapedAmpersand, Messages.HTMLTidyValidator_UnescapedAmpersand, offset, 1));
                    continue;
                }
                if (entity.endsWith(";")) continue;
                EntityElement entityEl = this.getEntity(String.valueOf('&') + entity + ';');
                if (entityEl != null) {
                    type = ProblemType.EntityMissingSemicolon;
                    msg = MessageFormat.format(Messages.HTMLTidyValidator_EntityMissingSemicolon, entity);
                } else {
                    type = ProblemType.UnknownEntity;
                    msg = MessageFormat.format(Messages.HTMLTidyValidator_UnknownEntity, entity);
                }
                problems.add(this.createProblem(type, msg, offset, entity.length() + 1));
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            }
        }
        return problems;
    }

    private EntityElement getEntity(String entityName) {
        if (this.fEntityMap == null) {
            List<EntityElement> entities = this.fQueryHelper.getEntities();
            this.fEntityMap = CollectionsUtil.mapFromValues(entities, (IMap)new IMap<EntityElement, String>(){

                public String map(EntityElement item) {
                    return item.getName();
                }
            });
        }
        return this.fEntityMap.get(entityName);
    }

    private EventElement getEvent(String eventName) {
        if (this.fEventMap == null) {
            List<EventElement> events = this.fQueryHelper.getEvents();
            this.fEventMap = CollectionsUtil.mapFromValues(events, (IMap)new IMap<EventElement, String>(){

                public String map(EventElement item) {
                    return item.getName();
                }
            });
        }
        return this.fEventMap.get(eventName);
    }

    private ElementElement getElement(String tagName) {
        if (this.fElementsMap == null) {
            List<ElementElement> elements = this.fQueryHelper.getElements();
            this.fElementsMap = CollectionsUtil.mapFromValues(elements, (IMap)new IMap<ElementElement, String>(){

                public String map(ElementElement item) {
                    return item.getName();
                }
            });
        }
        return this.fElementsMap.get(tagName);
    }

    private AttributeElement getAttribute(String tagName, String attributeName) {
        AttributeElement ae;
        if (this.fAttributesMap == null) {
            List<AttributeElement> attrs = this.fQueryHelper.getAttributes();
            this.fAttributesMap = CollectionsUtil.mapFromValues(attrs, (IMap)new IMap<AttributeElement, String>(){

                public String map(AttributeElement item) {
                    String element = item.getElement();
                    if (StringUtil.isEmpty((String)element)) {
                        return item.getName();
                    }
                    return String.valueOf(element) + "_" + item.getName();
                }
            });
        }
        if ((ae = this.fAttributesMap.get(String.valueOf(tagName.toLowerCase()) + "_" + attributeName)) != null) {
            return ae;
        }
        return this.fAttributesMap.get(attributeName);
    }

    private Collection<IProblem> validateDoctype() {
        String source = this.doc.get();
        ArrayList<IProblem> problems = new ArrayList<IProblem>(2);
        try {
            String before;
            int doctypeIndex = source.indexOf("<!DOCTYPE");
            if (doctypeIndex == -1) {
                doctypeIndex = source.indexOf("<!doctype");
            }
            if (doctypeIndex == -1) {
                return CollectionsUtil.newList((Object[])new IProblem[]{this.createProblem(ProblemType.MissingDoctype, Messages.HTMLTidyValidator_MissingDoctype, 0, 0)});
            }
            Matcher m = DOCTYPE_PATTERN.matcher(source);
            if (m.find()) {
                String rest = m.group(2);
                if (!StringUtil.isEmpty((String)rest)) {
                    String publicStr;
                    String systemStr = m.group(4);
                    if (systemStr != null) {
                        int offsetUppercase = m.start(4);
                        if (!systemStr.equals("SYSTEM")) {
                            problems.add(this.createProblem(ProblemType.UppercaseDoctype, Messages.HTMLTidyValidator_UppercaseDoctype, offsetUppercase, 6));
                        }
                    }
                    if ((publicStr = m.group(5)) != null) {
                        int offsetUppercase = m.start(5);
                        if (!publicStr.equals("PUBLIC")) {
                            problems.add(this.createProblem(ProblemType.UppercaseDoctype, Messages.HTMLTidyValidator_UppercaseDoctype, offsetUppercase, 6));
                        }
                        String w3cStr = m.group(6);
                        offsetUppercase = m.start(6);
                        if (!w3cStr.equals("W3C")) {
                            problems.add(this.createProblem(ProblemType.UppercaseDoctype, Messages.HTMLTidyValidator_UppercaseDoctype, offsetUppercase, 3));
                        }
                        String dtdStr = m.group(7);
                        offsetUppercase = m.start(7);
                        if (!dtdStr.equals("DTD")) {
                            problems.add(this.createProblem(ProblemType.UppercaseDoctype, Messages.HTMLTidyValidator_UppercaseDoctype, offsetUppercase, 3));
                        }
                        String enStr = m.group(8);
                        offsetUppercase = m.start(8);
                        if (!enStr.equals("EN")) {
                            problems.add(this.createProblem(ProblemType.UppercaseDoctype, Messages.HTMLTidyValidator_UppercaseDoctype, offsetUppercase, 2));
                        }
                    }
                }
            } else {
                problems.add(this.createProblem(ProblemType.MalformedDoctype, Messages.HTMLTidyValidator_MalformedDoctype, doctypeIndex, 9));
            }
            if (!StringUtil.isEmpty((String)(before = source.substring(0, doctypeIndex))) && !XHTML_TYPES.contains((Object)this.docType)) {
                problems.add(this.createProblem(ProblemType.DoctypeAfterElements, Messages.HTMLTidyValidator_DoctypeAfterElements, doctypeIndex, 9));
            }
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
        return problems;
    }

    private IProblem createProblem(ProblemType type, String message, int offset, int length) throws BadLocationException {
        IProblem.Severity severity = this.getSeverity(type);
        if (severity == IProblem.Severity.IGNORE) {
            return null;
        }
        int lineNumber = this.doc.getLineOfOffset(offset) + 1;
        Problem problem = new Problem(severity.intValue(), message, offset, length, lineNumber, this.sourcePath);
        problem.setAttribute(ID, (Object)type.id);
        return problem;
    }

    private IProblem.Severity getSeverity(ProblemType type) {
        int num = this.getPreferenceInt(type.getPrefKey(), IProblem.Severity.WARNING.intValue());
        return IProblem.Severity.create((int)num);
    }

    public void restoreDefaults() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(this.getPreferenceNode());
        ProblemType[] problemTypeArray = ProblemType.values();
        int n = problemTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProblemType type = problemTypeArray[n2];
            prefs.remove(type.getPrefKey());
            ++n2;
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
        }
        super.restoreDefaults();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProblemCategory {
        Doctype("!DOCTYPE"),
        Entities("Entities"),
        Elements("Elements"),
        Attributes("Attributes");

        private String label;

        private ProblemCategory(String label) {
            this.label = label;
        }

        public String label() {
            return this.label;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProblemType {
        DeprecatedAttribute(ProblemCategory.Attributes, 256, "Deprecated Attributes"),
        DeprecatedElement(ProblemCategory.Elements, 257, "Deprecated Elements"),
        DoctypeAfterElements(ProblemCategory.Doctype, 258, Messages.HTMLTidyValidator_DoctypeAfterElements),
        ElementNotEmptyOrClosed(ProblemCategory.Elements, 259, "Unclosed elements"),
        ElementNotInsideNoFrames(ProblemCategory.Elements, 260, "Elements outside <noframes>"),
        ElementNotRecognized(ProblemCategory.Elements, 261, "Unrecognized elements"),
        EntityMissingSemicolon(ProblemCategory.Entities, 262, "Entity missing trailing semicolon"),
        IdNameAttributeMismatch(ProblemCategory.Attributes, 263, Messages.HTMLTidyValidator_IdNameAttributeMismatch),
        InsertImplicitNoFrames(ProblemCategory.Elements, 264, Messages.HTMLTidyValidator_InsertImplicitNoFrames),
        InsertMissingTitle(ProblemCategory.Elements, 265, "Missing <title> element"),
        InvalidAttributeValue(ProblemCategory.Attributes, 266, "Invalid attribute values"),
        MalformedDoctype(ProblemCategory.Doctype, 267, "Malformed !DOCTYPE"),
        MissingCloseTag(ProblemCategory.Elements, 268, "Missing close tags"),
        MissingDoctype(ProblemCategory.Doctype, 269, Messages.HTMLTidyValidator_MissingDoctype),
        MissingNoFrames(ProblemCategory.Elements, 270, Messages.HTMLTidyValidator_MissingNoFrames),
        NonUniqueIdValue(ProblemCategory.Attributes, 271, "Non-unique id attribute value"),
        ProprietaryAttribute(ProblemCategory.Attributes, 272, "Proprietary attributes"),
        RepeatedFrameset(ProblemCategory.Elements, 273, Messages.HTMLTidyValidator_RepeatedFrameset),
        TrimEmptyElement(ProblemCategory.Elements, 274, "Trim empty elements"),
        UnescapedAmpersand(ProblemCategory.Entities, 275, "Unescaped ampersand (&& which should be &&amp;)"),
        UnknownEntity(ProblemCategory.Entities, 276, "Unescaped or unknown entity"),
        UppercaseDoctype(ProblemCategory.Doctype, 277, Messages.HTMLTidyValidator_UppercaseDoctype);

        private int id;
        private String description;
        private ProblemCategory category;

        private ProblemType(ProblemCategory category, int id, String description) {
            this.category = category;
            this.id = id;
            this.description = description;
        }

        public ProblemCategory category() {
            return this.category;
        }

        public String description() {
            return this.description;
        }

        public int getId() {
            return this.id;
        }

        public String getPrefKey() {
            return "problem_" + this.getId();
        }
    }
}

