/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting;

import com.aptana.core.logging.IdeLog;
import com.aptana.filewatcher.FileWatcher;
import com.aptana.scripting.ScriptingActivator;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.contentobjects.jnotify.JNotifyException;
import net.contentobjects.jnotify.JNotifyListener;
import org.eclipse.core.runtime.Plugin;

public class FileChangeNotifier {
    private static Map<IFileChangeListener, Integer> listeners = new HashMap<IFileChangeListener, Integer>();

    public static boolean addListener(String filepath, boolean watchSubtree, final IFileChangeListener listener) {
        final File file = new File(filepath);
        if (!file.exists()) {
            return false;
        }
        final boolean filterToSingleFile = file.isFile();
        if (filterToSingleFile) {
            filepath = file.getParentFile().getAbsolutePath();
        }
        try {
            int watchId = FileWatcher.addWatch((String)filepath, (int)15, (boolean)watchSubtree, (JNotifyListener)new JNotifyListener(){

                public void fileRenamed(int wd, String rootPath, String oldName, String newName) {
                    if (oldName != null && newName != null && oldName.equals(newName)) {
                        this.fileModified(wd, rootPath, newName);
                        return;
                    }
                    if (filterToSingleFile && this.doesntMatch(rootPath, oldName)) {
                        return;
                    }
                    FileModificationEvent e = new FileModificationEvent();
                    e.type = 3;
                    e.oldName = String.valueOf(rootPath) + File.separator + oldName;
                    e.name = String.valueOf(rootPath) + File.separator + newName;
                    listener.fileModified(e);
                }

                public void fileModified(int wd, String rootPath, String name) {
                    if (filterToSingleFile && this.doesntMatch(rootPath, name)) {
                        return;
                    }
                    FileModificationEvent e = new FileModificationEvent();
                    e.type = 2;
                    e.oldName = e.name = String.valueOf(rootPath) + File.separator + name;
                    listener.fileModified(e);
                }

                private boolean doesntMatch(String rootPath, String name) {
                    String singleFilePath = file.getAbsolutePath();
                    String fullPath = String.valueOf(rootPath) + File.separator + name;
                    return !fullPath.equals(singleFilePath);
                }

                public void fileDeleted(int wd, String rootPath, String name) {
                    if (filterToSingleFile && this.doesntMatch(rootPath, name)) {
                        return;
                    }
                    FileModificationEvent e = new FileModificationEvent();
                    e.type = 1;
                    e.oldName = e.name = String.valueOf(rootPath) + File.separator + name;
                    listener.fileModified(e);
                }

                public void fileCreated(int wd, String rootPath, String name) {
                    if (filterToSingleFile && this.doesntMatch(rootPath, name)) {
                        return;
                    }
                    FileModificationEvent e = new FileModificationEvent();
                    e.type = 0;
                    e.name = String.valueOf(rootPath) + File.separator + name;
                    listener.fileModified(e);
                }
            });
            listeners.put(listener, watchId);
            return true;
        }
        catch (JNotifyException e) {
            IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)"Error adding file change listener", (Throwable)e);
            return false;
        }
    }

    public static boolean removeListener(IFileChangeListener listener) {
        if (listener == null || !listeners.containsKey(listener)) {
            return false;
        }
        int watchId = listeners.remove(listener);
        try {
            FileWatcher.removeWatch((int)watchId);
            return true;
        }
        catch (JNotifyException e) {
            IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)"Error removing file change listener", (Throwable)e);
            return false;
        }
    }

    public static class FileModificationEvent {
        public static final int CREATED = 0;
        public static final int DELETED = 1;
        public static final int MODIFIED = 2;
        public static final int RENAMED = 3;
        public String oldName;
        public String name;
        public int type;
    }

    public static interface IFileChangeListener {
        public void fileModified(FileModificationEvent var1);
    }
}

