/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BundleUtils {
    public static final String LIB_DIRECTORY_NAME = "lib";
    private static final String BUNDLE_DIRECTORY_SUFFIX = ".ruble";
    private static final Pattern BUNDLE_NAME = Pattern.compile("^\\s*bundle\\s*(\"(?:\\\"|[^\"\\r\\n])*\"|'(?:\\\\'|[^'\\r\\n]*'))?(?:\\s*do|(?m:\\s*)\\{)");
    public static BundleUtils INSTANCE;

    private BundleUtils() {
    }

    public static String getBundleLibDirectory(File bundleDirectory) {
        return new File(bundleDirectory, LIB_DIRECTORY_NAME).getAbsolutePath();
    }

    /*
     * Loose catch block
     */
    public static String getBundleName(File bundleFile) {
        String result;
        block22: {
            result = null;
            if (bundleFile.isFile() && bundleFile.canRead()) {
                InputStreamReader fr = null;
                BufferedReader reader = null;
                try {
                    String line;
                    fr = new InputStreamReader((InputStream)new FileInputStream(bundleFile), "UTF-8");
                    reader = new BufferedReader(fr);
                    while ((line = reader.readLine()) != null) {
                        Matcher m = BUNDLE_NAME.matcher(line);
                        if (!m.find()) continue;
                        result = m.group(1);
                        if (result != null && result.length() >= 2) {
                            result = result.substring(1, result.length() - 1);
                        }
                        break;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block22;
                }
                catch (IOException iOException) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block22;
                    catch (Throwable throwable) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException3) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
                if (reader == null) break block22;
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (result == null || result.length() == 0) {
            result = BundleUtils.getDefaultBundleName(bundleFile.getAbsolutePath());
        }
        return result;
    }

    public static String getDefaultBundleName(String path) {
        File file;
        String result = null;
        if (path != null && path.length() > 0 && (result = (file = new File(path).getParentFile()).getName()).endsWith(BUNDLE_DIRECTORY_SUFFIX)) {
            result = result.substring(0, result.length() - BUNDLE_DIRECTORY_SUFFIX.length());
        }
        return result;
    }
}

