/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import com.aptana.scripting.Messages;
import com.aptana.scripting.ScriptLogger;
import com.aptana.scripting.ScriptingEngine;
import com.aptana.scripting.model.AbstractScriptRunner;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jruby.Ruby;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EvalFailedException;
import org.jruby.embed.ParseFailedException;
import org.jruby.embed.PathType;
import org.jruby.embed.ScriptingContainer;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptLoadJob
extends AbstractScriptRunner {
    private String _filename;
    private Object _returnValue;

    public ScriptLoadJob(String filename, List<String> loadPaths) {
        this("Execute JRuby File", filename, loadPaths);
    }

    public ScriptLoadJob(String name, String filename, List<String> loadPaths) {
        super(name, loadPaths);
        this._filename = filename;
    }

    public Object getReturnValue() {
        return this._returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        ScriptingContainer container = ScriptingEngine.getInstance().getInitializedScriptingContainer();
        Ruby runtime = container.getProvider().getRuntime();
        IRubyObject result = null;
        if (this._filename != null && new File(this._filename).canRead()) {
            Ruby ruby = runtime;
            synchronized (ruby) {
                this.applyLoadPaths(runtime);
                try {
                    EmbedEvalUnit unit = container.parse(PathType.ABSOLUTE, this._filename, new int[0]);
                    result = unit.run();
                }
                catch (ParseFailedException e) {
                    String message = MessageFormat.format(Messages.ScriptingEngine_Parse_Error, this._filename, e.getMessage());
                    ScriptLogger.logError(message);
                }
                catch (EvalFailedException e) {
                    StringWriter sw = new StringWriter();
                    e.getCause().printStackTrace(new PrintWriter(sw));
                    String message = MessageFormat.format(Messages.ScriptingEngine_Execution_Error, this._filename, e.getMessage(), sw.toString());
                    ScriptLogger.logError(message);
                }
                this.registerLibraries(runtime, this._filename);
                this.unapplyLoadPaths(runtime);
            }
        }
        this.setReturnValue(result);
        return Status.OK_STATUS;
    }

    protected void setReturnValue(Object value) {
        this._returnValue = value;
    }
}

