/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.editor.common.CommonDocumentProvider;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.ExtendedFastPartitioner;
import com.aptana.editor.common.IPartitionerSwitchStrategy;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.TextUtils;
import com.aptana.editor.common.text.rules.CompositePartitionScanner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public abstract class CompositeDocumentProvider
extends CommonDocumentProvider {
    private String documentContentType;
    private IPartitioningConfiguration defaultPartitioningConfiguration;
    private IPartitioningConfiguration primaryPartitioningConfiguration;
    private IPartitionerSwitchStrategy partitionerSwitchStrategy;

    protected CompositeDocumentProvider(String documentContentType, IPartitioningConfiguration defaultPartitioningConfiguration, IPartitioningConfiguration primaryPartitioningConfiguration, IPartitionerSwitchStrategy partitionerSwitchStrategy) {
        this.documentContentType = documentContentType;
        this.defaultPartitioningConfiguration = defaultPartitioningConfiguration;
        this.primaryPartitioningConfiguration = primaryPartitioningConfiguration;
        this.partitionerSwitchStrategy = partitionerSwitchStrategy;
    }

    public void connect(Object element) throws CoreException {
        super.connect(element);
        IDocument document = this.getDocument(element);
        if (document != null) {
            CompositePartitionScanner partitionScanner = new CompositePartitionScanner(this.defaultPartitioningConfiguration.createSubPartitionScanner(), this.primaryPartitioningConfiguration.createSubPartitionScanner(), this.partitionerSwitchStrategy);
            ExtendedFastPartitioner partitioner = new ExtendedFastPartitioner((IPartitionTokenScanner)partitionScanner, TextUtils.combine(new String[][]{CompositePartitionScanner.SWITCHING_CONTENT_TYPES, this.defaultPartitioningConfiguration.getContentTypes(), this.primaryPartitioningConfiguration.getContentTypes()}));
            partitionScanner.setPartitioner(partitioner);
            partitioner.connect(document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
            CommonEditorPlugin.getDefault().getDocumentScopeManager().registerConfigurations(document, new IPartitioningConfiguration[]{this.defaultPartitioningConfiguration, this.primaryPartitioningConfiguration});
        }
    }

    protected String getDefaultContentType(String filename) {
        return this.documentContentType;
    }
}

