/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Regions
implements Iterable<IRegion> {
    private static final IRegion[] EMPTY = new IRegion[0];
    private static final Comparator<IRegion> COMPARATOR = new Comparator<IRegion>(){

        @Override
        public int compare(IRegion o1, IRegion o2) {
            int diff = o1.getOffset() - o2.getOffset();
            if (diff == 0) {
                diff = o1.getLength() - o2.getLength();
            }
            return diff;
        }
    };
    private final SortedSet<IRegion> regions = new TreeSet<IRegion>(COMPARATOR);

    public Regions() {
    }

    public Regions(IRegion ... region) {
        this.append(region);
    }

    private void validate() {
        IRegion previous = null;
        for (IRegion current : this) {
            if (current.getLength() == 0) {
                throw new IllegalStateException("Zero length region found");
            }
            if (previous != null && Regions.overlap(previous, current)) {
                throw new IllegalStateException("Overlapping regions found");
            }
            previous = current;
        }
    }

    @Override
    public Iterator<IRegion> iterator() {
        return this.regions.iterator();
    }

    public boolean isEmpty() {
        return this.regions.isEmpty();
    }

    public void clear() {
        this.regions.clear();
    }

    public void append(IRegion ... region) {
        IRegion[] iRegionArray = region;
        int n = region.length;
        int n2 = 0;
        while (n2 < n) {
            IRegion r = iRegionArray[n2];
            Assert.isLegal((r.getLength() >= 0 ? 1 : 0) != 0, (String)"Negative region length");
            if (r.getLength() != 0) {
                boolean hasOverlaps;
                do {
                    hasOverlaps = false;
                    IRegion left = Regions.NavigableSetFloor(this.regions, r);
                    IRegion right = Regions.NavigableSetCeiling(this.regions, r);
                    if (Regions.overlap(left, r)) {
                        this.regions.remove(left);
                        r = Regions.merge(left, r);
                        hasOverlaps = true;
                    }
                    if (!Regions.overlap(r, right)) continue;
                    this.regions.remove(right);
                    r = Regions.merge(r, right);
                    hasOverlaps = true;
                } while (hasOverlaps);
                this.regions.add(r);
            }
            ++n2;
        }
        this.validate();
    }

    public void remove(IRegion ... region) {
        IRegion[] iRegionArray = region;
        int n = region.length;
        int n2 = 0;
        while (n2 < n) {
            IRegion r = iRegionArray[n2];
            Assert.isLegal((r.getLength() >= 0 ? 1 : 0) != 0, (String)"Negative region length");
            Region from = new Region(r.getOffset(), Integer.MAX_VALUE);
            IRegion floor = (IRegion)Regions.NavigableSetFloor(this.regions, from);
            ArrayList<IRegion> list = new ArrayList<IRegion>(Regions.NavigableSetTailSet(this.regions, floor != null ? floor : from, true));
            for (IRegion current : list) {
                if (!Regions.overlap(current, r)) continue;
                this.regions.remove(current);
                IRegion[] parts = Regions.substruct(current, r);
                if (parts.length <= 0) break;
                this.regions.addAll(Arrays.asList(parts));
            }
            ++n2;
        }
        this.validate();
    }

    public IRegion overlap(IRegion region) {
        Assert.isLegal((region.getLength() >= 0 ? 1 : 0) != 0, (String)"Negative region length");
        Region from = new Region(region.getOffset(), Integer.MAX_VALUE);
        IRegion floor = (IRegion)Regions.NavigableSetFloor(this.regions, from);
        for (IRegion current : Regions.NavigableSetTailSet(this.regions, floor != null ? floor : from, true)) {
            IRegion overlap = Regions.intersection(current, region);
            if (overlap == null) continue;
            return overlap;
        }
        return null;
    }

    public String toString() {
        return "Regions " + this.regions;
    }

    private static boolean overlap(IRegion o1, IRegion o2) {
        int offset2;
        if (o1 == null || o2 == null) {
            return false;
        }
        int offset1 = o1.getOffset();
        if (offset1 == (offset2 = o2.getOffset())) {
            return true;
        }
        if (offset1 < offset2) {
            return offset1 + o1.getLength() >= offset2;
        }
        return offset2 + o2.getLength() >= offset1;
    }

    private static IRegion merge(IRegion o1, IRegion o2) {
        int offset1 = o1.getOffset();
        int offset2 = o2.getOffset();
        int offset = Math.min(offset1, offset2);
        int length = Math.max(offset1 + o1.getLength(), offset2 + o2.getLength()) - offset;
        if (offset == offset1 && length == o1.getLength()) {
            return o1;
        }
        if (offset == offset2 && length == o2.getLength()) {
            return o2;
        }
        return new Region(offset, length);
    }

    private static IRegion[] substruct(IRegion target, IRegion part) {
        Region right;
        int leftLength = part.getOffset() - target.getOffset();
        int rightLength = target.getLength() - part.getLength() - leftLength;
        Region left = leftLength > 0 ? new Region(target.getOffset(), leftLength) : null;
        Region region = right = rightLength > 0 ? new Region(part.getOffset() + part.getLength(), rightLength) : null;
        if (left != null && right != null) {
            return new IRegion[]{left, right};
        }
        if (left != null) {
            return new IRegion[]{left};
        }
        if (right != null) {
            return new IRegion[]{right};
        }
        return EMPTY;
    }

    private static IRegion intersection(IRegion o1, IRegion o2) {
        int offset1 = o1.getOffset();
        int offset2 = o2.getOffset();
        int offset = Math.max(offset1, offset2);
        int length = Math.min(offset1 + o1.getLength(), offset2 + o2.getLength()) - offset;
        if (length <= 0) {
            return null;
        }
        if (offset == offset1 && length == o1.getLength()) {
            return o1;
        }
        if (offset == offset2 && length == o2.getLength()) {
            return o2;
        }
        return new Region(offset, length);
    }

    private static <T> T NavigableSetFloor(SortedSet<T> sortedSet, T e) {
        if (sortedSet.contains(e)) {
            return e;
        }
        SortedSet<T> headSet = sortedSet.headSet(e);
        if (headSet.isEmpty()) {
            return null;
        }
        return headSet.last();
    }

    private static <T> T NavigableSetCeiling(SortedSet<T> sortedSet, T e) {
        SortedSet<T> tailSet = sortedSet.tailSet(e);
        if (tailSet.isEmpty()) {
            return null;
        }
        return tailSet.first();
    }

    private static <T> SortedSet<T> NavigableSetTailSet(SortedSet<T> sortedSet, T fromElement, boolean inclusive) {
        Assert.isTrue((boolean)inclusive);
        return sortedSet.tailSet(fromElement);
    }
}

