/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.contentassist;

import com.aptana.core.CorePlugin;
import com.aptana.core.IUserAgent;
import com.aptana.core.IUserAgentManager;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.ResourceUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.ui.epl.UIEplPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAgentManager
implements IUserAgentManager {
    private static UserAgentManager INSTANCE;
    private static final String USER_AGENT_DELIMITER = ",";
    private static final String ENTRY_DELIMITER = ";";
    private static final String NAME_VALUE_SEPARATOR = ":";
    private static Map<String, String[]> ACTIVE_USER_AGENTS_BY_NATURE_ID;
    private ImageRegistry imageRegistry;

    public static synchronized UserAgentManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UserAgentManager();
            INSTANCE.loadPreference();
        }
        return INSTANCE;
    }

    private UserAgentManager() {
    }

    public String[] getActiveUserAgentIDs(IProject project) {
        String agents;
        if (project == null) {
            return ArrayUtil.NO_STRINGS;
        }
        String[] natureIDs = UserAgentManager.getProjectNatures(project);
        ProjectScope scope = new ProjectScope(project);
        IEclipsePreferences node = scope.getNode("com.aptana.editor.common");
        if (node != null && (agents = node.get("selectUserAgents", null)) != null) {
            Map<String, String[]> userAgents = this.extractUserAgents(agents);
            return this.getActiveUserAgentIDs(userAgents, natureIDs);
        }
        return this.getActiveUserAgentIDs(natureIDs);
    }

    private static String[] getProjectNatures(IProject project) {
        String[] natureIDs = ArrayUtil.NO_STRINGS;
        try {
            natureIDs = ResourceUtil.getAptanaNatures((IProjectDescription)project.getDescription());
        }
        catch (CoreException e) {
            IdeLog.logWarning((Plugin)CommonEditorPlugin.getDefault(), (String)("Problem detecting the project's nature IDs for " + project.getName()), (Throwable)e, (String)"com.aptana.editor.common/debug/content_assist");
        }
        return natureIDs;
    }

    private String[] getActiveUserAgentIDs(String ... natureIDs) {
        return this.getActiveUserAgentIDs(ACTIVE_USER_AGENTS_BY_NATURE_ID, natureIDs);
    }

    private String[] getActiveUserAgentIDs(Map<String, String[]> userAgents, String ... natureIDs) {
        if (!ArrayUtil.isEmpty((Object[])natureIDs)) {
            String[] stringArray = natureIDs;
            int n = natureIDs.length;
            int n2 = 0;
            while (n2 < n) {
                String natureID = stringArray[n2];
                if (userAgents.containsKey(natureID)) {
                    return userAgents.get(natureID);
                }
                ++n2;
            }
        }
        IdeLog.logWarning((Plugin)CommonEditorPlugin.getDefault(), (String)"UserAgentManager - Got empty natures list", (String)"com.aptana.editor.common/debug/content_assist");
        return ArrayUtil.NO_STRINGS;
    }

    public IUserAgent[] getActiveUserAgents(IProject project) {
        return this.getUserAgentsByID(this.getActiveUserAgentIDs(project));
    }

    public IUserAgent[] getActiveUserAgents(String ... natureIDs) {
        return this.getUserAgentsByID(this.getActiveUserAgentIDs(natureIDs));
    }

    public IUserAgent[] getAllUserAgents() {
        return CorePlugin.getDefault().getUserAgentManager().getAllUserAgents();
    }

    public boolean addUserAgent(IUserAgent agent) {
        return CorePlugin.getDefault().getUserAgentManager().addUserAgent(agent);
    }

    public String[] getDefaultUserAgentIDs(String natureID) {
        IUserAgent[] agents = this.getDefaultUserAgents(natureID);
        String[] result = new String[agents.length];
        int i = 0;
        while (i < agents.length) {
            result[i] = agents[i].getID();
            ++i;
        }
        return result;
    }

    public IUserAgent[] getDefaultUserAgents(String natureID) {
        return CorePlugin.getDefault().getUserAgentManager().getDefaultUserAgents(natureID);
    }

    public Image getDisabledIcon(IUserAgent agent) {
        return this.getImage(agent, agent.getDisabledIconPath());
    }

    public Image getEnabledIcon(IUserAgent agent) {
        return this.getImage(agent, agent.getEnabledIconPath());
    }

    private Image getImage(IUserAgent agent, String iconPath) {
        Image result = null;
        if (iconPath != null) {
            String key;
            if (this.imageRegistry == null) {
                this.imageRegistry = new ImageRegistry();
            }
            if ((result = this.imageRegistry.get(key = String.valueOf(agent.getID()) + '_' + iconPath)) == null) {
                ImageDescriptor desc = CommonEditorPlugin.imageDescriptorFromPlugin((String)agent.getContributor(), (String)iconPath);
                this.imageRegistry.put(key, desc);
            }
            result = this.imageRegistry.get(key);
        }
        return result;
    }

    public Image[] getUserAgentImages(IProject project, String ... userAgents) {
        Object[] activeUserAgents = this.getActiveUserAgents(project);
        Set<Object> enabledAgents = userAgents == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(userAgents));
        Image[] result = new Image[activeUserAgents.length];
        Arrays.sort(activeUserAgents);
        int i = 0;
        while (i < activeUserAgents.length) {
            Object userAgent = activeUserAgents[i];
            if (userAgent != null) {
                boolean isEnabled = enabledAgents.contains(userAgent.getID());
                result[i] = isEnabled ? this.getEnabledIcon((IUserAgent)userAgent) : this.getDisabledIcon((IUserAgent)userAgent);
            }
            ++i;
        }
        return result;
    }

    private IUserAgent[] getUserAgentsByID(String ... ids) {
        ArrayList<IUserAgent> result = new ArrayList<IUserAgent>();
        if (ids != null && ids.length > 0) {
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                IUserAgent userAgent = this.getUserAgentById(id);
                if (userAgent != null) {
                    result.add(userAgent);
                }
                ++n2;
            }
        }
        return result.toArray(new IUserAgent[result.size()]);
    }

    public IUserAgent getUserAgentById(String id) {
        return CorePlugin.getDefault().getUserAgentManager().getUserAgentById(id);
    }

    void loadPreference() {
        Map<String, String[]> result;
        ChainedPreferenceStore chainedStore = new ChainedPreferenceStore(new IPreferenceStore[]{CommonEditorPlugin.getDefault().getPreferenceStore(), UIEplPlugin.getDefault().getPreferenceStore()});
        String preferenceValue = chainedStore.getString("selectUserAgents");
        if (!StringUtil.isEmpty((String)preferenceValue)) {
            result = this.extractUserAgents(preferenceValue);
        } else {
            result = new HashMap<String, String[]>();
            for (String natureID : ResourceUtil.getAptanaNaturesMap().values()) {
                result.put(natureID, this.getDefaultUserAgentIDs(natureID));
            }
        }
        ACTIVE_USER_AGENTS_BY_NATURE_ID = result;
    }

    private Map<String, String[]> extractUserAgents(String preferenceValue) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        if (preferenceValue.contains(NAME_VALUE_SEPARATOR)) {
            String[] entries;
            String[] stringArray = entries = preferenceValue.split(ENTRY_DELIMITER);
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                String[] nameValue = entry.split(NAME_VALUE_SEPARATOR);
                String natureID = nameValue[0];
                if (nameValue.length > 1) {
                    String userAgentIDsString = nameValue[1];
                    String[] userAgentIDs = userAgentIDsString.split(USER_AGENT_DELIMITER);
                    result.put(natureID, userAgentIDs);
                } else {
                    result.put(natureID, ArrayUtil.NO_STRINGS);
                }
                ++n2;
            }
        } else {
            String[] userAgentIDs = preferenceValue.split(USER_AGENT_DELIMITER);
            for (String natureID : ResourceUtil.getAptanaNaturesMap().values()) {
                result.put(natureID, userAgentIDs);
            }
        }
        return result;
    }

    public void savePreference() {
        this.savePreference(null, ACTIVE_USER_AGENTS_BY_NATURE_ID);
    }

    public void savePreference(IProject project, Map<String, String[]> natureIdToUserAgents) {
        IEclipsePreferences preferences = null;
        preferences = project != null ? new ProjectScope(project).getNode("com.aptana.editor.common") : InstanceScope.INSTANCE.getNode("com.aptana.editor.common");
        ArrayList<String> natureEntries = new ArrayList<String>();
        for (Map.Entry<String, String[]> entry : natureIdToUserAgents.entrySet()) {
            String natureID = entry.getKey();
            String userAgentIDs = StringUtil.join((String)USER_AGENT_DELIMITER, (String[])entry.getValue());
            natureEntries.add(String.valueOf(natureID) + NAME_VALUE_SEPARATOR + userAgentIDs);
        }
        String value = StringUtil.join((String)ENTRY_DELIMITER, natureEntries);
        if (preferences != null) {
            preferences.put("selectUserAgents", value);
            try {
                preferences.flush();
            }
            catch (BackingStoreException e) {
                IdeLog.logWarning((Plugin)CommonEditorPlugin.getDefault(), (String)"Error saving the user-agent preferences.", (Throwable)e);
            }
        } else {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)"Error saving the user-agent preferences. Preferences node was null");
        }
    }

    public void clearPreferences(IProject project) {
        if (project != null) {
            IEclipsePreferences preferences = new ProjectScope(project).getNode("com.aptana.editor.common");
            preferences.remove("selectUserAgents");
            try {
                preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
    }

    public void setActiveUserAgents(String natureID, String[] userAgentIDs) {
        if (!StringUtil.isEmpty((String)natureID)) {
            String[] value = userAgentIDs != null ? userAgentIDs : ArrayUtil.NO_STRINGS;
            ACTIVE_USER_AGENTS_BY_NATURE_ID.put(natureID, value);
        }
    }
}

