/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.parsing;

import beaver.Scanner;
import beaver.Symbol;
import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFlexTokenScanner
implements ITokenScanner {
    protected final Queue<Symbol> fLookAheadQueue = new LinkedList<Symbol>();
    protected int fOffset;
    protected Symbol fLastSymbol = new Symbol(-1, -1, -1);
    protected int fTokenOffset;
    protected int fTokenLen;
    protected boolean fLastWasWhitespace = false;
    protected final Scanner fScanner;

    protected AbstractFlexTokenScanner(Scanner scanner) {
        this.fScanner = scanner;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.fLookAheadQueue.clear();
        this.fLastWasWhitespace = false;
        Assert.isLegal((document != null ? 1 : 0) != 0);
        int documentLength = document.getLength();
        Assert.isLegal((offset > -1 ? 1 : 0) != 0);
        Assert.isLegal((length > -1 ? 1 : 0) != 0);
        Assert.isLegal((offset + length <= documentLength ? 1 : 0) != 0);
        this.fOffset = offset;
        try {
            this.setSource(document.get(offset, length));
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    protected abstract void setSource(String var1);

    public IToken nextToken() {
        try {
            Symbol symbol;
            if (this.fLastWasWhitespace) {
                symbol = this.fLastSymbol;
                this.fLastWasWhitespace = false;
            } else {
                symbol = this.fLookAheadQueue.poll();
                if (symbol == null) {
                    symbol = this.fScanner.nextToken();
                }
                if (symbol.getStart() > this.fLastSymbol.getEnd() + 1) {
                    this.fTokenOffset = this.fLastSymbol.getEnd() + 1;
                    this.fTokenLen = symbol.getStart() - this.fLastSymbol.getEnd() - 1;
                    this.fLastSymbol = symbol;
                    this.fLastWasWhitespace = true;
                    return this.getWhitespace();
                }
                this.fLastWasWhitespace = false;
            }
            this.fTokenOffset = symbol.getStart();
            this.fTokenLen = symbol.getEnd() - symbol.getStart() + 1;
            IToken ret = this.mapToken(symbol);
            this.fLastSymbol = symbol;
            return ret;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            return this.getUndefinedToken();
        }
    }

    protected IToken getWhitespace() {
        return Token.WHITESPACE;
    }

    protected abstract IToken getUndefinedToken();

    protected abstract IToken mapToken(Symbol var1) throws IOException, Scanner.Exception;

    protected Symbol lookAhead(Queue<Symbol> tempQueue) throws IOException, Scanner.Exception {
        if (tempQueue == null) {
            Symbol nextToken = this.fScanner.nextToken();
            this.fLookAheadQueue.add(nextToken);
            return nextToken;
        }
        Symbol nextToken = tempQueue.poll();
        if (nextToken != null) {
            return nextToken;
        }
        nextToken = this.fScanner.nextToken();
        this.fLookAheadQueue.add(nextToken);
        return nextToken;
    }

    public int getTokenOffset() {
        return this.fOffset + this.fTokenOffset;
    }

    public int getTokenLength() {
        return this.fTokenLen;
    }
}

