/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.parsing;

import beaver.Scanner;
import beaver.Symbol;
import com.aptana.editor.common.parsing.CompositeTokenScanner;
import java.io.IOException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;

public class CompositeParserScanner
extends Scanner {
    private CompositeTokenScanner fTokenScanner;
    private IDocument fDocument;

    public CompositeParserScanner(CompositeTokenScanner tokenScanner) {
        this.fTokenScanner = tokenScanner;
    }

    public CompositeTokenScanner getTokenScanner() {
        return this.fTokenScanner;
    }

    public IDocument getSource() {
        return this.fDocument;
    }

    public void setSource(String text) {
        this.setSource((IDocument)new Document(text));
    }

    public void setSource(IDocument document) {
        this.fDocument = document;
        this.fTokenScanner.setRange(this.fDocument, 0, this.fDocument.getLength());
    }

    public Symbol nextToken() throws IOException, Scanner.Exception {
        IToken token = this.fTokenScanner.nextToken();
        while (this.isIgnored(token)) {
            token = this.fTokenScanner.nextToken();
        }
        int offset = this.fTokenScanner.getTokenOffset();
        int length = this.fTokenScanner.getTokenLength();
        if (token.isEOF()) {
            return this.createSymbol(offset, offset, "", token);
        }
        try {
            String text = this.fDocument.get(offset, length);
            return this.createSymbol(offset, offset + length - 1, text, token);
        }
        catch (BadLocationException e) {
            throw new Scanner.Exception(e.getLocalizedMessage());
        }
    }

    protected Symbol createSymbol(int start, int end, String text, IToken token) {
        return new Symbol(0, start, end, (Object)text);
    }

    protected boolean isIgnored(IToken token) {
        return token.isWhitespace();
    }
}

