/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.preferences;

import com.aptana.core.CoreStrings;
import com.aptana.core.IUserAgent;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ResourceUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.contentassist.UserAgentFilterType;
import com.aptana.editor.common.contentassist.UserAgentManager;
import com.aptana.editor.common.preferences.Messages;
import com.aptana.ui.preferences.AptanaPreferencePage;
import com.aptana.ui.preferences.PropertyAndPreferenceFieldEditorPage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentAssistPreferencePage
extends PropertyAndPreferenceFieldEditorPage {
    private static final String PREFERENCE_PAGE_ID = "com.aptana.editor.common.contentAssistPreferencePage";
    private static final String PROPERTY_PAGE_ID = "com.aptana.editor.common.contentAssistPropertyPage";
    private Combo natureCombo;
    private String activeNatureID;
    private CheckboxTableViewer categoryViewer;
    private SortedMap<String, String> natureIDsByName;
    private Map<String, IUserAgent[]> userAgentsByNatureID;

    public ContentAssistPreferencePage() {
        super(1);
        this.setPreferenceStore(CommonEditorPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.ContentAssistPreferencePage_ContentAssistPreferencePageDescription);
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        Composite uaGroup = AptanaPreferencePage.createGroup((Composite)parent, (String)Messages.ContentAssistPreferencePage_UserAgentGroupLabel);
        this.createUserAgentGroupContent(uaGroup);
        if (!this.isProjectPreferencePage()) {
            Composite pGroup = AptanaPreferencePage.createGroup((Composite)parent, (String)Messages.ContentAssistPreferencePage_ProposalsGroupLabel);
            this.createProposalGroupContent(pGroup);
        }
    }

    protected void createFilterSelector(Composite parent) {
        ComboFieldEditor fieldEditor = new ComboFieldEditor("CONTENT_ASSIST_USER_AGENT_FILTER_TYPE", Messages.ContentAssistPreferencePage_ProposalFilterTypeLabel, (String[][])new String[][]{{Messages.ContentAssistPreferencePage_NoFilterLabel, UserAgentFilterType.NO_FILTER.getText()}, {Messages.ContentAssistPreferencePage_OneOrMoreFilterLabel, UserAgentFilterType.ONE_OR_MORE.getText()}, {Messages.ContentAssistPreferencePage_AllFilterLabel, UserAgentFilterType.ALL.getText()}}, parent);
        this.addField((FieldEditor)fieldEditor);
        fieldEditor.setEnabled(!this.isProjectPreferencePage(), parent);
    }

    protected void createNatureSelector(Composite parent) {
        SortedMap<String, String> natureMap = this.getNatureMap();
        Label label = new Label(parent, 16384);
        label.setFont(parent.getFont());
        label.setText(Messages.ContentAssistPreferencePage_NatureComboLabel);
        this.natureCombo = new Combo(parent, 8);
        this.natureCombo.setFont(parent.getFont());
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        this.natureCombo.setLayoutData((Object)gd);
        boolean isProjectPreference = this.isProjectPreferencePage();
        Object primaryProjectNature = null;
        if (isProjectPreference) {
            try {
                Object[] aptanaNatures = ResourceUtil.getAptanaNatures((IProjectDescription)this.getProject().getDescription());
                if (!ArrayUtil.isEmpty((Object[])aptanaNatures)) {
                    primaryProjectNature = aptanaNatures[0];
                }
            }
            catch (CoreException aptanaNatures) {
                // empty catch block
            }
        }
        for (Map.Entry<String, String> entry : natureMap.entrySet()) {
            if (primaryProjectNature != null) {
                if (!((String)primaryProjectNature).equals(entry.getValue())) continue;
                this.natureCombo.add(entry.getKey());
                break;
            }
            this.natureCombo.add(entry.getKey());
        }
        this.natureCombo.select(0);
        this.activeNatureID = (String)natureMap.get(this.natureCombo.getText());
        this.natureCombo.setEnabled(!isProjectPreference);
        if (!isProjectPreference) {
            this.natureCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    ContentAssistPreferencePage.this.userAgentsByNatureID.put(ContentAssistPreferencePage.this.activeNatureID, ContentAssistPreferencePage.this.getSelectedUserAgents());
                    ContentAssistPreferencePage.this.activeNatureID = (String)ContentAssistPreferencePage.this.getNatureMap().get(ContentAssistPreferencePage.this.natureCombo.getText());
                    ContentAssistPreferencePage.this.updateUserAgentSelection();
                }
            });
        }
    }

    protected void createProposalGroupContent(Composite parent) {
        this.addField((FieldEditor)new BooleanFieldEditor("CONTENT_ASSIST_AUTO_INSERT", Messages.EditorsPreferencePage_Content_Assist_Auto_Insert, parent));
        this.addField((FieldEditor)new ComboFieldEditor("CONTENT_ASSIST_DELAY", Messages.EditorsPreferencePage_Content_Assist_Auto_Display, (String[][])new String[][]{{Messages.EditorsPreferencePage_Instant, Integer.toString(0)}, {Messages.EditorsPreferencePage_DefaultDelay, Integer.toString(200)}, {Messages.EditorsPreferencePage_Content_Assist_Short_Delay, Integer.toString(1000)}, {CoreStrings.OFF, String.valueOf(-1)}}, parent));
        this.addField((FieldEditor)new ComboFieldEditor("com.aptana.editor.common.contentAssistHover", Messages.EditorsPreferencePage_Content_Assist_Hover, (String[][])new String[][]{{CoreStrings.ON, Boolean.toString(true)}, {CoreStrings.OFF, Boolean.toString(false)}}, parent));
    }

    protected void createUserAgentButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(4).create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 0).grab(true, false).create());
        Button enableAll = new Button(composite, 8);
        enableAll.setFont(parent.getFont());
        enableAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContentAssistPreferencePage.this.categoryViewer.setCheckedElements((Object[])UserAgentManager.getInstance().getAllUserAgents());
            }
        });
        enableAll.setText(Messages.UserAgentPreferencePage_Select_All);
        this.setButtonLayoutData(enableAll);
        Button disableAll = new Button(composite, 8);
        disableAll.setFont(parent.getFont());
        disableAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContentAssistPreferencePage.this.categoryViewer.setCheckedElements(new Object[0]);
            }
        });
        disableAll.setText(Messages.UserAgentPreferencePage_Select_None);
        this.setButtonLayoutData(disableAll);
    }

    protected void createUserAgentGroupContent(Composite parent) {
        this.createNatureSelector(parent);
        this.createUserAgentTable(parent);
        this.createUserAgentButtons(parent);
        this.createFilterSelector(parent);
        UserAgentManager manager = UserAgentManager.getInstance();
        this.userAgentsByNatureID = new HashMap<String, IUserAgent[]>();
        if (this.isProjectPreferencePage()) {
            try {
                Object[] aptanaNatures;
                IProject project = this.getProject();
                if (project.isAccessible() && !ArrayUtil.isEmpty((Object[])(aptanaNatures = ResourceUtil.getAptanaNatures((IProjectDescription)project.getDescription())))) {
                    this.userAgentsByNatureID.put((String)aptanaNatures[0], manager.getActiveUserAgents(project));
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            }
        } else {
            for (String natureID : ResourceUtil.getAptanaNaturesMap().values()) {
                this.userAgentsByNatureID.put(natureID, manager.getActiveUserAgents(natureID));
            }
        }
        this.updateUserAgentSelection();
    }

    protected void createUserAgentTable(Composite parent) {
        Label label = new Label(parent, 64);
        label.setText(Messages.UserAgentPreferencePage_Select_User_Agents);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 0).grab(true, true).create());
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 0).hint(400, 120).grab(true, true).create());
        Table table = new Table(composite, 2084);
        table.setFont(parent.getFont());
        this.categoryViewer = new CheckboxTableViewer(table);
        this.categoryViewer.getControl().setFont(parent.getFont());
        this.categoryViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.categoryViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        CategoryLabelProvider categoryLabelProvider = new CategoryLabelProvider(true);
        this.categoryViewer.setLabelProvider((IBaseLabelProvider)categoryLabelProvider);
        this.categoryViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IUserAgent && e2 instanceof IUserAgent) {
                    IUserAgent ua1 = (IUserAgent)e1;
                    IUserAgent ua2 = (IUserAgent)e2;
                    String uaName1 = StringUtil.getStringValue((Object)ua1.getName());
                    String uaName2 = StringUtil.getStringValue((Object)ua2.getName());
                    return uaName1.compareToIgnoreCase(uaName2);
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.categoryViewer.setInput((Object)UserAgentManager.getInstance().getAllUserAgents());
    }

    protected SortedMap<String, String> getNatureMap() {
        if (this.natureIDsByName == null) {
            this.natureIDsByName = new TreeMap<String, String>(ResourceUtil.getAptanaNaturesMap());
        }
        return this.natureIDsByName;
    }

    protected IUserAgent[] getSelectedUserAgents() {
        Object[] elements = this.categoryViewer.getCheckedElements();
        IUserAgent[] userAgents = new IUserAgent[elements.length];
        int i = 0;
        while (i < elements.length) {
            userAgents[i] = (IUserAgent)elements[i];
            ++i;
        }
        return userAgents;
    }

    protected void performDefaults() {
        this.userAgentsByNatureID = new HashMap<String, IUserAgent[]>();
        UserAgentManager manager = UserAgentManager.getInstance();
        for (String natureID : ResourceUtil.getAptanaNaturesMap().values()) {
            this.userAgentsByNatureID.put(natureID, manager.getDefaultUserAgents(natureID));
        }
        this.updateUserAgentSelection();
        super.performDefaults();
    }

    public boolean performOk() {
        this.userAgentsByNatureID.put(this.activeNatureID, this.getSelectedUserAgents());
        UserAgentManager manager = UserAgentManager.getInstance();
        IProject project = this.getProject();
        if (project == null) {
            for (Map.Entry<String, IUserAgent[]> entry : this.userAgentsByNatureID.entrySet()) {
                String natureID = entry.getKey();
                IUserAgent[] userAgents = entry.getValue();
                String[] userAgentIDs = new String[userAgents.length];
                int i = 0;
                while (i < userAgents.length) {
                    userAgentIDs[i] = userAgents[i].getID();
                    ++i;
                }
                manager.setActiveUserAgents(natureID, userAgentIDs);
                manager.savePreference();
            }
        } else if (this.useProjectSettings()) {
            if (this.activeNatureID != null && !CollectionsUtil.isEmpty(this.userAgentsByNatureID)) {
                IUserAgent[] userAgents = this.userAgentsByNatureID.get(this.activeNatureID);
                String[] userAgentIDs = new String[userAgents.length];
                int i = 0;
                while (i < userAgents.length) {
                    userAgentIDs[i] = userAgents[i].getID();
                    ++i;
                }
                manager.savePreference(project, CollectionsUtil.newTypedMap(String.class, String[].class, (Object[])new Object[]{this.activeNatureID, userAgentIDs}));
            } else {
                IdeLog.logWarning((Plugin)CommonEditorPlugin.getDefault(), (String)"ContentAssist preferences - Did not save. Expected to have a valid Aptana nature");
            }
        } else {
            manager.clearPreferences(project);
        }
        return super.performOk();
    }

    private void updateUserAgentSelection() {
        String name = this.natureCombo.getText();
        String natureID = (String)this.natureIDsByName.get(name);
        Object[] userAgents = this.userAgentsByNatureID.get(natureID);
        this.categoryViewer.setCheckedElements(userAgents != null ? userAgents : UserAgentManager.NO_USER_AGENTS);
    }

    protected boolean hasProjectSpecificOptions(IProject project) {
        ProjectScope scope = new ProjectScope(project);
        IEclipsePreferences node = scope.getNode("com.aptana.editor.common");
        if (node != null) {
            return node.get("selectUserAgents", null) != null;
        }
        return false;
    }

    protected String getPreferencePageId() {
        return PREFERENCE_PAGE_ID;
    }

    protected Set<String> getNatureIDs() {
        return new HashSet<String>(ResourceUtil.getAptanaNaturesMap().values());
    }

    protected String getPropertyPageId() {
        return PROPERTY_PAGE_ID;
    }

    private class CategoryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public CategoryLabelProvider(boolean decorate) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            IUserAgent agent = (IUserAgent)element;
            return UserAgentManager.getInstance().getEnabledIcon(agent);
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((IUserAgent)element).getName();
        }
    }
}

