/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.preferences;

import com.aptana.core.util.ObjectUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.common.preferences.Messages;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.ui.preferences.AptanaPreferencePage;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class EditorsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private String GENERAL_TEXT_EDITOR_PREF_ID = "org.eclipse.ui.preferencePages.GeneralTextEditor";
    private ComboFieldEditor editorsListCombo;

    public EditorsPreferencePage() {
        super(1);
        this.setPreferenceStore(CommonEditorPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.EditorsPreferencePage_PreferenceDescription);
    }

    public void createFieldEditors() {
        Composite appearanceComposite = this.getFieldEditorParent();
        Composite group = AptanaPreferencePage.createGroup((Composite)appearanceComposite, (String)Messages.EditorsPreferencePage_Typing);
        this.addField((FieldEditor)new BooleanFieldEditor("com.aptana.editor.common.enableCharacterPairColoring", Messages.EditorsPreferencePage_Colorize_Matching_Character_Pairs, group));
        this.addField((FieldEditor)new BooleanFieldEditor("com.aptana.editor.common.editorPeerCharacterClose", Messages.EditorsPreferencePage_Close_Matching_Character_Pairs, group));
        this.addField((FieldEditor)new BooleanFieldEditor("com.aptana.editor.common.editorWrapSelection", Messages.EditorsPreferencePage_Wrap_Selection, group));
        this.addField((FieldEditor)new BooleanFieldEditor("com.aptana.editor.common.camelCaseNavigation", Messages.EditorsPreferencePage_camelCaseSelection, group));
        group = AptanaPreferencePage.createGroup((Composite)appearanceComposite, (String)Messages.EditorsPreferencePage_saveActionsGroup);
        this.addField((FieldEditor)new BooleanFieldEditor("com.aptana.editor.common.removeTrailingWhitespace", Messages.EditorsPreferencePage_saveActionRemoveWhitespaceCharacters, group));
        group = AptanaPreferencePage.createGroup((Composite)appearanceComposite, (String)Messages.EditorsPreferencePage_SyntaxColoring);
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        IntegerFieldEditor colEditor = new IntegerFieldEditor("studio.maxColoredColumns", StringUtil.makeFormLabel((String)Messages.EditorsPreferencePage_MaxColumnsLabel), group);
        colEditor.setValidRange(-1, Integer.MAX_VALUE);
        this.addField((FieldEditor)colEditor);
        this.addField((FieldEditor)new BooleanFieldEditor("com.aptana.editor.common.enableWordWrap", Messages.EditorsPreferencePage_Enable_WordWrap, appearanceComposite));
        this.createOpenWithEditor(appearanceComposite);
        this.createTextEditorLink(appearanceComposite);
    }

    private void createOpenWithEditor(Composite appearanceComposite) {
        Map<String, String> editorsMap = EditorUtil.getAllRegistryEditors();
        String[][] entryNamesAndValues = new String[editorsMap.size()][2];
        Set<Map.Entry<String, String>> entries = editorsMap.entrySet();
        Iterator<Map.Entry<String, String>> entriesIterator = entries.iterator();
        int i = 0;
        while (entriesIterator.hasNext()) {
            Map.Entry<String, String> mapping = entriesIterator.next();
            entryNamesAndValues[i][0] = mapping.getValue();
            entryNamesAndValues[i][1] = mapping.getKey();
            ++i;
        }
        this.editorsListCombo = new ComboFieldEditor("com.aptana.editor.common.openWithEditor", Messages.EditorsPreferencePage_OpenWith_Editor, entryNamesAndValues, appearanceComposite);
        this.addField((FieldEditor)this.editorsListCombo);
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object oldValue;
        Object newValue;
        super.propertyChange(event);
        if (event.getSource() == this.editorsListCombo && ObjectUtil.areNotEqual((Object)(newValue = event.getNewValue()), (Object)(oldValue = event.getOldValue()))) {
            CommonUtil.handleOpenWithEditorPref();
        }
    }

    public void init(IWorkbench workbench) {
    }

    private void createTextEditorLink(Composite appearanceComposite) {
        Link link = new Link(appearanceComposite, 0);
        link.setText(Messages.EditorsPreferencePage_GeneralTextEditorPrefLink);
        link.setLayoutData((Object)new GridData(16384, 0, false, false, 2, 1));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((IWorkbenchPreferenceContainer)EditorsPreferencePage.this.getContainer()).openPage(EditorsPreferencePage.this.GENERAL_TEXT_EDITOR_PREF_ID, null);
            }
        });
    }
}

