/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.text.reconciler.IFoldingComputer;
import com.aptana.editor.common.text.reconciler.Messages;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.ast.ParseRootNode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFoldingComputer
implements IFoldingComputer {
    private IDocument fDocument;
    private AbstractThemeableEditor fEditor;
    private ArrayList<Integer> fLines;
    private boolean initialReconcile;

    protected AbstractFoldingComputer(AbstractThemeableEditor editor, IDocument document) {
        this.fEditor = editor;
        this.fDocument = document;
    }

    protected IDocument getDocument() {
        return this.fDocument;
    }

    protected AbstractThemeableEditor getEditor() {
        return this.fEditor;
    }

    @Override
    public Map<ProjectionAnnotation, Position> emitFoldingRegions(boolean initialReconcile, IProgressMonitor monitor, IParseRootNode parseNode) throws BadLocationException {
        this.initialReconcile = initialReconcile;
        this.fLines = new ArrayList();
        int lineCount = this.getDocument().getNumberOfLines();
        if (lineCount <= 1) {
            return Collections.emptyMap();
        }
        SubMonitor sub = null;
        try {
            IParseRootNode prn;
            IParseNode[] comments;
            if (parseNode == null) {
                Map<ProjectionAnnotation, Position> map = Collections.emptyMap();
                return map;
            }
            int length = parseNode.getChildCount();
            if (parseNode instanceof IParseRootNode && (comments = (prn = parseNode).getCommentNodes()) != null && comments.length > 0) {
                length += comments.length;
            }
            sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CommonReconcilingStrategy_FoldingTaskName, (int)length);
            SubMonitor subMonitor = sub.newChild(length);
            Map<ProjectionAnnotation, Position> positions = this.getPositions((IProgressMonitor)subMonitor, (IParseNode)parseNode);
            if (subMonitor.isCanceled()) {
                monitor.setCanceled(true);
            }
            Map<ProjectionAnnotation, Position> map = positions;
            return map;
        }
        finally {
            this.fLines = null;
            if (sub != null) {
                sub.done();
            }
        }
    }

    protected IParseNode[] getChildren(IParseNode parseNode) {
        IParseRootNode prn;
        IParseNode[] comments;
        IParseNode[] children = parseNode.getChildren();
        if (parseNode instanceof IParseRootNode && (comments = (prn = (IParseRootNode)parseNode).getCommentNodes()) != null && comments.length > 0) {
            IParseNode[] combined = new IParseNode[children.length + comments.length];
            System.arraycopy(children, 0, combined, 0, children.length);
            System.arraycopy(comments, 0, combined, children.length, comments.length);
            children = combined;
        }
        return children;
    }

    protected Map<ProjectionAnnotation, Position> getPositions(IProgressMonitor monitor, IParseNode parseNode) {
        HashMap<ProjectionAnnotation, Position> newPositions = new HashMap<ProjectionAnnotation, Position>();
        IParseNode[] children = this.getChildren(parseNode);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 * children.length));
        IParseNode[] iParseNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode child = iParseNodeArray[n2];
            if (sub.isCanceled()) {
                return newPositions;
            }
            if (this.isFoldable(child)) {
                int start = child.getStartingOffset();
                boolean add = true;
                int end = child.getEndingOffset() + 1;
                try {
                    int line = this.getDocument().getLineOfOffset(start);
                    if (this.fLines != null && this.fLines.contains(line)) {
                        add = false;
                    } else {
                        int endLine = this.getDocument().getLineOfOffset(child.getEndingOffset());
                        if (endLine == line) {
                            add = false;
                        } else {
                            end = this.getDocument().getLineOffset(endLine) + this.getDocument().getLineLength(endLine);
                            if (this.fLines != null) {
                                this.fLines.add(line);
                            }
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                if (add) {
                    end = Math.min(this.getDocument().getLength(), end);
                    if (start <= end) {
                        newPositions.put(this.initialReconcile ? new ProjectionAnnotation(this.isCollapsed(child)) : new ProjectionAnnotation(), new Position(start, end - start));
                    } else {
                        IdeLog.logWarning((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Was unable to add folding position. Start: {0}, end: {1}", start, end));
                    }
                }
            }
            if (this.traverseInto(child)) {
                newPositions.putAll(this.getPositions((IProgressMonitor)sub.newChild(1), child));
            }
            sub.worked(1);
            ++n2;
        }
        sub.done();
        return newPositions;
    }

    public boolean isCollapsed(IParseNode child) {
        return false;
    }

    public abstract boolean isFoldable(IParseNode var1);

    protected boolean traverseInto(IParseNode child) {
        if (child == null) {
            return false;
        }
        if (child.hasChildren()) {
            return true;
        }
        if (child instanceof ParseRootNode) {
            ParseRootNode root = (ParseRootNode)child;
            IParseNode[] comments = root.getCommentNodes();
            return comments != null && comments.length > 0;
        }
        return false;
    }
}

