/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.rules;

import com.aptana.editor.common.text.rules.CollectingCharacterScanner;
import com.aptana.editor.common.text.rules.ExtendedToken;
import com.aptana.editor.common.text.rules.IResumableRule;
import com.aptana.editor.common.text.rules.PrefixedCharacterScanner;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.SingleLineRule;

public class ResumableSingleLineRule
extends SingleLineRule
implements IResumableRule {
    private boolean fResume;

    public ResumableSingleLineRule(String startSequence, String endSequence, IToken token, char escapeCharacter, boolean breaksOnEOF) {
        super(startSequence, endSequence, token, escapeCharacter, breaksOnEOF);
    }

    public ResumableSingleLineRule(String startSequence, String endSequence, IToken token, char escapeCharacter, boolean breaksOnEOF, boolean escapeContinuesLine) {
        super(startSequence, endSequence, token, escapeCharacter, breaksOnEOF, escapeContinuesLine);
    }

    protected IToken doEvaluate(ICharacterScanner scanner, boolean resume) {
        try {
            this.fResume = resume;
            IToken iToken = super.doEvaluate(scanner, resume);
            return iToken;
        }
        finally {
            this.fResume = false;
        }
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        CollectingCharacterScanner collectingCharacterScanner = new CollectingCharacterScanner(scanner, this.fResume ? "" : String.valueOf(this.fStartSequence));
        Object object = scanner = this.fResume && this.fToken instanceof ExtendedToken ? new PrefixedCharacterScanner(((ExtendedToken)this.fToken).getContentSubstring(this.fStartSequence.length), collectingCharacterScanner) : collectingCharacterScanner;
        if (this.doDetectEndSequence(scanner)) {
            if (this.fToken instanceof ExtendedToken) {
                ExtendedToken extendedToken = (ExtendedToken)this.fToken;
                String prefix = this.fResume ? extendedToken.getContents() : "";
                extendedToken.setContents(prefix.concat(collectingCharacterScanner.getContents()));
            }
            return true;
        }
        return false;
    }

    protected boolean doDetectEndSequence(ICharacterScanner scanner) {
        return super.endSequenceDetected(scanner);
    }

    public void resetRule() {
        if (this.fToken instanceof ExtendedToken) {
            ((ExtendedToken)this.fToken).setContents("");
        }
    }
}

