/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.viewer;

import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.scripting.snippets.ExpandSnippetVerifyKeyListener;
import com.aptana.editor.common.scripting.snippets.SnippetsContentAssistant;
import com.aptana.formatter.IScriptFormatterFactory;
import com.aptana.formatter.ScriptFormatterManager;
import com.aptana.formatter.preferences.PreferencesLookupDelegate;
import java.lang.reflect.Field;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.texteditor.ITextEditor;

public class CommonProjectionViewer
extends ProjectionViewer
implements IAdaptable,
IEclipsePreferences.IPreferenceChangeListener {
    private static final int RULER_EDITOR_GAP = 5;
    protected ExpandSnippetVerifyKeyListener fKeyListener;
    protected IContentAssistant fSnippetContentAssistant;
    protected IEclipsePreferences fPreferenceStore;

    public CommonProjectionViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles) {
        super(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
    }

    protected Layout createLayout() {
        return new SourceViewer.RulerLayout((SourceViewer)this, 5);
    }

    protected void handleDispose() {
        try {
            try {
                Field f = TextViewer.class.getDeclaredField("fWidgetCommand");
                if (f != null) {
                    f.setAccessible(true);
                    f.set((Object)this, null);
                }
            }
            catch (Throwable throwable) {
                super.handleDispose();
            }
        }
        finally {
            super.handleDispose();
        }
    }

    public IFormattingContext createFormattingContext() {
        IFormattingContext context;
        block6: {
            context = super.createFormattingContext();
            try {
                QualifiedContentType contentType = CommonEditorPlugin.getDefault().getDocumentScopeManager().getContentType(this.getDocument(), 0);
                if (contentType == null || contentType.getPartCount() <= 0) break block6;
                String[] stringArray = contentType.getParts();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IScriptFormatterFactory factory;
                    String ct = stringArray[n2];
                    String mainContentType = ct;
                    if (mainContentType.startsWith("com.aptana.contenttype.html")) {
                        mainContentType = "com.aptana.contenttype.html";
                    }
                    if ((factory = ScriptFormatterManager.getSelected((String)mainContentType)) != null) {
                        factory.setMainContentType(contentType.getParts()[0]);
                        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
                        if (textEditor != null) {
                            IResource file = (IResource)textEditor.getEditorInput().getAdapter(IResource.class);
                            context.setProperty((Object)"formatting.context.formatterId", (Object)factory.getId());
                            IProject project = file != null ? file.getProject() : null;
                            Map preferences = factory.retrievePreferences(new PreferencesLookupDelegate(project));
                            context.setProperty((Object)"formatting.context.preferences", (Object)preferences);
                        }
                        break;
                    }
                    ++n2;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return context;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void configure(SourceViewerConfiguration configuration) {
        super.configure(configuration);
        this.fSnippetContentAssistant = new SnippetsContentAssistant();
        this.fSnippetContentAssistant.install((ITextViewer)this);
        this.fKeyListener = new ExpandSnippetVerifyKeyListener((ITextEditor)this.getAdapter(ITextEditor.class), (ITextViewer)this, this.fSnippetContentAssistant);
        this.prependVerifyKeyListener(this.fKeyListener);
        this.fPreferenceStore = InstanceScope.INSTANCE.getNode("com.aptana.editor.common");
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            this.setSnippetProcessorEnablement();
        }
    }

    public void unconfigure() {
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
        if (this.fKeyListener != null) {
            this.removeVerifyKeyListener(this.fKeyListener);
            this.fKeyListener = null;
        }
        if (this.fSnippetContentAssistant != null) {
            this.fSnippetContentAssistant.uninstall();
            this.fSnippetContentAssistant = null;
        }
        super.unconfigure();
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("CONTENT_ASSIST_DELAY".equals(event.getKey())) {
            this.setSnippetProcessorEnablement();
        }
    }

    private void setSnippetProcessorEnablement() {
        if (this.fPreferenceStore == null || this.fKeyListener == null) {
            return;
        }
        int delay = this.fPreferenceStore.getInt("CONTENT_ASSIST_DELAY", 200);
        this.fKeyListener.setEnabled(delay >= 0);
    }
}

