/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.debug.core.DebugOptionsManager;
import com.aptana.debug.core.DetailFormatter;
import com.aptana.js.debug.core.JSDebugPlugin;
import com.aptana.js.debug.core.model.IJSVariable;
import com.aptana.js.debug.ui.JSDebugUIPlugin;
import com.aptana.js.debug.ui.internal.actions.ObjectActionDelegate;
import com.aptana.js.debug.ui.internal.dialogs.DetailFormatterDialog;
import com.aptana.ui.util.UIUtils;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public class NewDetailFormatterAction
extends ObjectActionDelegate {
    public void run(IAction action) {
        String typeName;
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null || selection.size() != 1) {
            return;
        }
        Object element = selection.getFirstElement();
        try {
            if (!(element instanceof IJSVariable)) {
                return;
            }
            typeName = ((IJSVariable)element).getReferenceTypeName();
        }
        catch (DebugException e) {
            IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
            return;
        }
        DebugOptionsManager detailFormattersManager = JSDebugPlugin.getDefault().getDebugOptionsManager();
        DetailFormatter detailFormatter = new DetailFormatter(typeName, "", true);
        if (new DetailFormatterDialog(UIUtils.getActiveShell(), detailFormatter, null, true, false).open() == 0) {
            detailFormattersManager.setAssociatedDetailFormatter(detailFormatter);
            this.refreshCurrentSelection();
        }
    }
}

