/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.js.debug.core.model.IJSInspectExpression;
import com.aptana.js.debug.core.model.JSDebugModel;
import com.aptana.js.debug.ui.JSDebugUIPlugin;
import com.aptana.js.debug.ui.internal.actions.InspectAction;
import com.aptana.ui.util.UIUtils;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.debug.ui.InspectPopupDialog;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class PopupInspectAction
extends InspectAction
implements IInformationProvider {
    private static final String ACTION_DEFININIITION_ID = "com.aptana.debug.ui.commands.Inspect";
    private ITextViewer viewer;
    private IJSInspectExpression expression;

    public String getInformation(ITextViewer textViewer, IRegion subject) {
        return "not null";
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        return this.getRegion();
    }

    protected void showPopup(IWatchExpressionResult result) {
        this.expression = JSDebugModel.createInspectExpression((IWatchExpressionResult)result);
        InspectPopupDialog displayPopup = new InspectPopupDialog(this.getShell(), PopupInspectAction.getPopupAnchor(this.viewer), ACTION_DEFININIITION_ID, (IExpression)this.expression);
        if (displayPopup != null) {
            displayPopup.open();
        }
    }

    protected void displayResult(IWatchExpressionResult result) {
        IWorkbenchPart part = this.getTargetPart();
        this.viewer = (ISourceViewer)part.getAdapter(ISourceViewer.class);
        if (this.viewer == null) {
            IdeLog.logInfo((Plugin)JSDebugUIPlugin.getDefault(), (String)"TODO: com.aptana.js.debug.ui.internal.actions.PopupInspectAction.displayResult()");
        }
        if (this.viewer == null) {
            super.displayResult(result);
        } else {
            this.showPopup(result);
        }
    }

    private IWorkbenchPart getTargetPart() {
        return UIUtils.getActivePart();
    }

    protected IRegion getRegion() {
        Point point = this.viewer.getSelectedRange();
        return new Region(point.x, point.y);
    }

    private Shell getShell() {
        if (this.getTargetPart() != null) {
            return this.getTargetPart().getSite().getShell();
        }
        return UIUtils.getActiveShell();
    }

    private static Point getPopupAnchor(ITextViewer viewer) {
        StyledText textWidget = viewer.getTextWidget();
        Point docRange = textWidget.getSelectionRange();
        int midOffset = docRange.x + (docRange.y >> 1);
        Point point = textWidget.getLocationAtOffset(midOffset);
        point = textWidget.toDisplay(point);
        GC gc = new GC((Drawable)textWidget);
        gc.setFont(textWidget.getFont());
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        point.y += height;
        return point;
    }
}

