/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.formatter.nodes;

import com.aptana.editor.js.formatter.nodes.FormatterJSTextNode;
import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.nodes.FormatterTextNode;
import com.aptana.formatter.nodes.IFormatterTextNode;
import com.aptana.js.core.parsing.ast.JSNode;
import com.aptana.parsing.ast.IParseNode;

public class FormatterJSIdentifierNode
extends FormatterJSTextNode {
    private JSNode node;

    public FormatterJSIdentifierNode(IFormatterDocument document, JSNode node, boolean hasCommentBefore) {
        super(document, !hasCommentBefore);
        this.node = node;
    }

    private boolean isMultipleAssignment() {
        IParseNode parent = this.node.getParent();
        if (parent == null) {
            return false;
        }
        short parentType = parent.getNodeType();
        if (parentType != 1) {
            return false;
        }
        IParseNode grandParent = parent.getParent();
        while (grandParent != null && grandParent.getNodeType() == 74) {
            if (grandParent.getChild(0) != parent) {
                return true;
            }
            parent = grandParent;
            grandParent = grandParent.getParent();
        }
        return false;
    }

    private boolean isMultipleVarDeclaration() {
        IParseNode parent = this.node.getParent();
        if (parent == null) {
            return false;
        }
        if (parent.getNodeType() != 63) {
            return false;
        }
        IParseNode grandParent = parent.getParent();
        if (grandParent == null) {
            return false;
        }
        if (grandParent.getNodeType() != 64) {
            return false;
        }
        return grandParent.getChild(0) != parent;
    }

    public void setBegin(IFormatterTextNode begin) {
        boolean isMultipleDecl;
        if (this.getDocument().getBoolean("js.formatter.newline.between.var.declarations") && ((isMultipleDecl = this.isMultipleVarDeclaration()) || this.isMultipleAssignment())) {
            FormatterTextNode newBegin = new FormatterTextNode(begin.getDocument(), begin.getStartOffset(), begin.getEndOffset()){

                public void accept(IFormatterContext context, IFormatterWriter visitor) throws Exception {
                    visitor.ensureLineStarted(context);
                    if (isMultipleDecl) {
                        visitor.writeText(context, "    ", false);
                    }
                    super.accept(context, visitor);
                }
            };
            begin = newBegin;
        }
        super.setBegin(begin);
    }

    protected boolean isAddingBeginNewLine() {
        boolean isFirstInLine;
        if (!this.shouldConsumePreviousSpaces || this.isAddingBeginLine) {
            return true;
        }
        if (this.getDocument().getBoolean("js.formatter.newline.between.var.declarations") && (this.isMultipleVarDeclaration() || this.isMultipleAssignment())) {
            return true;
        }
        if (this.isPartOfExpression(this.node)) {
            return false;
        }
        IParseNode parent = this.node.getParent();
        if (parent == null) {
            return false;
        }
        boolean bl = isFirstInLine = parent.getStartingOffset() == this.node.getStartingOffset();
        if (parent instanceof JSNode && ((JSNode)parent).getSemicolonIncluded()) {
            return isFirstInLine;
        }
        return false;
    }

    private boolean isPartOfExpression(JSNode jsNode) {
        if (jsNode == null) {
            return false;
        }
        switch (jsNode.getNodeType()) {
            case 1: 
            case 48: 
            case 58: 
            case 61: 
            case 62: 
            case 63: 
            case 68: 
            case 75: 
            case 76: 
            case 85: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldConsumePreviousWhiteSpaces() {
        return !this.isAddingBeginNewLine();
    }

    public int getSpacesCountBefore() {
        IParseNode parent = this.node.getParent();
        if (parent != null) {
            boolean isFirstChild = parent.getChild(0) == this.node;
            short parentType = parent.getNodeType();
            if (isFirstChild) {
                switch (parentType) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 48: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 69: 
                    case 72: 
                    case 74: 
                    case 76: 
                    case 80: 
                    case 81: 
                    case 86: 
                    case 88: 
                    case 89: {
                        return 0;
                    }
                }
                return 1;
            }
            switch (parentType) {
                case 89: {
                    return 1;
                }
            }
        }
        return 0;
    }
}

