/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.core.parsing;

import com.aptana.ruby.debug.core.RubyDebugCorePlugin;
import com.aptana.ruby.internal.debug.core.model.RubyStackFrame;
import com.aptana.ruby.internal.debug.core.model.RubyThread;
import com.aptana.ruby.internal.debug.core.parsing.AbstractReadStrategy;
import com.aptana.ruby.internal.debug.core.parsing.XmlStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;

public class FramesReader
extends XmlStreamReader {
    private RubyThread thread;
    private List<RubyStackFrame> frames;

    public FramesReader(XmlPullParser xpp) {
        super(xpp);
    }

    public FramesReader(AbstractReadStrategy readStrategy) {
        super(readStrategy);
    }

    public RubyStackFrame[] readFrames(RubyThread thread) {
        this.thread = thread;
        this.frames = new ArrayList<RubyStackFrame>();
        try {
            this.read();
        }
        catch (Exception ex) {
            RubyDebugCorePlugin.log(ex);
            return new RubyStackFrame[0];
        }
        Collections.sort(this.frames, new Comparator<RubyStackFrame>(){

            @Override
            public int compare(RubyStackFrame one, RubyStackFrame two) {
                return Integer.valueOf(one.getIndex()).compareTo(two.getIndex());
            }
        });
        RubyStackFrame[] frameArray = new RubyStackFrame[this.frames.size()];
        this.frames.toArray(frameArray);
        thread.setStackFrames(frameArray);
        return frameArray;
    }

    @Override
    protected boolean processStartElement(XmlPullParser xpp) {
        String name = xpp.getName();
        if (name.equals("frames")) {
            return true;
        }
        if (name.equals("frame")) {
            int line = Integer.parseInt(xpp.getAttributeValue("", "line"));
            int index = Integer.parseInt(xpp.getAttributeValue("", "no"));
            String file = xpp.getAttributeValue("", "file");
            this.frames.add(new RubyStackFrame(this.thread, file, line, index));
            return true;
        }
        return false;
    }

    @Override
    protected boolean processEndElement(XmlPullParser xpp) {
        return xpp.getName().equals("frames");
    }
}

