/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.findbar.impl;

import com.aptana.editor.findbar.impl.Messages;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.IFindReplaceTargetExtension2;

public class CopiedFromFindReplaceDialog {
    private final IFindReplaceTarget fTarget;
    private final IEditorStatusLine fStatusLineManager;

    public CopiedFromFindReplaceDialog(IFindReplaceTarget target, IEditorStatusLine statusLineManager) {
        this.fTarget = target;
        this.fStatusLineManager = statusLineManager;
    }

    Point replaceSelection(String replaceString, boolean regExReplace) {
        if (this.fTarget instanceof IFindReplaceTargetExtension3) {
            ((IFindReplaceTargetExtension3)this.fTarget).replaceSelection(replaceString, regExReplace);
        } else {
            this.fTarget.replaceSelection(replaceString);
        }
        return this.fTarget.getSelection();
    }

    int findAndSelect(int offset, String findString, boolean forwardSearch, boolean caseSensitive, boolean wholeWord, boolean regExSearch) {
        if (this.fTarget instanceof IFindReplaceTargetExtension3) {
            return ((IFindReplaceTargetExtension3)this.fTarget).findAndSelect(offset, findString, forwardSearch, caseSensitive, wholeWord, regExSearch);
        }
        return this.fTarget.findAndSelect(offset, findString, forwardSearch, caseSensitive, wholeWord);
    }

    int replaceAll(String findString, String replaceString, boolean forwardSearch, boolean caseSensitive, boolean wholeWord, boolean regExSearch) {
        int replaceCount = 0;
        int findReplacePosition = 0;
        findReplacePosition = 0;
        forwardSearch = true;
        if (!this.validateTargetState()) {
            return replaceCount;
        }
        if (this.fTarget instanceof IFindReplaceTargetExtension) {
            ((IFindReplaceTargetExtension)this.fTarget).setReplaceAllMode(true);
        }
        try {
            int index = 0;
            while (index != -1) {
                index = this.findAndSelect(findReplacePosition, findString, forwardSearch, caseSensitive, wholeWord, regExSearch);
                if (index == -1) continue;
                Point selection = this.replaceSelection(replaceString, regExSearch);
                ++replaceCount;
                if (forwardSearch) {
                    findReplacePosition = selection.x + selection.y;
                    continue;
                }
                findReplacePosition = selection.x - 1;
                if (findReplacePosition != -1) continue;
                break;
            }
        }
        finally {
            if (this.fTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)this.fTarget).setReplaceAllMode(false);
            }
        }
        return replaceCount;
    }

    private boolean validateTargetState() {
        IFindReplaceTargetExtension2 extension;
        if (this.fTarget instanceof IFindReplaceTargetExtension2 && !(extension = (IFindReplaceTargetExtension2)this.fTarget).validateTargetState()) {
            this.fStatusLineManager.setMessage(true, Messages.FindBarDecorator_MSG_ReadOnly, null);
            return false;
        }
        return this.isEditable();
    }

    private boolean isEditable() {
        boolean isEditable = this.fTarget == null ? false : this.fTarget.isEditable();
        return isEditable;
    }
}

