/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.findbar.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.internal.texteditor.TextEditorPlugin;

public class EclipseFindSettings {
    public static final String FIND_REPLACE_DIALOG_CLASS_NAME = "org.eclipse.ui.texteditor.FindReplaceDialog";
    private IDialogSettings fDialogSettings;
    boolean fWrap;
    boolean fCase;
    boolean fWholeWord;
    boolean fRegExSearch;
    String fSelection;
    final List<String> fFindHistory = new ArrayList<String>();

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = TextEditorPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(FIND_REPLACE_DIALOG_CLASS_NAME);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(FIND_REPLACE_DIALOG_CLASS_NAME);
        }
        return this.fDialogSettings;
    }

    void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        this.fWrap = s.get("wrap") == null || s.getBoolean("wrap");
        this.fCase = s.getBoolean("casesensitive");
        this.fWholeWord = s.getBoolean("wholeword");
        this.fRegExSearch = s.getBoolean("isRegEx");
        this.fSelection = s.get("selection");
        String[] findHistory = s.getArray("findhistory");
        if (findHistory != null) {
            this.fFindHistory.clear();
            int i = 0;
            while (i < findHistory.length) {
                this.fFindHistory.add(findHistory[i]);
                ++i;
            }
        }
    }

    void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        s.put("selection", this.fSelection);
        while (this.fFindHistory.size() > 8) {
            this.fFindHistory.remove(8);
        }
        String[] names = new String[this.fFindHistory.size()];
        this.fFindHistory.toArray(names);
        s.put("findhistory", names);
        s.put("wrap", this.fWrap);
        s.put("casesensitive", this.fCase);
        s.put("wholeword", this.fWholeWord);
        s.put("isRegEx", this.fRegExSearch);
    }

    public void addEntry(String selection) {
        this.fSelection = selection;
        int index = this.fFindHistory.indexOf(selection);
        if (index != -1) {
            this.fFindHistory.remove(index);
        }
        this.fFindHistory.add(0, selection);
        while (this.fFindHistory.size() > 8) {
            this.fFindHistory.remove(8);
        }
        String[] names = new String[this.fFindHistory.size()];
        this.fFindHistory.toArray(names);
        this.writeConfiguration();
    }
}

