/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.filesystem.s3;

import com.aptana.ide.filesystem.s3.S3FileStore;
import com.aptana.ide.filesystem.s3.S3FileSystemPlugin;
import com.aptana.ide.filesystem.s3.S3FileTree;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileTree;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.runtime.IProgressMonitor;

public class S3FileSystem
extends FileSystem {
    public IFileStore getStore(URI uri) {
        return new S3FileStore(uri);
    }

    public boolean canDelete() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public IFileTree fetchFileTree(IFileStore root, IProgressMonitor monitor) {
        S3FileStore s3Store;
        block5: {
            if (!(root instanceof S3FileStore)) {
                return null;
            }
            s3Store = (S3FileStore)root;
            if (monitor == null || !monitor.isCanceled()) break block5;
            return null;
        }
        try {
            return new S3FileTree(root, s3Store.listEntries());
        }
        catch (MalformedURLException e) {
            S3FileSystemPlugin.log(e);
        }
        catch (IOException e) {
            S3FileSystemPlugin.log(e);
        }
        return null;
    }
}

