/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.commandline.launcher.application;

import com.aptana.commandline.launcher.CommandlineLauncherPlugin;
import com.aptana.commandline.launcher.application.Messages;
import com.aptana.commandline.launcher.server.port.PortManager;
import com.aptana.core.logging.IdeLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.util.NLS;

public class LauncherApplication
implements IApplication {
    private IApplication productApplication;

    public Object start(IApplicationContext context) throws Exception {
        int port = -1;
        try {
            port = PortManager.getRunningInstancePort();
            if (port < 0) {
                String productApplicationId = Platform.getProduct().getApplication();
                this.productApplication = this.getApplication(productApplicationId);
                if (this.productApplication != null) {
                    return this.productApplication.start(context);
                }
                IllegalStateException e = new IllegalStateException(NLS.bind((String)Messages.LauncherApplication_ApplicationNotFound, (Object)productApplicationId));
                IdeLog.logError((Plugin)CommandlineLauncherPlugin.getDefault(), (Throwable)e);
            } else {
                String[] arguments;
                Object args = context.getArguments().get("application.args");
                if (args instanceof String[] && (arguments = (String[])args).length > 0 && !LauncherApplication.sendArguments(port, arguments)) {
                    IllegalStateException e = new IllegalStateException(Messages.LauncherApplication_CouldNotSendCommandLineArguments);
                    IdeLog.logError((Plugin)CommandlineLauncherPlugin.getDefault(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommandlineLauncherPlugin.getDefault(), (Throwable)e);
        }
        return EXIT_OK;
    }

    public void stop() {
        if (this.productApplication != null) {
            this.productApplication.stop();
        }
    }

    private IApplication getApplication(String applicationId) throws CoreException {
        Object runnable;
        IConfigurationElement[] runs;
        IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.runtime", "applications", applicationId);
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements.length > 0 && (runs = elements[0].getChildren("run")).length > 0 && (runnable = runs[0].createExecutableExtension("class")) instanceof IApplication) {
            return (IApplication)runnable;
        }
        return null;
    }

    public static boolean sendArguments(int port, String[] arguments) {
        LinkedList<String> filesList = new LinkedList<String>();
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String argument = stringArray[n2];
            File file = new File(argument);
            if (file.exists()) {
                filesList.add(file.getAbsolutePath());
            }
            ++n2;
        }
        arguments = filesList.toArray(new String[0]);
        Socket socket = null;
        InputStream is = null;
        OutputStream os = null;
        try {
            socket = new Socket(InetAddress.getByName(null), port);
            os = socket.getOutputStream();
            is = socket.getInputStream();
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CommandlineLauncherPlugin.getDefault(), (Throwable)e);
            return false;
        }
        if (os != null) {
            try {
                PrintWriter ps = new PrintWriter(os);
                String[] stringArray2 = arguments;
                int n3 = arguments.length;
                int n4 = 0;
                while (n4 < n3) {
                    String argument = stringArray2[n4];
                    ps.println(argument);
                    ++n4;
                }
                ps.flush();
                ps.close();
                try {
                    is.read();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return true;
            }
            finally {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }
}

