/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io.downloader;

import com.aptana.core.epl.downloader.ConnectionData;
import com.aptana.core.epl.downloader.FileReader;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.ide.core.io.downloader.Messages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.osgi.util.NLS;

public class ContentDownloadRequest {
    protected final URI uri;
    private File saveTo;
    private IStatus result;
    private IConnectContext context;

    public ContentDownloadRequest(URI uri) throws CoreException {
        this(uri, ContentDownloadRequest.getTempFile(uri));
    }

    public ContentDownloadRequest(URI uri, File saveTo) {
        this(uri, saveTo, null);
    }

    public ContentDownloadRequest(URI uri, IConnectContext context) throws CoreException {
        this(uri, ContentDownloadRequest.getTempFile(uri), context);
    }

    public ContentDownloadRequest(URI uri, File saveTo, IConnectContext context) {
        this.uri = uri;
        this.saveTo = saveTo;
        this.context = context;
    }

    public IStatus getResult() {
        return this.result;
    }

    public IPath getDownloadLocation() {
        if (this.saveTo == null) {
            return null;
        }
        return Path.fromOSString((String)this.saveTo.getAbsolutePath());
    }

    protected void setResult(IStatus result) {
        this.result = result;
    }

    public void execute(IProgressMonitor monitor) {
        this.execute(null, monitor);
    }

    public void execute(ConnectionData data, IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.subTask(NLS.bind((String)Messages.ContentDownloadRequest_downloading, (Object)this.uri.toString()));
        }
        IStatus status = this.download(data, monitor);
        this.setResult(status);
    }

    private IStatus download(ConnectionData data, IProgressMonitor monitor) {
        try {
            FileReader reader = this.createReader(data);
            OutputStream anOutputStream = this.createOutputStream(this.saveTo);
            reader.readInto(this.uri, anOutputStream, 0L, monitor);
            IStatus result = reader.getResult();
            if (result != null) {
                if (result.getSeverity() == 8) {
                    return Status.CANCEL_STATUS;
                }
                if (!result.isOK()) {
                    throw new CoreException(result);
                }
            }
        }
        catch (OperationCanceledException e) {
            return Status.CANCEL_STATUS;
        }
        catch (Throwable t) {
            if (monitor != null && monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return new Status(4, "com.aptana.core.io", t.getMessage(), t);
        }
        return Status.OK_STATUS;
    }

    protected FileReader createReader(ConnectionData data) {
        return new FileReader(data, this.context);
    }

    protected OutputStream createOutputStream(File dest) throws FileNotFoundException {
        return new FileOutputStream(dest);
    }

    protected static File getTempFile(URI uri) throws CoreException {
        IPath path = Path.fromOSString((String)uri.getPath());
        String name = path.lastSegment();
        if (!StringUtil.isEmpty((String)name)) {
            String tempPath = FileUtil.getTempDirectory().toOSString();
            File f = new File(tempPath, name);
            f.deleteOnExit();
            return f;
        }
        try {
            return File.createTempFile(Messages.ContentDownloadRequest_tempFilePrefix, null);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", "Could not create a local temporary file for the downloaded content", (Throwable)e));
        }
    }
}

