/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io.internal.auth;

import com.aptana.core.logging.IdeLog;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.auth.IAuthenticationManager;
import com.aptana.ide.core.io.auth.IAuthenticationPrompt;
import com.aptana.ide.core.io.internal.auth.Messages;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;

public class AuthenticationManager
implements IAuthenticationManager {
    private static final String SECURITY_NODE = "com.aptana.core.io.auth";
    private static final String PROP_PASSWORD = "password";
    protected transient Map<String, char[]> sessionPasswords = new HashMap<String, char[]>();

    public boolean hasPersistent(String authId) {
        ISecurePreferences preferences = this.getSecurePreferences();
        if (preferences.nodeExists(authId)) {
            ISecurePreferences node = preferences.node(authId);
            return Arrays.asList(node.keys()).contains(PROP_PASSWORD);
        }
        return false;
    }

    public char[] getPassword(String authId) {
        ISecurePreferences preferences = this.getSecurePreferences();
        if (preferences.nodeExists(authId)) {
            try {
                ISecurePreferences node = preferences.node(authId);
                String password = node.get(PROP_PASSWORD, null);
                if (password != null) {
                    return password.toCharArray();
                }
            }
            catch (StorageException e) {
                IdeLog.logWarning((Plugin)CoreIOPlugin.getDefault(), (String)Messages.AuthenticationManager_FailedGetSecurePreference, (Throwable)e);
            }
        }
        if (this.sessionPasswords.containsKey(authId)) {
            return this.sessionPasswords.get(authId);
        }
        return null;
    }

    public char[] promptPassword(String authId, String login, String title, String message) {
        IAuthenticationPrompt authPrompt = this.getAuthPrompt();
        if (authPrompt != null && authPrompt.promptPassword(this, authId, login, title, message)) {
            return this.sessionPasswords.get(authId);
        }
        return null;
    }

    protected IAuthenticationPrompt getAuthPrompt() {
        IAdapterManager adaptManager = this.getAdapterManager();
        IAuthenticationPrompt authPrompt = (IAuthenticationPrompt)adaptManager.getAdapter((Object)this, IAuthenticationPrompt.class);
        if (authPrompt == null && adaptManager.hasAdapter((Object)this, IAuthenticationPrompt.class.getName())) {
            authPrompt = (IAuthenticationPrompt)adaptManager.loadAdapter((Object)this, IAuthenticationPrompt.class.getName());
        }
        return authPrompt;
    }

    protected IAdapterManager getAdapterManager() {
        return Platform.getAdapterManager();
    }

    public void resetPassword(String authId) {
        ISecurePreferences preferences = this.getSecurePreferences();
        if (preferences.nodeExists(authId)) {
            ISecurePreferences node = preferences.node(authId);
            node.removeNode();
        }
        this.sessionPasswords.remove(authId);
    }

    public void setPassword(String authId, char[] password, boolean persistent) {
        ISecurePreferences root = this.getSecurePreferences();
        ISecurePreferences node = root.node(authId);
        try {
            this.sessionPasswords.remove(authId);
            if (password != null) {
                this.sessionPasswords.put(authId, password);
                if (persistent) {
                    node.put(PROP_PASSWORD, String.copyValueOf(password), true);
                } else {
                    node.removeNode();
                }
            }
            root.flush();
        }
        catch (Exception e) {
            IdeLog.logWarning((Plugin)CoreIOPlugin.getDefault(), (String)Messages.AuthenticationManager_FailedSaveSecurePreference, (Throwable)e);
        }
    }

    protected ISecurePreferences getSecurePreferences() {
        return SecurePreferencesFactory.getDefault().node(SECURITY_NODE);
    }
}

