/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.explorer;

import com.aptana.core.util.EclipseUtil;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

public class ExplorerPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.aptana.explorer";
    private static final String COMMAND_ID = "com.aptana.explorer.commands.toggleAppExplorer";
    private static final String COMMAND_STATE = "org.eclipse.ui.commands.toggleState";
    private static ExplorerPlugin plugin;
    private final IPerspectiveListener fPerspectiveListener = new IPerspectiveListener(){

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            this.setCommandState(ExplorerPlugin.this.findView(page, "com.aptana.explorer.view") != null);
        }

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            if (changeId.equals("viewHide")) {
                if (ExplorerPlugin.this.findView(page, "com.aptana.explorer.view") == null) {
                    this.setCommandState(false);
                }
            } else if (changeId.equals("viewShow") && ExplorerPlugin.this.findView(page, "com.aptana.explorer.view") != null) {
                this.setCommandState(true);
            }
        }

        private void setCommandState(boolean state) {
            ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command command = service.getCommand(ExplorerPlugin.COMMAND_ID);
            State commandState = command.getState(ExplorerPlugin.COMMAND_STATE);
            if ((Boolean)commandState.getValue() != state) {
                commandState.setValue((Object)state);
                service.refreshElements(ExplorerPlugin.COMMAND_ID, null);
            }
        }
    };
    private final IWindowListener fWindowListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            window.removePerspectiveListener(ExplorerPlugin.this.fPerspectiveListener);
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
            window.addPerspectiveListener(ExplorerPlugin.this.fPerspectiveListener);
        }
    };

    private IViewReference findView(IWorkbenchPage page, String viewId) {
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IViewReference ref = refs[i];
            if (viewId.equals(ref.getId())) {
                return ref;
            }
            ++i;
        }
        return null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        UIJob uiJob = new UIJob("adding app explorer toggle listener"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ExplorerPlugin.this.addPartListener();
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)uiJob);
        uiJob.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.removePartListener();
        }
        finally {
            plugin = null;
            super.stop(context);
        }
    }

    public static ExplorerPlugin getDefault() {
        return plugin;
    }

    public static Image getImage(String string) {
        ImageDescriptor id;
        if (ExplorerPlugin.getDefault().getImageRegistry().get(string) == null && (id = ExplorerPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)string)) != null) {
            ExplorerPlugin.getDefault().getImageRegistry().put(string, id);
        }
        return ExplorerPlugin.getDefault().getImageRegistry().get(string);
    }

    public static void logError(CoreException e) {
        ExplorerPlugin.getDefault().getLog().log(e.getStatus());
    }

    private void addPartListener() {
        IWorkbench workbench = null;
        try {
            workbench = PlatformUI.getWorkbench();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (workbench != null) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                window.addPerspectiveListener(this.fPerspectiveListener);
                ++n2;
            }
            workbench.addWindowListener(this.fWindowListener);
        }
    }

    private void removePartListener() {
        IWorkbench workbench = null;
        try {
            workbench = PlatformUI.getWorkbench();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (workbench != null) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                window.removePerspectiveListener(this.fPerspectiveListener);
                ++n2;
            }
            workbench.removeWindowListener(this.fWindowListener);
        }
    }
}

