/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.explorer.internal.ui;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.ProcessStatus;
import com.aptana.explorer.ExplorerPlugin;
import com.aptana.explorer.internal.ui.GitChangedFilesFilter;
import com.aptana.explorer.internal.ui.Messages;
import com.aptana.explorer.internal.ui.SingleProjectView;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.BranchAddedEvent;
import com.aptana.git.core.model.BranchChangedEvent;
import com.aptana.git.core.model.BranchRemovedEvent;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.core.model.IGitRepositoriesListener;
import com.aptana.git.core.model.IGitRepositoryListener;
import com.aptana.git.core.model.IGitRepositoryManager;
import com.aptana.git.core.model.IndexChangedEvent;
import com.aptana.git.core.model.PullEvent;
import com.aptana.git.core.model.PushEvent;
import com.aptana.git.core.model.RepositoryAddedEvent;
import com.aptana.git.core.model.RepositoryRemovedEvent;
import com.aptana.git.ui.dialogs.CreateBranchDialog;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.progress.UIJob;

public class GitProjectView
extends SingleProjectView
implements IGitRepositoryListener,
IGitRepositoriesListener {
    private static final String TEAM_MAIN = "team.main";
    private static final String DIRTY_SUFFIX = "*";
    private static final String GIT_CHANGED_FILES_FILTER = "GitChangedFilesFilterEnabled";
    private static final String PROJECT_DELIMITER = "######";
    private static final String CHANGED_FILE_FILTER_ICON_PATH = "icons/full/elcl16/filter.png";
    private static final String CREATE_NEW_BRANCH_TEXT = Messages.GitProjectView_createNewBranchOption;
    private Label leftLabel;
    private GridData leftLabelGridData;
    private Label rightLabel;
    private GridData rightLabelGridData;
    private ToolBar branchesToolbar;
    private GridData branchesToolbarGridData;
    private ToolItem branchesToolItem;
    private Menu branchesMenu;
    private GitChangedFilesFilter fChangedFilesFilter;
    private Set<IProject> fChangedFilesFilterProjects;
    private Job pullCalc;
    private HashMap<String, Boolean> branchToPullIndicator = new HashMap();
    private UIJob refreshUIJob;

    public GitProjectView() {
        this.fChangedFilesFilterProjects = new HashSet<IProject>();
    }

    public void createPartControl(Composite aParent) {
        super.createPartControl(aParent);
        this.getGitRepositoryManager().addListener((IGitRepositoriesListener)this);
        if (this.fChangedFilesFilterProjects.contains(this.selectedProject)) {
            UIJob job = new UIJob("Turn on git filter initially"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    GitProjectView.this.addGitChangedFilesFilter();
                    return Status.OK_STATUS;
                }
            };
            EclipseUtil.setSystemForJob((Job)job);
            job.setPriority(20);
            job.schedule(300L);
        }
        this.pullCalc = new Job("Calculating git pull indicators"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                boolean performFetches = Platform.getPreferencesService().getBoolean(GitPlugin.getPluginId(), "git_calculate_pull_indicator", false, null);
                if (!performFetches) {
                    return Status.OK_STATUS;
                }
                if (monitor != null && monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                GitRepository repo = GitProjectView.this.getGitRepositoryManager().getAttached(GitProjectView.this.selectedProject);
                if (repo == null) {
                    this.schedule(300000L);
                    return Status.OK_STATUS;
                }
                if (monitor != null && monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                HashMap hashMap = GitProjectView.this.branchToPullIndicator;
                synchronized (hashMap) {
                    GitProjectView.this.branchToPullIndicator.clear();
                }
                Set branchesToPull = repo.getOutOfDateBranches();
                for (String branch : repo.localBranches()) {
                    if (monitor != null && monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    HashMap hashMap2 = GitProjectView.this.branchToPullIndicator;
                    synchronized (hashMap2) {
                        GitProjectView.this.branchToPullIndicator.put(branch, branchesToPull.contains(branch));
                    }
                }
                GitProjectView.this.refreshUI(repo);
                if (monitor != null && monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                this.schedule(300000L);
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)this.pullCalc);
        this.pullCalc.setPriority(30);
        this.pullCalc.schedule();
    }

    protected void doCreateToolbar(Composite toolbarComposite) {
        Composite branchComp = new Composite(toolbarComposite, 0);
        GridLayout toolbarGridLayout = new GridLayout(3, false);
        toolbarGridLayout.marginWidth = 2;
        toolbarGridLayout.marginHeight = 0;
        toolbarGridLayout.horizontalSpacing = 0;
        branchComp.setLayout((Layout)toolbarGridLayout);
        this.createGitBranchCombo(branchComp);
    }

    private void createGitBranchCombo(Composite parent) {
        this.leftLabel = new Label(parent, 0);
        this.leftLabel.setText("[");
        this.leftLabelGridData = new GridData(0x1000008, 0x1000000, false, false);
        this.leftLabel.setLayoutData((Object)this.leftLabelGridData);
        this.branchesToolbar = new ToolBar(parent, 0x800000);
        this.branchesToolbarGridData = new GridData(1, 0x1000000, false, false);
        this.branchesToolbar.setLayoutData((Object)this.branchesToolbarGridData);
        this.branchesToolItem = new ToolItem(this.branchesToolbar, 4);
        this.branchesMenu = new Menu((Control)this.branchesToolbar);
        this.branchesToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Point toolbarLocation = GitProjectView.this.branchesToolbar.getLocation();
                toolbarLocation = GitProjectView.this.branchesToolbar.getParent().toDisplay(toolbarLocation.x, toolbarLocation.y);
                Point toolbarSize = GitProjectView.this.branchesToolbar.getSize();
                GitProjectView.this.branchesMenu.setLocation(toolbarLocation.x, toolbarLocation.y + toolbarSize.y + 2);
                GitProjectView.this.branchesMenu.setVisible(true);
            }
        });
        this.rightLabel = new Label(parent, 0);
        this.rightLabel.setText("]");
        this.rightLabelGridData = new GridData(1, 0x1000000, false, false);
        this.rightLabel.setLayoutData((Object)this.rightLabelGridData);
    }

    public void dispose() {
        GitRepository repo;
        if (this.selectedProject != null && (repo = this.getGitRepositoryManager().getAttached(this.selectedProject)) != null) {
            repo.removeListener((IGitRepositoryListener)this);
        }
        this.getGitRepositoryManager().removeListener((IGitRepositoriesListener)this);
        if (this.pullCalc != null) {
            this.pullCalc.cancel();
            this.pullCalc = null;
        }
        this.branchToPullIndicator = null;
        if (this.refreshUIJob != null) {
            this.refreshUIJob.cancel();
            this.refreshUIJob = null;
        }
        super.dispose();
    }

    protected void removeFilter() {
        if (this.fChangedFilesFilter != null) {
            this.getCommonViewer().removeFilter((ViewerFilter)this.fChangedFilesFilter);
            this.fChangedFilesFilter = null;
            this.fChangedFilesFilterProjects.remove(this.selectedProject);
        }
        super.removeFilter();
    }

    private boolean setNewBranch(String branchName) {
        IStatus switchStatus;
        branchName = this.stripIndicators(branchName);
        GitRepository repo = this.getGitRepositoryManager().getAttached(this.selectedProject);
        if (repo == null) {
            return false;
        }
        if (branchName.equals(repo.currentBranch())) {
            return false;
        }
        if (branchName.equals(CREATE_NEW_BRANCH_TEXT)) {
            String startPoint;
            boolean track;
            CreateBranchDialog dialog = new CreateBranchDialog(this.getSite().getShell(), repo);
            if (dialog.open() != 0) {
                this.revertToCurrentBranch(repo);
                return false;
            }
            branchName = dialog.getValue().trim();
            if (!repo.createBranch(branchName, track = dialog.track(), startPoint = dialog.getStartPoint())) {
                this.revertToCurrentBranch(repo);
                return false;
            }
        }
        if ((switchStatus = repo.switchBranch(branchName, (IProgressMonitor)new NullProgressMonitor())).isOK()) {
            this.refreshViewer();
            return true;
        }
        String msg = switchStatus.getMessage();
        if (switchStatus instanceof ProcessStatus) {
            msg = ((ProcessStatus)switchStatus).getStdErr();
        }
        MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.GitProjectView_SwitchBranchFailedTitle, (String)msg);
        return false;
    }

    private String stripIndicators(String branchName) {
        if (branchName.endsWith(" " + this.getRightArrowChar())) {
            branchName = branchName.substring(0, branchName.length() - 2);
        }
        if (branchName.endsWith(" " + this.getLeftArrowChar())) {
            branchName = branchName.substring(0, branchName.length() - 2);
        }
        if (branchName.endsWith(DIRTY_SUFFIX)) {
            branchName = branchName.substring(0, branchName.length() - 1);
        }
        return branchName;
    }

    private void revertToCurrentBranch(final GitRepository repo) {
        UIJob job = new UIJob("Reverting back to current branch"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                MenuItem[] menuItems;
                String currentBranchName = repo.currentBranch();
                if (repo.isDirty()) {
                    currentBranchName = String.valueOf(currentBranchName) + GitProjectView.DIRTY_SUFFIX;
                }
                GitProjectView.this.branchesToolItem.setText(currentBranchName);
                MenuItem[] menuItemArray = menuItems = GitProjectView.this.branchesMenu.getItems();
                int n = menuItems.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem menuItem = menuItemArray[n2];
                    menuItem.setSelection(menuItem.getText().equals(currentBranchName));
                    ++n2;
                }
                GitProjectView.this.branchesToolbar.pack(true);
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.setPriority(10);
        job.schedule();
    }

    protected void projectChanged(IProject oldProject, IProject newProject) {
        GitRepository oldRepo = this.getGitRepositoryManager().getAttached(oldProject);
        if (oldRepo != null) {
            oldRepo.removeListener((IGitRepositoryListener)this);
        }
        super.projectChanged(oldProject, newProject);
        if (this.fChangedFilesFilterProjects.contains(newProject)) {
            this.addGitChangedFilesFilter();
        } else {
            this.removeFilter();
        }
        GitRepository repo = this.getGitRepositoryManager().getAttached(newProject);
        this.refreshUI(repo);
        if (repo != null) {
            repo.addListener((IGitRepositoryListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateBranches(GitRepository repo, IProgressMonitor monitor) throws CoreException {
        String currentBranchName;
        if (monitor != null && monitor.isCanceled()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        MenuItem[] menuItems = this.branchesMenu.getItems();
        MenuItem[] menuItemArray = menuItems;
        int n = menuItems.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = menuItemArray[n2];
            menuItem.dispose();
            ++n2;
        }
        this.branchesToolItem.setText("");
        if (repo == null) {
            return;
        }
        if (monitor != null && monitor.isCanceled()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        String tooltip = currentBranchName = repo.currentBranch();
        for (String branchName : repo.localBranches()) {
            final MenuItem branchNameMenuItem = new MenuItem(this.branchesMenu, 16);
            String modifiedBranchName = branchName;
            if (branchName.equals(currentBranchName) && repo.isDirty()) {
                modifiedBranchName = String.valueOf(modifiedBranchName) + DIRTY_SUFFIX;
                tooltip = String.valueOf(tooltip) + Messages.GitProjectView_BranchDirtyTooltipMessage;
            }
            HashMap<String, Boolean> hashMap = this.branchToPullIndicator;
            synchronized (hashMap) {
                if (this.branchToPullIndicator.containsKey(branchName) && this.branchToPullIndicator.get(branchName).booleanValue()) {
                    modifiedBranchName = String.valueOf(modifiedBranchName) + " " + this.getLeftArrowChar();
                    if (branchName.equals(currentBranchName)) {
                        tooltip = String.valueOf(tooltip) + Messages.GitProjectView_PullChangesTooltipMessage;
                    }
                }
            }
            String[] ahead = repo.commitsAhead(branchName);
            if (ahead != null && ahead.length > 0) {
                modifiedBranchName = String.valueOf(modifiedBranchName) + " " + this.getRightArrowChar();
                if (branchName.equals(currentBranchName)) {
                    tooltip = String.valueOf(tooltip) + Messages.GitProjectView_PushChangesTooltipMessage;
                }
            }
            branchNameMenuItem.setText(modifiedBranchName);
            branchNameMenuItem.setSelection(branchName.equals(currentBranchName));
            branchNameMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GitProjectView.this.setNewBranch(branchNameMenuItem.getText());
                }
            });
            if (!branchName.equals(currentBranchName)) continue;
            if (modifiedBranchName.length() > 20) {
                if (!currentBranchName.equals(modifiedBranchName)) {
                    currentBranchName = String.valueOf(currentBranchName.substring(0, 15)) + "..." + modifiedBranchName.substring(currentBranchName.length());
                    continue;
                }
                currentBranchName = String.valueOf(currentBranchName.substring(0, 15)) + "...";
                continue;
            }
            currentBranchName = modifiedBranchName;
        }
        if (monitor != null && monitor.isCanceled()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        new MenuItem(this.branchesMenu, 2);
        final MenuItem branchNameMenuItem = new MenuItem(this.branchesMenu, 8);
        branchNameMenuItem.setText(CREATE_NEW_BRANCH_TEXT);
        branchNameMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitProjectView.this.setNewBranch(branchNameMenuItem.getText());
            }
        });
        this.branchesToolItem.setText(currentBranchName);
        if (tooltip != null) {
            this.branchesToolItem.setToolTipText(tooltip);
        }
        this.branchesToolbar.pack();
    }

    private String getRightArrowChar() {
        if (Platform.getOS().equals("macosx")) {
            return "\u2192";
        }
        return "->";
    }

    private String getLeftArrowChar() {
        if (Platform.getOS().equals("macosx")) {
            return "\u2190";
        }
        return "<-";
    }

    public void indexChanged(IndexChangedEvent e) {
    }

    public void pulled(PullEvent e) {
        if (this.isCurrentProjectsRepository(e.getRepository())) {
            this.pullCalc.cancel();
            this.pullCalc.schedule();
        }
    }

    public void pushed(PushEvent e) {
        this.handleBranchEvent(e.getRepository());
    }

    private void refreshUI(final GitRepository repository) {
        if (this.refreshUIJob != null) {
            this.refreshUIJob.cancel();
        }
        this.refreshUIJob = new UIJob("update UI for index changes"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (monitor != null && monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    GitProjectView.this.populateBranches(repository, monitor);
                    if (monitor != null && monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (repository == null) {
                        RowData rd = new RowData();
                        rd.exclude = true;
                        GitProjectView.this.branchesToolbar.getParent().setLayoutData((Object)rd);
                        GitProjectView.this.branchesToolbar.getParent().setVisible(false);
                    } else {
                        RowData rd = new RowData();
                        rd.exclude = false;
                        GitProjectView.this.branchesToolbar.getParent().setLayoutData((Object)rd);
                        GitProjectView.this.branchesToolbar.getParent().setVisible(true);
                    }
                    if (monitor != null && monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    GitProjectView.this.branchesToolbar.getParent().getParent().layout(true, true);
                    GitProjectView.this.refreshViewer();
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    ExplorerPlugin.logError(e);
                    return e.getStatus();
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)ExplorerPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
                    return new Status(4, "com.aptana.explorer", e.getMessage(), (Throwable)e);
                }
            }
        };
        EclipseUtil.setSystemForJob((Job)this.refreshUIJob);
        this.refreshUIJob.setPriority(10);
        this.refreshUIJob.schedule(100L);
    }

    public void repositoryAdded(RepositoryAddedEvent e) {
        IProject changed = e.getProject();
        if (changed != null && changed.equals((Object)this.selectedProject)) {
            this.refreshUI(e.getRepository());
            e.getRepository().addListener((IGitRepositoryListener)this);
        }
    }

    public void branchChanged(BranchChangedEvent e) {
        this.handleBranchEvent(e.getRepository());
    }

    public void branchAdded(BranchAddedEvent e) {
        this.handleBranchEvent(e.getRepository());
    }

    public void branchRemoved(BranchRemovedEvent e) {
        this.handleBranchEvent(e.getRepository());
    }

    private void handleBranchEvent(GitRepository repo) {
        if (this.isCurrentProjectsRepository(repo)) {
            this.refreshUI(repo);
        }
    }

    private boolean isCurrentProjectsRepository(GitRepository repo) {
        GitRepository selectedRepo = this.getGitRepositoryManager().getAttached(this.selectedProject);
        return selectedRepo != null && selectedRepo.equals((Object)repo);
    }

    public void repositoryRemoved(RepositoryRemovedEvent e) {
        IProject changed = e.getProject();
        if (changed != null && changed.equals((Object)this.selectedProject)) {
            e.getRepository().removeListener((IGitRepositoryListener)this);
            this.refreshUI(null);
        }
    }

    private void addGitChangedFilesFilter() {
        this.removeFilter();
        this.fChangedFilesFilter = new GitChangedFilesFilter();
        this.getCommonViewer().addFilter((ViewerFilter)this.fChangedFilesFilter);
        this.getCommonViewer().expandAll();
        this.showFilterLabel(ExplorerPlugin.getImage(CHANGED_FILE_FILTER_ICON_PATH), Messages.GitProjectView_ChangedFilesFilterTooltip);
        this.fChangedFilesFilterProjects.add(this.selectedProject);
    }

    public void saveState(IMemento aMemento) {
        StringBuilder text = new StringBuilder();
        for (IProject project : this.fChangedFilesFilterProjects) {
            text.append(project.getName()).append(PROJECT_DELIMITER);
        }
        int length = text.length();
        if (length > 0) {
            text.delete(length - PROJECT_DELIMITER.length(), length);
        }
        aMemento.putString(GIT_CHANGED_FILES_FILTER, text.toString());
        super.saveState(aMemento);
    }

    public void init(IViewSite aSite, IMemento aMemento) throws PartInitException {
        String filteredProjects;
        super.init(aSite, aMemento);
        this.memento = aMemento;
        if (this.memento != null && (filteredProjects = this.memento.getString(GIT_CHANGED_FILES_FILTER)) != null && filteredProjects.length() > 0) {
            String[] projectNames = filteredProjects.split(PROJECT_DELIMITER);
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            String[] stringArray = projectNames;
            int n = projectNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                try {
                    IProject project = workspaceRoot.getProject(name);
                    if (project.exists()) {
                        this.fChangedFilesFilterProjects.add(project);
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)ExplorerPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
                }
                ++n2;
            }
        }
    }

    protected void mangleContextMenu(Menu menu) {
        GitRepository repo = this.getGitRepositoryManager().getAttached(this.selectedProject);
        if (repo != null || this.selectedProject == null || !this.selectedProject.isAccessible()) {
            HashSet<String> toRemove = new HashSet<String>();
            toRemove.add(TEAM_MAIN);
            this.removeMenuItems(menu, toRemove);
        } else {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)this.selectedProject);
            if (provider == null) {
                MenuItem[] menuItems = menu.getItems();
                int i = 0;
                while (i < menuItems.length) {
                    IContributionItem contrib;
                    MenuItem menuItem = menuItems[i];
                    Object data = menuItem.getData();
                    if (data instanceof IContributionItem && TEAM_MAIN.equals((contrib = (IContributionItem)data).getId())) {
                        this.addAttachItem(menu, i + 1);
                        break;
                    }
                    ++i;
                }
                HashSet<String> toRemove = new HashSet<String>();
                toRemove.add(TEAM_MAIN);
                this.removeMenuItems(menu, toRemove);
            }
        }
        super.mangleContextMenu(menu);
    }

    private void addAttachItem(Menu menu, int index) {
        String commandId = "com.aptana.git.ui.command.attach";
        MenuItem customizeMenuItem = new MenuItem(menu, 8, index);
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command c = commandService.getCommand("com.aptana.git.ui.command.attach");
        try {
            customizeMenuItem.setText(c.getName());
        }
        catch (NotDefinedException notDefinedException) {
            // empty catch block
        }
        customizeMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("com.aptana.git.ui.command.attach", null);
                }
                catch (ExecutionException executionException) {
                }
                catch (NotDefinedException notDefinedException) {
                }
                catch (NotEnabledException notEnabledException) {
                }
                catch (NotHandledException notHandledException) {
                    // empty catch block
                }
            }
        });
    }

    private IGitRepositoryManager getGitRepositoryManager() {
        return GitPlugin.getDefault().getGitRepositoryManager();
    }

    public void toggleChangedFilesFilter() {
        if (this.fChangedFilesFilter == null) {
            this.addGitChangedFilesFilter();
        } else {
            this.removeFilter();
        }
    }
}

