/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.explorer.navigator.actions;

import com.aptana.explorer.ExplorerPlugin;
import com.aptana.explorer.internal.ui.Messages;
import com.aptana.explorer.navigator.actions.ExplorerActionProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.DeleteResourceAction;

public class CommandsActionProvider
extends ExplorerActionProvider {
    public static final String ID = "com.aptana.explorer.navigator.actions.CommandsActions";

    public String getActionId() {
        return ID;
    }

    protected Image getImage() {
        return ExplorerPlugin.getImage("icons/full/elcl16/config.png");
    }

    protected Image getHotImage() {
        return ExplorerPlugin.getImage("icons/full/elcl16/config_hot.png");
    }

    protected String getMenuId() {
        return "com.aptana.explorer.gear";
    }

    protected String getToolTip() {
        return Messages.CommandsActionProvider_TTP_Commands;
    }

    protected void fillMenu(MenuManager menuManager) {
        IContributionItem item = menuManager.find("group.properties");
        if (item == null) {
            menuManager.add((IContributionItem)new GroupMarker("group.properties"));
        }
        menuManager.appendToGroup("group.properties", (IContributionItem)new ContributionItem(){

            public void fill(Menu menu, int index) {
                final IProject selectedProject = CommandsActionProvider.this.getSelectedProject();
                MenuItem item = new MenuItem(menu, 8);
                item.setText(Messages.SingleProjectView_DeleteProjectMenuItem_LBL);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        DeleteResourceAction action = new DeleteResourceAction((IShellProvider)CommandsActionProvider.this.getPartSite());
                        action.selectionChanged((IStructuredSelection)new StructuredSelection((Object)selectedProject));
                        action.run();
                    }
                });
                boolean enabled = selectedProject != null && selectedProject.exists();
                ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
                item.setImage(enabled ? images.getImage("IMG_TOOL_DELETE") : images.getImage("IMG_TOOL_DELETE_DISABLED"));
                item.setEnabled(enabled);
            }

            public boolean isDynamic() {
                return true;
            }
        });
    }
}

