/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.internal.ui;

import com.aptana.core.logging.IdeLog;
import com.aptana.deploy.IDeployProvider;
import com.aptana.deploy.internal.ui.Messages;
import com.aptana.deploy.ui.DeployUIPlugin;
import com.aptana.deploy.util.DeployProviderUtil;
import com.aptana.ui.util.UIUtils;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class DeployAppContributionItem
extends ContributionItem
implements IWorkbenchContribution {
    private static final String DEPLOY_COMMAND_ID = "com.aptana.deploy.commands.deployApp";
    private IServiceLocator serviceLocator;

    public DeployAppContributionItem() {
    }

    public DeployAppContributionItem(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        IDeployProvider provider;
        MenuItem deployMenuItem = new MenuItem(menu, 8);
        String menuName = null;
        IContainer selectedContainer = DeployAppContributionItem.getSelectedContainer();
        if (selectedContainer != null && (provider = DeployProviderUtil.getDeployProvider((IContainer)selectedContainer)) != null) {
            menuName = provider.getDeployMenuName();
        }
        if (menuName == null) {
            ICommandService commandService = (ICommandService)this.serviceLocator.getService(ICommandService.class);
            Command command = commandService.getCommand(DEPLOY_COMMAND_ID);
            try {
                menuName = command.getName();
            }
            catch (NotDefinedException e) {
                IdeLog.logError((Plugin)DeployUIPlugin.getDefault(), (String)"The name for the deploy command is not defined.");
            }
        }
        deployMenuItem.setText(menuName == null ? Messages.DeployAppContributionItem_Text : menuName);
        deployMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IHandlerService handlerService = (IHandlerService)DeployAppContributionItem.this.serviceLocator.getService(IHandlerService.class);
                try {
                    handlerService.executeCommand(DeployAppContributionItem.DEPLOY_COMMAND_ID, null);
                }
                catch (Exception e1) {
                    IdeLog.logError((Plugin)DeployUIPlugin.getDefault(), (String)"Failed to execute the command to deploy the application.");
                }
            }
        });
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    private static IContainer getSelectedContainer() {
        IResource selectedResource = UIUtils.getSelectedResource();
        if (selectedResource instanceof IContainer) {
            return (IContainer)selectedResource;
        }
        if (selectedResource != null) {
            return selectedResource.getParent();
        }
        return null;
    }
}

