/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.internal.ui.handlers;

import com.aptana.deploy.IDeployProvider;
import com.aptana.deploy.internal.ui.handlers.Messages;
import com.aptana.deploy.preferences.DeployPreferenceUtil;
import com.aptana.deploy.util.DeployProviderUtil;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.progress.UIJob;

public class DeployHandler
extends AbstractHandler {
    private IContainer selectedContainer;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IContainer container = this.selectedContainer;
        final IDeployProvider provider = DeployProviderUtil.getDeployProvider((IContainer)this.selectedContainer);
        if (provider != null) {
            UIJob job = new UIJob(Messages.DeployHandler_DeployJobTitle){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    provider.deploy(container, monitor);
                    DeployPreferenceUtil.setDeployType((IContainer)container, (String)DeployProviderUtil.getIdForProvider((IDeployProvider)provider));
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.setPriority(20);
            job.schedule();
        }
        return null;
    }

    public boolean isEnabled() {
        return this.selectedContainer != null && this.selectedContainer.isAccessible();
    }

    public void setEnabled(Object evaluationContext) {
        this.selectedContainer = null;
        if (evaluationContext instanceof IEvaluationContext) {
            Object activePart = ((IEvaluationContext)evaluationContext).getVariable("activePart");
            if (activePart instanceof IEditorPart) {
                IEditorInput editorInput = ((IEditorPart)activePart).getEditorInput();
                if (editorInput instanceof IFileEditorInput) {
                    this.selectedContainer = ((IFileEditorInput)editorInput).getFile().getParent();
                }
            } else {
                ISelection selections;
                Object value = ((IEvaluationContext)evaluationContext).getVariable("selection");
                if (value instanceof ISelection && !(selections = (ISelection)value).isEmpty() && selections instanceof IStructuredSelection) {
                    IResource resource;
                    Object selection = ((IStructuredSelection)selections).getFirstElement();
                    if (selection instanceof IContainer) {
                        this.selectedContainer = (IContainer)selection;
                    } else if (selection instanceof IAdaptable && (resource = (IResource)((IAdaptable)selection).getAdapter(IResource.class)) != null) {
                        this.selectedContainer = resource.getParent();
                    }
                }
            }
        }
    }
}

