/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.css.core.internal.build.properties;

import com.aptana.css.core.internal.build.properties.CustomCSSProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;

public abstract class CSSFixedSetProperty
extends CustomCSSProperty {
    private final int valueIndex;
    private final String[] values;

    protected CSSFixedSetProperty(String propertyName, String[] values) {
        super(propertyName);
        this.values = values;
        this.valueIndex = 0;
    }

    protected CSSFixedSetProperty(String propertyName, String[] values, ApplContext context, CssExpression expression, boolean check) throws InvalidParamException {
        super(propertyName);
        this.values = values;
        if (check && expression.getCount() != 1) {
            throw new InvalidParamException("unrecognize", context);
        }
        this.setByUser();
        CssValue val = expression.getValue();
        if (val instanceof CssIdent && val.get() instanceof String) {
            this.valueIndex = this.getIndex((String)val.get());
            if (this.valueIndex == -1) {
                throw new InvalidParamException("value", (Object)val.toString(), (Object)this.getPropertyNameNoMinus(), context);
            }
        } else {
            throw new InvalidParamException("value", (Object)val.toString(), (Object)this.getPropertyNameNoMinus(), context);
        }
        expression.next();
    }

    protected CSSFixedSetProperty(String propertyName, String[] values, ApplContext context, CssExpression expression) throws InvalidParamException {
        this(propertyName, values, context, expression, false);
    }

    public Object get() {
        return this.values[this.valueIndex];
    }

    public boolean isDefault() {
        return this.valueIndex == 0;
    }

    private int getIndex(String value) {
        if (value == null) {
            return -1;
        }
        int i = 0;
        while (i < this.values.length) {
            if (value.equals(this.values[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

