/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.css.core.internal.index;

import com.aptana.core.util.StringUtil;
import com.aptana.css.core.model.ElementElement;
import com.aptana.css.core.model.PropertyElement;
import com.aptana.css.core.model.PseudoClassElement;
import com.aptana.css.core.model.PseudoElementElement;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexReader;
import com.aptana.index.core.QueryResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSIndexReader
extends IndexReader {
    private static final String WILD_CARD_CHAR = "*";

    private ElementElement createElement(QueryResult element) {
        return (ElementElement)this.populateElement(new ElementElement(), element, 1);
    }

    private PropertyElement createProperty(QueryResult property) {
        return (PropertyElement)this.populateElement(new PropertyElement(), property, 1);
    }

    private PseudoClassElement createPseudoClass(QueryResult pseudoClass) {
        return (PseudoClassElement)this.populateElement(new PseudoClassElement(), pseudoClass);
    }

    private PseudoElementElement createPseudoElement(QueryResult pseudoElement) {
        return (PseudoElementElement)this.populateElement(new PseudoElementElement(), pseudoElement);
    }

    protected String getDelimiter() {
        return "\u0000";
    }

    public List<ElementElement> getElements(Index index) throws IOException {
        List items;
        ArrayList<ElementElement> result = new ArrayList<ElementElement>();
        if (index != null && (items = index.query(new String[]{"css.element"}, WILD_CARD_CHAR, 2)) != null) {
            for (QueryResult element : items) {
                result.add(this.createElement(element));
            }
        }
        return result;
    }

    public List<ElementElement> getElements(Index index, String ... names) throws IOException {
        ArrayList<ElementElement> result = new ArrayList<ElementElement>();
        if (index != null && names != null) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                List elements = index.query(new String[]{"css.element"}, String.valueOf(name) + "\u0000", 1);
                if (elements != null) {
                    for (QueryResult element : elements) {
                        result.add(this.createElement(element));
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    public List<PropertyElement> getProperties(Index index) throws IOException {
        List properties;
        ArrayList<PropertyElement> result = new ArrayList<PropertyElement>();
        if (index != null && (properties = index.query(new String[]{"css.property"}, WILD_CARD_CHAR, 2)) != null) {
            for (QueryResult property : properties) {
                result.add(this.createProperty(property));
            }
        }
        return result;
    }

    public List<PropertyElement> getProperties(Index index, String ... names) throws IOException {
        ArrayList<PropertyElement> result = new ArrayList<PropertyElement>();
        if (index != null && names != null) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                List properties = index.query(new String[]{"css.property"}, String.valueOf(name) + "\u0000", 1);
                if (properties != null) {
                    for (QueryResult property : properties) {
                        result.add(this.createProperty(property));
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    public List<PseudoClassElement> getPseudoClasses(Index index) throws IOException {
        List pseudoClasses;
        ArrayList<PseudoClassElement> result = new ArrayList<PseudoClassElement>();
        if (index != null && (pseudoClasses = index.query(new String[]{"css.pseudo_class"}, WILD_CARD_CHAR, 2)) != null) {
            for (QueryResult pseudoClass : pseudoClasses) {
                result.add(this.createPseudoClass(pseudoClass));
            }
        }
        return result;
    }

    public List<PseudoElementElement> getPseudoElements(Index index) throws IOException {
        List pseudoElements;
        ArrayList<PseudoElementElement> result = new ArrayList<PseudoElementElement>();
        if (index != null && (pseudoElements = index.query(new String[]{"css.pseudo_element"}, WILD_CARD_CHAR, 2)) != null) {
            for (QueryResult pseudoElement : pseudoElements) {
                result.add(this.createPseudoElement(pseudoElement));
            }
        }
        return result;
    }

    protected String getSubDelimiter() {
        return ",";
    }

    public Map<String, String> getValues(Index index, String category) {
        String pattern;
        List items;
        HashMap<String, String> result = null;
        if (index != null && !StringUtil.isEmpty((String)category) && (items = index.query(new String[]{category}, pattern = WILD_CARD_CHAR, 2)) != null && items.size() > 0) {
            result = new HashMap<String, String>();
            for (QueryResult item : items) {
                Set paths = item.getDocuments();
                String path = paths != null && !paths.isEmpty() ? (String)paths.iterator().next() : "";
                result.put(item.getWord(), path);
            }
        }
        return result;
    }
}

