/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.css.core.model;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ObjectUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.css.core.model.BaseElement;
import com.aptana.css.core.model.SpecificationElement;
import com.aptana.css.core.model.ValueElement;
import com.aptana.index.core.IndexUtil;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyElement
extends BaseElement {
    private static final String SPECIFICATIONS_PROPERTY = "specifications";
    private static final String VALUES_PROPERTY = "values";
    private static final String ALLOW_MULTIPLE_VALUES_PROPERTY = "allowMultipleValues";
    private static final String HINT_PROPERTY = "hint";
    private static final String REMARK_PROPERTY = "remark";
    private static final String TYPE_PROPERTY = "type";
    private boolean _allowMultipleValues;
    private String _type;
    private List<SpecificationElement> _specifications;
    private String _hint;
    private String _remark;
    private List<ValueElement> _values;

    public void addSpecification(SpecificationElement specification) {
        if (specification != null) {
            if (this._specifications == null) {
                this._specifications = new ArrayList<SpecificationElement>();
            }
            this._specifications.add(specification);
        }
    }

    public void addValue(ValueElement value) {
        if (value != null) {
            if (this._values == null) {
                this._values = new ArrayList<ValueElement>();
            }
            this._values.add(value);
        }
    }

    public boolean allowMultipleValues() {
        return this._allowMultipleValues;
    }

    @Override
    public void fromJSON(Map object) {
        super.fromJSON(object);
        this.setType(StringUtil.getStringValue(object.get(TYPE_PROPERTY)));
        this.setRemark(StringUtil.getStringValue(object.get(REMARK_PROPERTY)));
        this.setHint(StringUtil.getStringValue(object.get(HINT_PROPERTY)));
        this.setAllowMultipleValues(Boolean.TRUE == object.get(ALLOW_MULTIPLE_VALUES_PROPERTY));
        this._values = IndexUtil.createList(object.get(VALUES_PROPERTY), ValueElement.class);
        this._specifications = IndexUtil.createList(object.get(SPECIFICATIONS_PROPERTY), SpecificationElement.class);
    }

    public String getHint() {
        return StringUtil.getStringValue((Object)this._hint);
    }

    public String getRemark() {
        return StringUtil.getStringValue((Object)this._remark);
    }

    public List<SpecificationElement> getSpecifications() {
        return CollectionsUtil.getListValue(this._specifications);
    }

    public String getType() {
        return StringUtil.getStringValue((Object)this._type);
    }

    public List<ValueElement> getValues() {
        return CollectionsUtil.getListValue(this._values);
    }

    public void setAllowMultipleValues(Boolean value) {
        this._allowMultipleValues = value;
    }

    public void setHint(String hint) {
        this._hint = hint;
    }

    public void setRemark(String remark) {
        this._remark = remark;
    }

    public void setType(String type) {
        this._type = type;
    }

    @Override
    public void toJSON(JSON.Output out) {
        super.toJSON(out);
        out.add(TYPE_PROPERTY, (Object)this.getType());
        out.add(REMARK_PROPERTY, (Object)this.getRemark());
        out.add(HINT_PROPERTY, (Object)this.getHint());
        out.add(ALLOW_MULTIPLE_VALUES_PROPERTY, this.allowMultipleValues());
        out.add(VALUES_PROPERTY, this.getValues());
        out.add(SPECIFICATIONS_PROPERTY, this.getSpecifications());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PropertyElement)) {
            return false;
        }
        PropertyElement other = (PropertyElement)obj;
        return ObjectUtil.areEqual((Object)this.getName(), (Object)other.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

