/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.css.core.parsing.ast;

import com.aptana.core.util.StringUtil;
import com.aptana.css.core.parsing.ast.CSSDeclarationNode;
import com.aptana.css.core.parsing.ast.CSSNode;
import com.aptana.css.core.parsing.ast.CSSSelectorNode;
import com.aptana.css.core.parsing.ast.CSSTreeWalker;
import com.aptana.parsing.ast.IParseNode;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSRuleNode
extends CSSNode {
    private static final CSSDeclarationNode[] NO_DECLARATIONS = new CSSDeclarationNode[0];
    private CSSSelectorNode[] fSelectors;
    private CSSDeclarationNode[] fDeclarations;

    public CSSRuleNode(List<CSSSelectorNode> selectors) {
        this(selectors, null);
    }

    public CSSRuleNode(List<CSSSelectorNode> selectors, List<CSSDeclarationNode> declarations) {
        this.fSelectors = selectors.toArray(new CSSSelectorNode[selectors.size()]);
        this.fDeclarations = declarations != null ? declarations.toArray(new CSSDeclarationNode[declarations.size()]) : NO_DECLARATIONS;
    }

    @Override
    public short getNodeType() {
        return 6;
    }

    @Override
    public void accept(CSSTreeWalker walker) {
        walker.visit(this);
    }

    public void addOffset(int offset) {
        CSSNode node;
        super.addOffset(offset);
        CSSNode[] cSSNodeArray = this.fSelectors;
        int n = this.fSelectors.length;
        int n2 = 0;
        while (n2 < n) {
            node = cSSNodeArray[n2];
            node.addOffset(offset);
            ++n2;
        }
        cSSNodeArray = this.fDeclarations;
        n = this.fDeclarations.length;
        n2 = 0;
        while (n2 < n) {
            node = cSSNodeArray[n2];
            node.addOffset(offset);
            ++n2;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CSSRuleNode) || !super.equals(obj)) {
            return false;
        }
        CSSRuleNode other = (CSSRuleNode)((Object)obj);
        if (this.fDeclarations.length != other.fDeclarations.length) {
            return false;
        }
        if (this.fSelectors.length != other.fSelectors.length) {
            return false;
        }
        int i = 0;
        while (i < this.fSelectors.length) {
            if (this.fSelectors[i].getNodeType() != other.fSelectors[i].getNodeType()) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.fDeclarations.length) {
            if (this.fDeclarations[i].getNodeType() != other.fDeclarations[i].getNodeType()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public CSSDeclarationNode[] getDeclarations() {
        return this.fDeclarations;
    }

    public IParseNode getNodeAtOffset(int offset) {
        int n;
        int n2;
        CSSNode[] cSSNodeArray;
        IParseNode result = super.getNodeAtOffset(offset);
        if (result == this) {
            cSSNodeArray = this.fSelectors;
            n2 = this.fSelectors.length;
            n = 0;
            while (n < n2) {
                CSSNode selector = cSSNodeArray[n];
                if (selector.contains(offset)) {
                    result = selector.getNodeAtOffset(offset);
                    break;
                }
                ++n;
            }
        }
        if (result == this) {
            cSSNodeArray = this.fDeclarations;
            n2 = this.fDeclarations.length;
            n = 0;
            while (n < n2) {
                CSSNode declaration = cSSNodeArray[n];
                if (declaration.contains(offset)) {
                    result = declaration.getNodeAtOffset(offset);
                    break;
                }
                ++n;
            }
        }
        return result;
    }

    public CSSSelectorNode[] getSelectors() {
        return this.fSelectors;
    }

    public int hashCode() {
        CSSNode node;
        int hash = super.hashCode();
        CSSNode[] cSSNodeArray = this.fSelectors;
        int n = this.fSelectors.length;
        int n2 = 0;
        while (n2 < n) {
            node = cSSNodeArray[n2];
            hash = hash * 31 + node.hashCode();
            ++n2;
        }
        cSSNodeArray = this.fDeclarations;
        n = this.fDeclarations.length;
        n2 = 0;
        while (n2 < n) {
            node = cSSNodeArray[n2];
            hash = hash * 31 + ((CSSDeclarationNode)node).hashCode();
            ++n2;
        }
        return hash;
    }

    public String toString() {
        CSSSelectorNode[] selectors;
        StringBuilder text = new StringBuilder();
        CSSSelectorNode[] cSSSelectorNodeArray = selectors = this.getSelectors();
        int n = selectors.length;
        int n2 = 0;
        while (n2 < n) {
            CSSSelectorNode selector = cSSSelectorNodeArray[n2];
            text.append((Object)selector);
            String combinator = selector.getCombinator();
            if (!StringUtil.isEmpty((String)combinator)) {
                if (!",".equals(combinator)) {
                    text.append(' ');
                }
                text.append(combinator).append(' ');
            }
            ++n2;
        }
        CSSDeclarationNode[] declarations = this.getDeclarations();
        text.append(" {");
        int i = 0;
        while (i < declarations.length) {
            text.append((Object)declarations[i]);
            if (i < declarations.length - 1) {
                text.append(' ');
            }
            ++i;
        }
        text.append('}');
        return text.toString();
    }
}

