/*
 * Decompiled with CFR 0.152.
 */
package beaver.comp.util;

import beaver.Scanner;
import beaver.Symbol;
import beaver.comp.io.SrcReader;
import java.io.PrintStream;

public class Log {
    private Record.List errors = new Record.List();
    private Record.List warnings = new Record.List();
    private Record.List messages = new Record.List();

    public void error(Symbol symbol, String msg) {
        this.error(symbol.getStart(), symbol.getEnd(), msg);
    }

    public void error(Scanner.Exception e) {
        int location = Symbol.makePosition(e.line, e.column);
        this.error(location, location, e.getMessage());
    }

    public void error(int start_pos, int end_pos, String msg) {
        this.errors.add(new Record(start_pos, end_pos, msg));
    }

    public void error(String msg) {
        this.error(0, 0, msg);
    }

    public void warning(Symbol symbol, String msg) {
        this.warning(symbol.getStart(), symbol.getEnd(), msg);
    }

    public void warning(int start_pos, int end_pos, String msg) {
        this.warnings.add(new Record(start_pos, end_pos, msg));
    }

    public void warning(String msg) {
        this.warning(0, 0, msg);
    }

    public void message(String msg) {
        this.messages.add(new Record(0, 0, msg));
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public void report(String src_name, SrcReader src_reader) {
        int n_err = this.errors.size();
        int n_warn = this.warnings.size();
        if (n_err > 0 || n_warn > 0) {
            PrintStream out = System.err;
            Record rec = this.errors.start();
            while (rec != null) {
                rec.report("Error", out, src_reader);
                rec = rec.next;
            }
            this.errors.reset();
            rec = this.warnings.start();
            while (rec != null) {
                rec.report("Warning", out, src_reader);
                rec = rec.next;
            }
            this.warnings.reset();
            if (n_err > 0 || n_warn > 0) {
                out.print(src_name);
                out.print(": ");
                out.print(n_err);
                out.print(" error");
                if (n_err != 1) {
                    out.print('s');
                }
                out.print(", ");
                out.print(n_warn);
                out.print(" warning");
                if (n_warn != 1) {
                    out.print('s');
                }
                out.println('.');
            }
        }
        Record rec = this.messages.start();
        while (rec != null) {
            rec.report(null, System.out, src_reader);
            rec = rec.next;
        }
        this.messages.reset();
    }

    public static class Record {
        Record next;
        private final int start_pos;
        private final int end_pos;
        private final String message;

        Record(int start, int end, String msg) {
            this.start_pos = start;
            this.end_pos = end;
            this.message = msg;
        }

        public void report(String type, PrintStream out, SrcReader src_reader) {
            int end_line;
            int start_line;
            out.print(src_reader.file.getName());
            out.print(':');
            if (this.start_pos > 0) {
                out.print(Symbol.getLine(this.start_pos));
                out.print(',');
                out.print(Symbol.getColumn(this.start_pos));
                out.print('-');
                out.print(Symbol.getLine(this.end_pos));
                out.print(',');
                out.print(Symbol.getColumn(this.end_pos));
                out.print(':');
            }
            if (type != null) {
                out.print(' ');
                out.print(type);
                out.print(':');
            }
            out.print(' ');
            out.println(this.message);
            if (this.start_pos > 0 && (start_line = Symbol.getLine(this.start_pos)) == (end_line = Symbol.getLine(this.end_pos))) {
                String line = src_reader.getLine(start_line).replace('\t', ' ');
                out.print(line);
                int start_column = Symbol.getColumn(this.start_pos);
                int n = start_column - 1;
                while (n > 0) {
                    out.print(' ');
                    --n;
                }
                out.print('^');
                n = Symbol.getColumn(this.end_pos) - start_column - 1;
                while (n > 0) {
                    out.print('-');
                    --n;
                }
                if (n == 0) {
                    out.print('^');
                }
                out.println();
            }
        }

        public static class List {
            private Record first;
            private Record last;
            private int size;

            public void add(Record rec) {
                if (this.last == null) {
                    this.first = this.last = rec;
                } else {
                    this.last = this.last.next = rec;
                }
                ++this.size;
            }

            public Record start() {
                return this.first;
            }

            public int size() {
                return this.size;
            }

            public void reset() {
                this.last = null;
                this.first = null;
                this.size = 0;
            }
        }
    }
}

