/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.hover;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.IOUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.replace.SimpleTextPatternReplacer;
import com.aptana.editor.common.hover.AbstractCommonTextHover;
import com.aptana.editor.common.hover.CustomBrowserInformationControl;
import com.aptana.editor.common.hover.DocumentationBrowserInformationControlInput;
import com.aptana.ui.epl.UIEplPlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.editors.text.EditorsUI;
import org.osgi.framework.Bundle;

public abstract class AbstractDocumentationHover
extends AbstractCommonTextHover {
    private static final String DOCUMENTATION_STYLE_CSS = "/documentationStyle.css";
    private static final String DEFAULT_BORDER_COLOR = "#BEBEBE";
    protected static final String BORDER_COLOR_CSS_TEXT = "BorderColor";
    private static String styleSheet;
    private static final SimpleTextPatternReplacer TAG_MAPPER;
    protected IInformationControlCreator fHoverControlCreator;
    protected IInformationControlCreator fPresenterControlCreator;
    private String cssPath;

    static {
        TAG_MAPPER = new SimpleTextPatternReplacer();
        TAG_MAPPER.addPattern("<b>");
        TAG_MAPPER.addPattern("</b>");
        TAG_MAPPER.addPattern("<p>", "\n");
        TAG_MAPPER.addPattern("</p>", "\n");
        TAG_MAPPER.addPattern("<br>", "\n");
        TAG_MAPPER.addPattern("</br>", "\n");
        TAG_MAPPER.addPattern("&lt", "<");
        TAG_MAPPER.addPattern("&gt", ">");
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new PresenterControlCreator(this);
        }
        return this.fPresenterControlCreator;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new HoverControlCreator(this.getInformationPresenterControlCreator());
        }
        return this.fHoverControlCreator;
    }

    public static String stripBasicHTML(String content) {
        return TAG_MAPPER.searchAndReplace(content);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        Object info2 = this.getHoverInfo2(textViewer, hoverRegion);
        if (info2 == null) {
            return null;
        }
        if (info2 instanceof DocumentationBrowserInformationControlInput) {
            return ((DocumentationBrowserInformationControlInput)((Object)info2)).getHtml();
        }
        return info2.toString();
    }

    public abstract String getHeader(Object var1, IEditorPart var2, IRegion var3);

    public abstract String getDocumentation(Object var1, IEditorPart var2, IRegion var3);

    protected Color getBackgroundColor() {
        return null;
    }

    protected Color getForegroundColor() {
        return null;
    }

    protected Color getBorderColor() {
        return null;
    }

    public abstract void populateToolbarActions(ToolBarManager var1, CustomBrowserInformationControl var2);

    protected void installLinkListener(CustomBrowserInformationControl control) {
        control.addLocationListener((LocationListener)new CommonLocationListener(control));
    }

    protected DocumentationBrowserInformationControlInput getHoverInfo(Object element, boolean useHTMLTags, DocumentationBrowserInformationControlInput previousInput, IEditorPart editorPart, IRegion hoverRegion) {
        if (element == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        String base = null;
        int leadingImageWidth = 0;
        this.setHeader(this.getHeader(element, editorPart, hoverRegion), buffer, useHTMLTags);
        this.setDocumentation(this.getDocumentation(element, editorPart, hoverRegion), buffer, useHTMLTags);
        if (buffer.length() > 0) {
            if (useHTMLTags) {
                Color borderColor = this.getBorderColor();
                Color bgColor = this.getBackgroundColor();
                Color fgColor = this.getForegroundColor();
                String borderColorHex = borderColor != null ? AbstractDocumentationHover.getHexColor(borderColor.getRGB()) : DEFAULT_BORDER_COLOR;
                RGB bgRGB = bgColor != null ? bgColor.getRGB() : null;
                RGB fgRGB = fgColor != null ? fgColor.getRGB() : null;
                String styleSheet = this.getStyleSheet();
                styleSheet = styleSheet.replaceAll(BORDER_COLOR_CSS_TEXT, borderColorHex);
                HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (RGB)fgRGB, (RGB)bgRGB, (String)styleSheet);
                if (base != null) {
                    int endHeadIdx = buffer.indexOf("</head>");
                    buffer.insert(endHeadIdx, "\n<base href='" + base + "'>\n");
                }
                HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            }
            return new DocumentationBrowserInformationControlInput(previousInput, element, buffer.toString(), leadingImageWidth, hoverRegion);
        }
        return null;
    }

    protected boolean isBrowserControlAvailable(final ITextViewer textViewer) {
        final boolean[] browserAvailable = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    browserAvailable[0] = CustomBrowserInformationControl.isAvailable((Composite)textViewer.getTextWidget().getShell());
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)UIEplPlugin.getDefault(), (Throwable)e);
                }
            }
        });
        return browserAvailable[0];
    }

    private void setHeader(String header, StringBuffer buffer, boolean useHTMLTags) {
        if (StringUtil.isEmpty((String)header)) {
            return;
        }
        if (useHTMLTags) {
            buffer.append("<div class=\"header\">");
            HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)header);
            buffer.append("</div>");
        } else {
            buffer.append('[');
            buffer.append(header);
            buffer.append("]\n");
        }
    }

    private void setDocumentation(String documentation, StringBuffer buffer, boolean useHTMLTags) {
        if (StringUtil.isEmpty((String)documentation)) {
            return;
        }
        if (!useHTMLTags) {
            documentation = AbstractDocumentationHover.stripBasicHTML(documentation);
        }
        buffer.append(documentation);
    }

    private String getStyleSheet() {
        if (styleSheet == null) {
            styleSheet = AbstractDocumentationHover.loadStyleSheet(this.getCSSPath());
        }
        if (styleSheet != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("Dialog")[0];
            return HTMLPrinter.convertTopLevelFont((String)styleSheet, (FontData)fontData);
        }
        return null;
    }

    protected void setCSSPath(String path) {
        this.cssPath = path;
    }

    protected String getCSSPath() {
        if (!StringUtil.isEmpty((String)this.cssPath)) {
            return this.cssPath;
        }
        return DOCUMENTATION_STYLE_CSS;
    }

    protected static String loadStyleSheet(String cssPath) {
        Bundle bundle = Platform.getBundle((String)"com.aptana.ui.epl");
        if (bundle == null) {
            return "";
        }
        URL styleSheetURL = bundle.getEntry(cssPath);
        if (styleSheetURL != null) {
            try {
                return IOUtil.read((InputStream)styleSheetURL.openStream());
            }
            catch (IOException ex) {
                IdeLog.logError((Plugin)UIEplPlugin.getDefault(), (String)"Documentation hover - Error loading the style-sheet", (Throwable)ex);
                return "";
            }
        }
        return "";
    }

    protected static String getHexColor(RGB rgb) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('#');
        AbstractDocumentationHover.appendAsHexString(buffer, rgb.red);
        AbstractDocumentationHover.appendAsHexString(buffer, rgb.green);
        AbstractDocumentationHover.appendAsHexString(buffer, rgb.blue);
        return buffer.toString();
    }

    protected static void appendAsHexString(StringBuilder buffer, int intValue) {
        String hexValue = Integer.toHexString(intValue);
        if (hexValue.length() == 1) {
            buffer.append('0');
        }
        buffer.append(hexValue);
    }

    public static void addImageAndLabel(StringBuffer buf, String imageName, int imageWidth, int imageHeight, int imageLeft, int imageTop, String label, int labelLeft, int labelTop) {
        if (imageName != null) {
            StringBuffer imageStyle = new StringBuffer("position: absolute; ");
            imageStyle.append("width: ");
            imageStyle.append(imageWidth);
            imageStyle.append("px; ");
            imageStyle.append("height: ");
            imageStyle.append(imageHeight);
            imageStyle.append("px; ");
            imageStyle.append("top: ");
            imageStyle.append(imageTop);
            imageStyle.append("px; ");
            imageStyle.append("left: ");
            imageStyle.append(imageLeft);
            imageStyle.append("px; ");
            buf.append("<!--[if lte IE 6]><![if gte IE 5.5]>\n");
            buf.append("<span style=\"");
            buf.append(imageStyle);
            buf.append("filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='");
            buf.append(imageName);
            buf.append("')\"></span>\n");
            buf.append("<![endif]><![endif]-->\n");
            buf.append("<!--[if !IE]>-->\n");
            buf.append("<img style='");
            buf.append(imageStyle);
            buf.append("' src='");
            buf.append(imageName);
            buf.append("'/>\n");
            buf.append("<!--<![endif]-->\n");
            buf.append("<!--[if gte IE 7]>\n");
            buf.append("<img style='");
            buf.append(imageStyle);
            buf.append("' src='");
            buf.append(imageName);
            buf.append("'/>\n");
            buf.append("<![endif]-->\n");
        }
        buf.append("<div style='word-wrap:break-word;");
        if (imageName != null) {
            buf.append("margin-left: ").append(labelLeft).append("px; ");
            buf.append("margin-top: ").append(labelTop).append("px; ");
        }
        buf.append("'>");
        buf.append(label);
        buf.append("</div>");
    }

    private static class CommonLocationListener
    extends LocationAdapter {
        private CustomBrowserInformationControl control;

        public CommonLocationListener(CustomBrowserInformationControl control) {
            this.control = control;
        }

        public void changing(LocationEvent event) {
            String loc = event.location;
            if ("about:blank".equals(loc)) {
                return;
            }
            event.doit = false;
            if (loc.startsWith("about:")) {
                return;
            }
            try {
                URI uri = new URI(loc);
            }
            catch (URISyntaxException e) {
                File file = new File(loc);
                if (!file.exists()) {
                    IdeLog.logError((Plugin)UIEplPlugin.getDefault(), (Throwable)e);
                    return;
                }
                URI uri = file.toURI();
                loc = uri.toASCIIString();
            }
            this.control.notifyDelayedInputChange(null);
            this.control.dispose();
            try {
                IWorkbenchBrowserSupport workbenchBrowserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                IWebBrowser webBrowser = workbenchBrowserSupport.createBrowser(null);
                if (webBrowser != null) {
                    webBrowser.openURL(new URL(loc));
                }
                return;
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)UIEplPlugin.getDefault(), (Throwable)e);
                event.doit = true;
                return;
            }
        }
    }

    private class HoverControlCreator
    extends AbstractReusableInformationControlCreator {
        private final IInformationControlCreator informationPresenterControlCreator;
        private final boolean fAdditionalInfoAffordance;

        public HoverControlCreator(IInformationControlCreator informationPresenterControlCreator) {
            this(informationPresenterControlCreator, false);
        }

        public HoverControlCreator(IInformationControlCreator informationPresenterControlCreator, boolean additionalInfoAffordance) {
            this.informationPresenterControlCreator = informationPresenterControlCreator;
            this.fAdditionalInfoAffordance = additionalInfoAffordance;
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            if (CustomBrowserInformationControl.isAvailable((Composite)parent)) {
                CustomBrowserInformationControl iControl = new CustomBrowserInformationControl(parent, null, EditorsUI.getTooltipAffordanceString()){

                    public IInformationControlCreator getInformationPresenterControlCreator() {
                        return HoverControlCreator.this.informationPresenterControlCreator;
                    }
                };
                iControl.setBackgroundColor(AbstractDocumentationHover.this.getBackgroundColor());
                iControl.setForegroundColor(AbstractDocumentationHover.this.getForegroundColor());
                return iControl;
            }
            return new DefaultInformationControl(parent, true);
        }

        public boolean canReuse(IInformationControl control) {
            if (!super.canReuse(control)) {
                return false;
            }
            if (control instanceof IInformationControlExtension4) {
                ((IInformationControlExtension4)control).setStatusText(EditorsUI.getTooltipAffordanceString());
            }
            return true;
        }
    }

    public static class PresenterControlCreator
    extends AbstractReusableInformationControlCreator {
        protected AbstractDocumentationHover documentationHover;

        public PresenterControlCreator(AbstractDocumentationHover documentationHover) {
            this.documentationHover = documentationHover;
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                ToolBarManager tbm = new ToolBarManager(0x800000);
                CustomBrowserInformationControl iControl = new CustomBrowserInformationControl(parent, null, tbm);
                iControl.setBackgroundColor(this.documentationHover.getBackgroundColor());
                iControl.setForegroundColor(this.documentationHover.getForegroundColor());
                this.documentationHover.populateToolbarActions(tbm, iControl);
                tbm.update(true);
                this.documentationHover.installLinkListener(iControl);
                return iControl;
            }
            return new DefaultInformationControl(parent, true);
        }
    }
}

