/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.dialogfields;

import com.aptana.ui.dialogfields.DialogField;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SelectionButtonDialogField
extends DialogField {
    private Button fButton;
    private boolean fIsSelected = false;
    private DialogField[] fAttachedDialogFields = null;
    private int fButtonStyle;

    public SelectionButtonDialogField(int buttonStyle) {
        this.fButtonStyle = buttonStyle;
    }

    public void attachDialogFields(DialogField[] dialogFields) {
        this.fAttachedDialogFields = dialogFields;
        DialogField[] dialogFieldArray = dialogFields;
        int n = dialogFields.length;
        int n2 = 0;
        while (n2 < n) {
            DialogField field = dialogFieldArray[n2];
            field.setEnabled(this.fIsSelected);
            ++n2;
        }
    }

    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Button button = this.getSelectionButton(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = nColumns;
        gd.horizontalAlignment = 4;
        if (this.fButtonStyle == 8) {
            gd.widthHint = SelectionButtonDialogField.getButtonWidthHint(button);
        }
        button.setLayoutData((Object)gd);
        return new Control[]{button};
    }

    public static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public int getNumberOfControls() {
        return 1;
    }

    public Button getSelectionButton() {
        return this.getSelectionButton(null);
    }

    public Button getSelectionButton(Composite group) {
        if (this.fButton == null) {
            this.assertCompositeNotNull(group);
            this.fButton = new Button(group, this.fButtonStyle);
            this.fButton.setFont(group.getFont());
            this.fButton.setText(this.fLabelText);
            this.fButton.setEnabled(this.isEnabled());
            this.fButton.setSelection(this.fIsSelected);
            this.fButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    SelectionButtonDialogField.this.doWidgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    SelectionButtonDialogField.this.doWidgetSelected(e);
                }
            });
        }
        return this.fButton;
    }

    private void doWidgetSelected(SelectionEvent e) {
        if (this.isOkToUse((Control)this.fButton)) {
            this.changeValue(this.fButton.getSelection());
        }
    }

    private void changeValue(boolean newState) {
        if (this.fIsSelected != newState) {
            this.fIsSelected = newState;
            if (this.fAttachedDialogFields != null) {
                boolean focusSet = false;
                DialogField[] dialogFieldArray = this.fAttachedDialogFields;
                int n = this.fAttachedDialogFields.length;
                int n2 = 0;
                while (n2 < n) {
                    DialogField field = dialogFieldArray[n2];
                    field.setEnabled(this.fIsSelected);
                    if (this.fIsSelected && !focusSet) {
                        focusSet = field.setFocus();
                    }
                    ++n2;
                }
            }
            this.dialogFieldChanged();
        } else if (this.fButtonStyle == 8) {
            this.dialogFieldChanged();
        }
    }

    public void setLabelText(String labeltext) {
        this.fLabelText = labeltext;
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setText(labeltext);
        }
    }

    public boolean isSelected() {
        return this.fIsSelected;
    }

    public void setSelection(boolean selected) {
        this.changeValue(selected);
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setSelection(selected);
        }
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setEnabled(this.isEnabled());
        }
    }

    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setSelection(this.fIsSelected);
        }
    }
}

