/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.dialogs;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.ui.dialogs.EplMessages;
import com.aptana.ui.epl.UIEplPlugin;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectSelectionDialog
extends SelectionStatusDialog {
    private TableViewer fTableViewer;
    private Set<IProject> fProjectsWithSpecifics;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    private static final String DIALOG_SETTINGS_SHOW_ALL = "ProjectSelectionDialog.show_all";
    private ViewerFilter fFilter;
    private Set<String> natureIDs;

    public ProjectSelectionDialog(Shell parentShell, Set<IProject> projectsWithSpecifics, Set<String> natureIDs) {
        super(parentShell);
        this.setTitle(EplMessages.ProjectSelectionDialog_title);
        this.setMessage(EplMessages.ProjectSelectionDialog_message);
        this.fProjectsWithSpecifics = projectsWithSpecifics;
        this.natureIDs = natureIDs;
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
        this.fFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return ProjectSelectionDialog.this.fProjectsWithSpecifics.contains(element);
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Font font = parent.getFont();
        composite.setFont(font);
        this.createMessageArea(composite);
        this.fTableViewer = new TableViewer(composite, 2816);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectSelectionDialog.this.doSelectionChanged(((IStructuredSelection)event.getSelection()).toArray());
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProjectSelectionDialog.this.okPressed();
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 250;
        data.widthHint = 300;
        this.fTableViewer.getTable().setLayoutData((Object)data);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fTableViewer.getControl().setFont(font);
        if (!CollectionsUtil.isEmpty(this.natureIDs)) {
            this.fTableViewer.addFilter(new ViewerFilter(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (!(element instanceof IProject)) return false;
                    IProject project = (IProject)element;
                    if (!project.isAccessible()) return false;
                    try {
                        String[] allNatures;
                        String[] stringArray = allNatures = project.getDescription().getNatureIds();
                        int n = allNatures.length;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) {
                                return false;
                            }
                            String nature = stringArray[n2];
                            if (ProjectSelectionDialog.this.natureIDs.contains(nature)) {
                                return true;
                            }
                            ++n2;
                        }
                    }
                    catch (CoreException e) {
                        IdeLog.logError((Plugin)UIEplPlugin.getDefault(), (Throwable)e);
                        return false;
                    }
                }
            });
        }
        Button checkbox = new Button(composite, 32);
        checkbox.setText(EplMessages.ProjectSelectionDialog_filter);
        checkbox.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        checkbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectSelectionDialog.this.updateFilter(((Button)e.widget).getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ProjectSelectionDialog.this.updateFilter(((Button)e.widget).getSelection());
            }
        });
        IDialogSettings dialogSettings = UIEplPlugin.getDefault().getDialogSettings();
        boolean doFilter = !dialogSettings.getBoolean(DIALOG_SETTINGS_SHOW_ALL) && !this.fProjectsWithSpecifics.isEmpty();
        checkbox.setSelection(doFilter);
        this.updateFilter(doFilter);
        IProject[] input = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.fTableViewer.setInput((Object)input);
        this.doSelectionChanged(new Object[0]);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void updateFilter(boolean selected) {
        if (selected) {
            this.fTableViewer.addFilter(this.fFilter);
        } else {
            this.fTableViewer.removeFilter(this.fFilter);
        }
        UIEplPlugin.getDefault().getDialogSettings().put(DIALOG_SETTINGS_SHOW_ALL, !selected);
    }

    private void doSelectionChanged(Object[] objects) {
        if (objects.length != 1) {
            this.setSelectionResult(null);
        } else {
            this.setSelectionResult(objects);
        }
    }

    protected void computeResult() {
    }
}

