/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.util;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public class StatusLineMessageTimerManager {
    static String message;
    static boolean isError;
    static IStatusLineManager statusLineManager;
    private static MessageTimerTask task;

    static {
        statusLineManager = null;
    }

    static IStatusLineManager getStatusLineManager() {
        try {
            IWorkbenchPartSite site = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite();
            return ((IViewSite)site).getActionBars().getStatusLineManager();
        }
        catch (Exception e) {
            try {
                return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getActionBars().getStatusLineManager();
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    static void setMessage(String newMessage, boolean newIsError) {
        message = newMessage;
        isError = newIsError;
        if (isError) {
            statusLineManager.setErrorMessage(message);
            Display.getCurrent().beep();
        } else {
            statusLineManager.setMessage(message);
        }
    }

    public static void setErrorMessage(String message, long timeout, boolean isError) {
        statusLineManager = StatusLineMessageTimerManager.getStatusLineManager();
        if (statusLineManager != null) {
            StatusLineMessageTimerManager.setMessage(message, isError);
            if (task != null) {
                task.cancel();
            }
            task = new MessageTimerTask(statusLineManager, message, isError);
            new Timer().schedule((TimerTask)task, timeout);
        }
    }

    static class MessageTimerTask
    extends TimerTask {
        String message;
        boolean isError;
        IStatusLineManager statusLineManager;

        public MessageTimerTask(IStatusLineManager statusLineManager, String message, boolean isError) {
            this.message = message;
            this.isError = isError;
            this.statusLineManager = statusLineManager;
        }

        public void run() {
            if (PlatformUI.getWorkbench().isClosing()) {
                return;
            }
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (display.isDisposed()) {
                return;
            }
            display.asyncExec(new Runnable(){

                public void run() {
                    if (StatusLineMessageTimerManager.statusLineManager == MessageTimerTask.this.statusLineManager && MessageTimerTask.this.message == StatusLineMessageTimerManager.message) {
                        if (MessageTimerTask.this.isError) {
                            StatusLineMessageTimerManager.statusLineManager.setErrorMessage("");
                        } else {
                            StatusLineMessageTimerManager.statusLineManager.setMessage("");
                        }
                    }
                }
            });
        }
    }
}

