/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.configurations.configurator;

import com.aptana.configurations.ConfigurationsPlugin;
import com.aptana.configurations.configurator.Configurator;
import com.aptana.configurations.configurator.IConfigurator;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfiguratorsRegistry {
    private static final String EXTENSION_POINT_ID = "com.aptana.configurations.configurators";
    private static final String ATT_PROCESSOR = "processor";
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static ConfiguratorsRegistry instance = null;
    private Set<IConfigurator> configurators;

    private ConfiguratorsRegistry() {
        this.loadExtensions();
    }

    public static ConfiguratorsRegistry getInstance() {
        if (instance == null) {
            instance = new ConfiguratorsRegistry();
        }
        return instance;
    }

    public Set<IConfigurator> getConfigurators(boolean enabledOnly) {
        if (enabledOnly) {
            HashSet<IConfigurator> enabledConfigurators = new HashSet<IConfigurator>(this.configurators.size());
            for (IConfigurator configurator : this.configurators) {
                if (!configurator.isEnabled()) continue;
                enabledConfigurators.add(configurator);
            }
            return Collections.unmodifiableSet(enabledConfigurators);
        }
        return Collections.unmodifiableSet(this.configurators);
    }

    private void loadExtensions() {
        Object[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        this.configurators = new HashSet<IConfigurator>(ArrayUtil.length((Object[])elements));
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            String id = element.getAttribute(ATT_ID);
            String name = element.getAttribute(ATT_NAME);
            String processorId = element.getAttribute(ATT_PROCESSOR);
            if (id != null && name != null && processorId != null) {
                this.configurators.add(new Configurator(name, id, processorId));
            } else {
                IdeLog.logError((Plugin)ConfigurationsPlugin.getDefault(), (String)"Error creating a configurator. One of the required attributes was one", null);
            }
            ++n2;
        }
    }
}

