/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui;

import com.aptana.core.logging.IdeLog;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.GitExecutable;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.internal.sharing.ConnectProviderOperation;
import com.aptana.git.ui.internal.wizards.Messages;
import com.aptana.projects.primary.natures.PrimaryNaturesManager;
import com.aptana.ui.util.UIUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneJob
extends Job {
    private static final String METADATA_FOLDER = ".metadata";
    private String sourceURI;
    private String dest;
    private boolean forceRootAsProject;
    private boolean shallowClone;
    private Set<IProject> createdProjects;

    public CloneJob(String sourceURI, String dest) {
        this(sourceURI, dest, false);
    }

    public CloneJob(String sourceURI, String dest, boolean forceRootAsProject) {
        this(sourceURI, dest, forceRootAsProject, false);
    }

    public CloneJob(String sourceURI, String dest, boolean forceRootAsProject, boolean shallow) {
        super(Messages.CloneWizard_Job_title);
        this.setUser(true);
        this.sourceURI = sourceURI;
        this.dest = dest;
        this.forceRootAsProject = forceRootAsProject;
        this.shallowClone = shallow;
        this.createdProjects = new HashSet<IProject>();
    }

    public IStatus run(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        try {
            if (this.getGitExecutable() == null) {
                throw new CoreException((IStatus)new Status(4, GitUIPlugin.getPluginId(), Messages.CloneJob_UnableToFindGitExecutableError));
            }
            IStatus result = this.getGitExecutable().clone(this.sourceURI, Path.fromOSString((String)this.dest), this.shallowClone, (IProgressMonitor)subMonitor.newChild(900));
            if (!result.isOK()) {
                IStatus iStatus = result;
                return iStatus;
            }
            try {
                Collection<File> existingProjects = null;
                if (!this.forceRootAsProject) {
                    existingProjects = this.collectProjectFilesFromDirectory(new File(this.dest), null, (IProgressMonitor)subMonitor.newChild(25));
                }
                if (existingProjects == null || existingProjects.size() <= 1) {
                    this.createExistingProject(new File(this.dest, ".project"), (IProgressMonitor)subMonitor.newChild(75));
                } else {
                    int step = 75 / existingProjects.size();
                    for (File file : existingProjects) {
                        if (file == null) continue;
                        this.createExistingProject(file, (IProgressMonitor)subMonitor.newChild(step));
                    }
                }
            }
            catch (CoreException e) {
                IdeLog.log((Plugin)GitUIPlugin.getDefault(), (IStatus)e.getStatus());
                IStatus iStatus = e.getStatus();
                return iStatus;
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
                Status status = new Status(4, GitUIPlugin.getPluginId(), e.getMessage(), e);
                return status;
            }
        }
        finally {
            subMonitor.done();
        }
        return Status.OK_STATUS;
    }

    private void setNatureFromContributions(IProject project) {
        List potentialNatures = PrimaryNaturesManager.getManager().getPotentialNatures(project);
        if (potentialNatures.size() > 0) {
            String[] natureIds = potentialNatures.toArray(new String[potentialNatures.size()]);
            try {
                IProjectDescription description = project.getDescription();
                description.setNatureIds(natureIds);
                project.setDescription(description, null);
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e);
            }
        }
    }

    protected GitExecutable getGitExecutable() {
        return GitExecutable.instance();
    }

    private Collection<File> collectProjectFilesFromDirectory(File directory, Set<String> directoriesVisited, IProgressMonitor monitor) {
        File file;
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        File[] contents = directory.listFiles();
        if (contents == null) {
            return Collections.emptyList();
        }
        HashSet<File> files = new HashSet<File>();
        if (directoriesVisited == null) {
            directoriesVisited = new HashSet<String>();
            try {
                directoriesVisited.add(directory.getCanonicalPath());
            }
            catch (IOException exception) {
                IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)exception, (String)"com.aptana.git.core/debug");
                StatusManager.getManager().handle((IStatus)new Status(4, GitUIPlugin.getPluginId(), exception.getLocalizedMessage(), (Throwable)exception));
            }
        }
        File[] fileArray = contents;
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            file = fileArray[n2];
            if (file != null && file.isFile() && file.getName().equals(".project")) {
                files.add(file);
                return files;
            }
            ++n2;
        }
        fileArray = contents;
        n = contents.length;
        n2 = 0;
        while (n2 < n) {
            block12: {
                file = fileArray[n2];
                if (file != null && file.isDirectory() && !file.getName().equals(METADATA_FOLDER)) {
                    block11: {
                        try {
                            String canonicalPath = file.getCanonicalPath();
                            if (directoriesVisited.add(canonicalPath)) break block11;
                            break block12;
                        }
                        catch (IOException exception) {
                            IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)exception, (String)"com.aptana.git.core/debug");
                            StatusManager.getManager().handle((IStatus)new Status(4, GitUIPlugin.getPluginId(), exception.getLocalizedMessage(), (Throwable)exception));
                        }
                    }
                    files.addAll(this.collectProjectFilesFromDirectory(file, directoriesVisited, monitor));
                }
            }
            ++n2;
        }
        return files;
    }

    private boolean createExistingProject(File existingDotProjectFile, IProgressMonitor monitor) throws CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            ProjectRecord record = new ProjectRecord(existingDotProjectFile);
            String projectName = record.getProjectName();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            final IProject project = workspace.getRoot().getProject(projectName);
            if (record.description == null) {
                record.description = workspace.newProjectDescription(projectName);
                Path locationPath = new Path(record.projectSystemFile.getParent());
                if (Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                    record.description.setLocation(null);
                } else {
                    record.description.setLocation((IPath)locationPath);
                }
            } else {
                record.description.setName(projectName);
            }
            sub.worked(5);
            this.doCreateProject(project, record.description, (IProgressMonitor)sub.newChild(75));
            if (!this.shallowClone) {
                ConnectProviderOperation connectProviderOperation = new ConnectProviderOperation(project);
                connectProviderOperation.run((IProgressMonitor)sub.newChild(20));
            } else {
                IFolder gitFolder = project.getFolder(".git");
                if (gitFolder.exists()) {
                    try {
                        gitFolder.delete(true, (IProgressMonitor)sub.newChild(20));
                    }
                    catch (CoreException e) {
                        IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e);
                    }
                }
            }
            UIUtils.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    CloneJob.this.setNatureFromContributions(project);
                }
            });
        }
        finally {
            if (sub != null) {
                sub.done();
            }
        }
        return true;
    }

    protected void doCreateProject(IProject project, IProjectDescription desc, IProgressMonitor monitor) throws CoreException {
        try {
            boolean autoAttach = Platform.getPreferencesService().getBoolean(GitPlugin.getPluginId(), "auto_attach_repos", true, null);
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.git.core");
            if (autoAttach) {
                prefs.putBoolean("auto_attach_repos", false);
                try {
                    prefs.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
            }
            project.create(desc, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
            project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            this.createdProjects.add(project);
            if (autoAttach) {
                prefs.remove("auto_attach_repos");
                try {
                    prefs.flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }
        }
        finally {
            monitor.done();
        }
    }

    public Set<IProject> getCreatedProjects() {
        return Collections.unmodifiableSet(this.createdProjects);
    }

    private static class ProjectRecord {
        File projectSystemFile;
        String projectName;
        IProjectDescription description;

        ProjectRecord(File file) {
            this.projectSystemFile = file;
            this.setProjectName();
        }

        private void setProjectName() {
            if (this.projectName == null) {
                try {
                    Path path = new Path(this.projectSystemFile.getPath());
                    if (this.isDefaultLocation((IPath)path)) {
                        this.projectName = path.segment(path.segmentCount() - 2);
                        this.description = ResourcesPlugin.getWorkspace().newProjectDescription(this.projectName);
                    } else {
                        this.description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)path);
                        this.projectName = this.description.getName();
                    }
                }
                catch (CoreException e) {
                    this.projectName = this.projectSystemFile.getParentFile().getName();
                }
            }
        }

        private boolean isDefaultLocation(IPath path) {
            if (path.segmentCount() < 2) {
                return false;
            }
            return path.removeLastSegments(2).toFile().equals(Platform.getLocation().toFile());
        }

        public String getProjectName() {
            return this.projectName;
        }
    }
}

