/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.actions;

import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.actions.AbstractDynamicBranchItem;
import com.aptana.git.ui.internal.actions.DeleteRemoteHandler;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class DeleteRemoteItem
extends AbstractDynamicBranchItem {
    public DeleteRemoteItem() {
    }

    public DeleteRemoteItem(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        IResource resource = this.getSelectedResource();
        if (resource == null) {
            return NO_CONTRIBUTION_ITEMS;
        }
        GitRepository repo = this.getGitRepositoryManager().getAttached(resource.getProject());
        if (repo == null) {
            return NO_CONTRIBUTION_ITEMS;
        }
        ArrayList<DeleteRemoteContributionItem> contributions = new ArrayList<DeleteRemoteContributionItem>();
        for (String remoteName : repo.remotes()) {
            contributions.add(new DeleteRemoteContributionItem(repo, remoteName));
        }
        return contributions.toArray(new IContributionItem[contributions.size()]);
    }

    private static class DeleteRemoteContributionItem
    extends ContributionItem {
        private GitRepository repo;
        private String remoteName;

        DeleteRemoteContributionItem(GitRepository repo, String remoteName) {
            this.repo = repo;
            this.remoteName = remoteName;
        }

        public void fill(Menu menu, int index) {
            MenuItem menuItem = new MenuItem(menu, 8, index);
            menuItem.setText(this.remoteName);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DeleteRemoteHandler.deleteRemote(DeleteRemoteContributionItem.this.repo, DeleteRemoteContributionItem.this.remoteName);
                }
            });
        }
    }
}

